/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part.lpv;

import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SshTargetLauncher
implements ISshTargetLauncher {
    private final @NonNull String commandPath;
    private boolean commandStopOnExit;
    private final @NonNull String commandUserName;
    private final @NonNull String commandWorkingDir;
    private final @NonNull TargetAddressString address;
    private final @NonNull String profileName;
    private final @NonNull String username;
    private final String password;
    private final String passkey;
    private final @NonNull String gatorPath;
    private final int sshPort;
    private final int gatorPort;

    public static @Nullable SshTargetLauncher create(@NonNull String addressStr, @NonNull String commandPath, @NonNull String commandWorkingDir, @NonNull String commandUserName, @NonNull String profileName, @NonNull String username, String password, String passkey, int sshPort, int gatorPort, @NonNull String gatorPath, boolean commandStopOnExit) {
        TargetAddressString address = new TargetAddressString(addressStr);
        if (!address.isValid()) {
            return null;
        }
        if (sshPort <= 0 || sshPort > 65535 || gatorPort <= 0 || gatorPort > 65535) {
            return null;
        }
        return new SshTargetLauncher(address, commandPath, commandWorkingDir, commandUserName, profileName, username, password, passkey, sshPort, gatorPort, gatorPath, commandStopOnExit);
    }

    private SshTargetLauncher(@NonNull TargetAddressString address, @NonNull String commandPath, @NonNull String commandWorkingDir, @NonNull String commandUserName, @NonNull String profileName, @NonNull String username, String password, String passkey, int sshPort, int gatorPort, @NonNull String gatorPath, boolean commandStopOnExit) {
        this.address = address;
        this.commandPath = commandPath;
        this.commandWorkingDir = commandWorkingDir;
        this.commandUserName = commandUserName;
        this.commandStopOnExit = commandStopOnExit;
        this.profileName = profileName;
        this.username = username;
        this.password = password;
        this.passkey = passkey;
        this.sshPort = sshPort;
        this.gatorPort = gatorPort;
        this.gatorPath = gatorPath;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SshTargetLauncher) {
            SshTargetLauncher that = (SshTargetLauncher)obj;
            return this.profileName.equals(that.profileName);
        }
        return false;
    }

    public String getCommandPath() {
        return this.commandPath;
    }

    public @NonNull String getCommandUsername() {
        return this.commandUserName;
    }

    public String getCommandWorkingDir() {
        return this.commandWorkingDir;
    }

    public @NonNull String getTargetAddress() {
        return this.address.toString();
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public boolean isCommandStopOnExit() {
        return this.commandStopOnExit;
    }

    public String toString() {
        return this.address.toString();
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPassKey() {
        return this.passkey;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public int getGatorPort() {
        return this.gatorPort;
    }

    public String getGatorPath() {
        return this.gatorPath;
    }
}

