/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part;

import com.arm.streamline.application.HelpContexts;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.authentication.TargetAuthentication;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.databrowser.IDeviceConnectionModel;
import com.arm.streamline.ui.part.GatordRunningErrorDialog;
import com.arm.streamline.ui.part.lpv.SshTargetLauncher;
import com.arm.streamline.ui.vm.IAndroidTargetDevice;
import com.arm.streamline.ui.vm.ILandingPageActionHandler;
import com.arm.streamline.ui.vm.ILandingPageAndroidSubViewViewModel;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import com.arm.streamline.ui.vm.ITargetLauncher;
import com.arm.streamline.utility.AdbRunnerFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javafx.collections.ObservableList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public final class LandingPageActionHandler
implements ILandingPageActionHandler {
    private final @NonNull IWebBrowser browser;
    private final @NonNull IDeviceConnectionModel deviceConnectionModel;
    private final @NonNull IWorkbenchHelpSystem helpSystem;

    public LandingPageActionHandler(@NonNull IDeviceConnectionModel deviceConnectionModel, @NonNull IWorkbenchHelpSystem helpSystem, @NonNull IWebBrowser browser) {
        this.deviceConnectionModel = deviceConnectionModel;
        this.helpSystem = helpSystem;
        this.browser = browser;
    }

    public void showAdvancedSettings() {
        this.deviceConnectionModel.showAdvancedSettings();
    }

    public boolean isAdvancedConfigModePreferred() {
        return this.deviceConnectionModel.isAdvancedConfigModePreferred();
    }

    public void setAdvancedConfigModePreference(boolean useAdvanced) {
        this.deviceConnectionModel.setAdvancedConfigModePreference(useAdvanced);
    }

    public void showAndroidTargetHelp() {
        this.helpSystem.displayHelpResource(HelpContexts.ANDROID_TARGET_SETUP_TOPIC_URL);
    }

    public void showCounterConfiguration(@NonNull ITargetLauncher activeTarget) {
        this.deviceConnectionModel.showCounterConfiguration(activeTarget);
    }

    public void showStreamlineMeTargetHelp() {
        try {
            this.browser.openURL(new URL("https://developer.arm.com/documentation/101816/latest/Getting-started-with-Streamline"));
        }
        catch (MalformedURLException | PartInitException e) {
            StreamlinePlugin.warning("Failed to open the external browser for page https://developer.arm.com/documentation/101816/latest/Getting-started-with-Streamline", e);
        }
    }

    public void showLinuxTargetHelp() {
        this.helpSystem.displayHelpResource(HelpContexts.LINUX_TARGET_SETUP_TOPIC_URL);
    }

    public void showStartCapture(@NonNull ITargetLauncher activeTarget) {
        this.deviceConnectionModel.showStartCapture(activeTarget);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ILandingPageAndroidSubViewViewModel.ErrorDialogResult showGatorRunningErrorDialog(@NonNull IAndroidTargetDevice adbDevice, @NonNull String messageHeader, @NonNull String messageBody, boolean hideUseButton, boolean hideStopButton) {
        GatordRunningErrorDialog gatordRunningErrorDialog = new GatordRunningErrorDialog(adbDevice, messageHeader, messageBody, hideUseButton, hideStopButton);
        return (ILandingPageAndroidSubViewViewModel.ErrorDialogResult)gatordRunningErrorDialog.showAndWaitForResult();
    }

    public boolean getProfileWithMaliCounters(@NonNull IAndroidTargetDevice selectedDevice) {
        return this.deviceConnectionModel.getProfileWithMaliCounters(selectedDevice);
    }

    public void setProfileWithMaliCounters(@NonNull IAndroidTargetDevice selectedDevice, boolean checkedState) {
        this.deviceConnectionModel.setProfileWithMaliCounters(selectedDevice, checkedState);
    }

    public @NonNull ResolutionMode getResolutionMode(@NonNull IAndroidTargetDevice selectedDevice) {
        return this.deviceConnectionModel.getResolutionMode(selectedDevice);
    }

    public void setResolutionMode(@NonNull IAndroidTargetDevice selectedDevice, @NonNull ResolutionMode resolutionMode) {
        this.deviceConnectionModel.setResolutionMode(selectedDevice, resolutionMode);
    }

    public boolean isProfileWithMaliCountersAddedForDevice(@NonNull IAndroidTargetDevice selectedDevice) {
        return this.deviceConnectionModel.isProfileWithMaliCountersAddedForDevice(selectedDevice);
    }

    public void setApplicationArgumentsHistory(@NonNull List<@NonNull String> history) {
        this.deviceConnectionModel.setApplicationArgumentsHistory(history);
    }

    public void setApplicationArgumentsHistoryRefreshCallback(@NonNull Runnable refreshCallback) {
        this.deviceConnectionModel.setApplicationArgumentsHistoryRefreshCallback(refreshCallback);
    }

    public @NonNull List<@NonNull String> getApplicationArgumentsHistory() {
        return this.deviceConnectionModel.getApplicationArgumentsHistory();
    }

    public boolean isDefaultAdbValid() {
        return AdbRunnerFactory.isDefaultAdbValid();
    }

    public void showSSHConfiguration(ObservableList<@NonNull ISshTargetLauncher> detectedDevices, ISshTargetLauncher sshTarget) {
        this.deviceConnectionModel.showSSHConfiguration(detectedDevices, sshTarget);
    }

    public @NonNull SshTargetLauncher[] getCachedTargets() {
        return TargetAuthentication.getCachedTargets();
    }
}

