/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.section;

import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.section.Element;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Section {
    private String name;
    private List<Element> elements;

    public Section() {
        this.name = "";
        this.elements = Collections.emptyList();
    }

    public Section(String name, List<Element> elements) {
        if (name == null || name.length() == 0) {
            throw new LogicError("Empty Section name.");
        }
        Pattern unformatted = Pattern.compile("[^a-zA-Z_\\d\\$]");
        Matcher matcher = unformatted.matcher(name);
        if (matcher.find() || !Character.isLowerCase(name.charAt(0))) {
            throw new LogicError("Invalid Section name (" + name + "). Use camel case.");
        }
        this.name = name;
        this.elements = elements;
    }

    public Section(String name, List<Element> elements, String regionName) {
        this(name, elements);
        this.name = regionName + "_" + this.name;
    }

    public int size() {
        return this.elements.size();
    }

    public String getName() {
        return this.name;
    }

    public List<Element> getElements() {
        return this.elements;
    }
}

