/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.section;

import com.arm.streamline.performanceadvisor.renderer.GsonExclude;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.ElementType;
import com.arm.streamline.performanceadvisor.section.TextStyle;
import java.util.HashMap;

public class KeyValue
extends Element {
    @GsonExclude
    private String key;
    @GsonExclude
    private String value;
    private TextStyle style;
    private String content;
    private String seleniumName;

    public KeyValue(String key, String value) {
        super(ElementType.KEY_VALUE);
        this.key = key;
        this.value = value;
        this.style = TextStyle.DESCRIPTION;
        this.content = key + ": " + value;
        this.seleniumName = key.toLowerCase().replaceAll("\\s", "_");
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getContent() {
        return this.content;
    }

    public String getSeleniumName() {
        return this.seleniumName;
    }

    public TextStyle getStyle() {
        return this.style;
    }

    public HashMap<String, String> asMap() {
        HashMap<String, String> jsonObj = new HashMap<String, String>();
        jsonObj.put(KeyValue.formatPropertyName(this.key), this.value);
        return jsonObj;
    }
}

