/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.section;

import com.arm.streamline.performanceadvisor.capturedata.BoundnessType;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.ElementType;
import com.arm.streamline.performanceadvisor.section.Unit;
import java.util.HashMap;
import java.util.Map;

public class BarChart
extends Element {
    private String[] names;
    private double[] values;
    private double max;
    private Unit unit;
    private String title;
    private String chartTitle;
    private String group;

    public BarChart(String name, double value, double max, Unit unit, String title, String chartTitle, String group) {
        this(new String[]{name}, new double[]{value}, max, unit, title, chartTitle, group);
    }

    public BarChart(String[] names, double[] values, double max, Unit unit, String title, String chartTitle, String group) {
        super(ElementType.BAR);
        if (names.length != values.length) {
            throw new LogicError("BarChart: array length mismatch");
        }
        this.title = title + " (" + String.valueOf((Object)unit) + ")";
        this.names = names;
        this.values = values;
        this.max = max;
        this.unit = unit;
        this.chartTitle = chartTitle;
        this.group = group;
    }

    public static BarChart create(Map<BoundnessType, Double> boundnessPercentages, double max, Unit unit, String title, String chartTitle, String group) {
        String[] names = (String[])boundnessPercentages.keySet().stream().map(Enum::toString).toArray(String[]::new);
        double[] values = boundnessPercentages.values().stream().mapToDouble(Double::doubleValue).toArray();
        return new BarChart(names, values, max, unit, title, chartTitle, group);
    }

    public String[] getNames() {
        return this.names;
    }

    public double[] getValues() {
        return this.values;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public String getChartTitle() {
        return this.chartTitle;
    }

    public String getTitle() {
        return this.title;
    }

    public double getMax() {
        return this.max;
    }

    public String getGroup() {
        return this.group;
    }

    public HashMap<String, HashMap<String, Double>> asMap() {
        HashMap<String, Double> groupJson = new HashMap<String, Double>();
        int i = 0;
        while (i < this.names.length) {
            groupJson.put(BarChart.formatPropertyName(this.names[i]), this.values[i]);
            ++i;
        }
        HashMap<String, HashMap<String, Double>> jsonObj = new HashMap<String, HashMap<String, Double>>();
        jsonObj.put(BarChart.formatPropertyName(this.title), groupJson);
        return jsonObj;
    }
}

