/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.json;

import com.arm.streamline.performanceadvisor.json.DualAxisChartJsonListDeserialiser;
import com.arm.streamline.performanceadvisor.json.JsonSection;
import com.arm.streamline.performanceadvisor.section.DualAxisChartJson;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class JsonSectionListDeserialiser
implements JsonDeserializer<List<JsonSection>> {
    private static final Type DUAL_AXIS_CHART_JSON_LIST_TYPE = new TypeToken<List<DualAxisChartJson>>(){}.getType();
    Gson gson;

    public JsonSectionListDeserialiser() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(DUAL_AXIS_CHART_JSON_LIST_TYPE, (Object)new DualAxisChartJsonListDeserialiser());
        this.gson = gsonBuilder.create();
    }

    public List<JsonSection> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) {
        if (!jsonElement.isJsonObject()) {
            throw new JsonParseException("Invalid json for section.");
        }
        ArrayList<JsonSection> sections = new ArrayList<JsonSection>();
        JsonObject jsonSectionsJsonObject = jsonElement.getAsJsonObject();
        for (String regionSectionName : jsonSectionsJsonObject.keySet()) {
            try {
                List regionSectionElements = (List)this.gson.fromJson(jsonSectionsJsonObject.get(regionSectionName), DUAL_AXIS_CHART_JSON_LIST_TYPE);
                if (regionSectionElements.isEmpty()) continue;
                sections.add(new JsonSection(regionSectionName, regionSectionElements));
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
        return sections;
    }
}

