/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.io;

import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.io.FileUtils;
import com.arm.streamline.performanceadvisor.io.PlatformUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public class UserProvidedPath {
    private Path userPath;
    private Path adjustedPath;

    public UserProvidedPath(Path userPath) {
        this.userPath = userPath;
        this.adjustedPath = PlatformUtils.adjustPathForMacWorkingDirectory(userPath);
    }

    public UserProvidedPath(Path userPath, Path adjustedPath) {
        this.userPath = userPath;
        this.adjustedPath = adjustedPath;
    }

    private UserProvidedPath(UserProvidedPath other) {
        this.userPath = other.userPath;
        this.adjustedPath = other.adjustedPath;
    }

    public Path getAdjustedPath() {
        return this.adjustedPath;
    }

    public Path getUserProvidedPath() {
        return this.userPath;
    }

    public boolean isEmpty() {
        return this.userPath.toString().isEmpty();
    }

    public boolean refersToSamePathAs(UserProvidedPath other) throws IOException {
        return FileUtils.isSameFile(this.adjustedPath, other.adjustedPath);
    }

    public String toString() {
        return String.format("userPath: %s, adjustedPath: %s", this.userPath, this.adjustedPath);
    }

    public void combineWithFilePath(Path filePath) {
        if (filePath.endsWith(File.separator)) {
            throw new FatalError("Invalid output file: " + String.valueOf(filePath));
        }
        this.adjustedPath = this.adjustedPath.toAbsolutePath().resolve(filePath).normalize();
        this.userPath = this.userPath.resolve(filePath).normalize();
    }

    public static UserProvidedPath combine(UserProvidedPath userProvidedPath, Path filePath) {
        UserProvidedPath result = new UserProvidedPath(userProvidedPath);
        result.combineWithFilePath(filePath);
        return result;
    }
}

