/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import com.arm.utils.NullChecking;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class BasicSeries
implements CounterSeries {
    private @NonNull String name;

    protected static double @NonNull [] cacheValue(@Nullable SoftReference<double @NonNull []> cachedValue, @NonNull Consumer<@NonNull SoftReference<double @NonNull []>> store, @NonNull Supplier<double @NonNull []> compute) {
        double[] cachedData;
        double[] dArray = cachedData = cachedValue != null ? cachedValue.get() : null;
        if (cachedData == null) {
            cachedData = compute.get();
            store.accept(new SoftReference<double[]>(cachedData));
        }
        return cachedData;
    }

    protected static boolean isAllZeroes(double @NonNull [] data) {
        double[] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            if (v != 0.0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public BasicSeries(@NonNull String name) {
        this.name = name;
    }

    @Override
    public boolean doNotShowIfAllZeroes() {
        return false;
    }

    @Override
    public String getColour() {
        return "";
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull ProblemList initialise(CaptureData captureData) {
        return new ProblemList();
    }

    @Override
    public final boolean isAllZeroes() {
        double[] data = this.toArray();
        return BasicSeries.isAllZeroes(data);
    }

    @Override
    public boolean isAverage() {
        return false;
    }

    @Override
    public boolean isMaximum() {
        return false;
    }

    @Override
    public boolean isMinimum() {
        return false;
    }

    @Override
    public boolean isPerFrame() {
        return false;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public final double @NonNull [] toArray(int start, int end) {
        double[] data = this.toArray();
        if (start == 0 && end == data.length) {
            return data;
        }
        if (start < 0 || start > end || end > this.getLength() || this.getLength() != 0 && start >= this.getLength()) {
            throw new LogicError("invalid array index for series " + this.getName());
        }
        return (double[])NullChecking.neverNull((Object)Arrays.copyOfRange(data, start, end));
    }
}

