/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturesource;

import com.arm.streamline.performanceadvisor.capturesource.CaptureHandler;
import com.arm.streamline.performanceadvisor.capturesource.TempDirectory;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class HandlerZipFile
extends CaptureHandler {
    private TempDirectory tempDir;

    @Override
    public boolean canProcessCapture(Path path) {
        return !Files.isDirectory(path, new LinkOption[0]) && this.isZipArchive(path);
    }

    @Override
    public File workingDirectory(UserProvidedPath path) {
        File capture = path.getAdjustedPath().toFile();
        Path rootFolder = this.getRootFolder(capture);
        if (rootFolder == null || !this.hasExpectedContent(this.getRootFileList(capture))) {
            throw new FatalError("Zip file does not contain a valid capture");
        }
        System.out.println("Extracting zip file to a temporary directory.");
        this.tempDir = new TempDirectory("pa_zip-");
        HandlerZipFile.extractZipArchive(capture, this.tempDir.getPath());
        return this.tempDir.getPath().resolve(rootFolder).toFile();
    }

    @Override
    public void close() {
        if (this.tempDir != null) {
            this.tempDir.close();
        }
    }

    private boolean isZipArchive(Path userPath) {
        boolean isZip = false;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zipFile = new ZipFile(userPath.toFile());){
                isZip = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            isZip = false;
        }
        return isZip;
    }

    Path getRootFolder(File file) {
        int folderCount = 0;
        Path rootFolder = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ZipFile zipFile = new ZipFile(file);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    Path path = Paths.get(entries.nextElement().getName(), new String[0]);
                    if (path.getNameCount() != 1 || !path.toString().toLowerCase().endsWith(".apc")) continue;
                    rootFolder = path.getFileName();
                    ++folderCount;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new FatalError("Problem reading zip file: " + e.getMessage(), e);
        }
        if (folderCount != 1) {
            rootFolder = null;
        }
        return rootFolder;
    }

    @Override
    protected List<String> getRootFileList(File file) {
        ArrayList<String> content = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zipFile = new ZipFile(file);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    boolean inRoot;
                    ZipEntry entry = entries.nextElement();
                    if (entry == null) continue;
                    Path path = Paths.get(entry.getName(), new String[0]);
                    boolean bl = inRoot = path.getNameCount() == 2;
                    if (!inRoot) continue;
                    content.add(path.getFileName().toString());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new FatalError("Problem reading zip file: " + e.getMessage(), e);
        }
        return content;
    }

    static void extractZipArchive(File file, Path destDir) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile zipFile = new ZipFile(file);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry == null) continue;
                    Path filePath = destDir.resolve(entry.getName());
                    if (entry.isDirectory()) {
                        String entryName = entry.getName();
                        if (entryName.equals("./") || entryName.equals("../")) continue;
                        Files.createDirectory(filePath, new FileAttribute[0]);
                        continue;
                    }
                    CheckedInputStream in = new CheckedInputStream(zipFile.getInputStream(entry), new CRC32());
                    Files.copy(in, filePath, StandardCopyOption.REPLACE_EXISTING);
                    if (entry.getCrc() == in.getChecksum().getValue()) continue;
                    throw new FatalError(entry.getName() + ": CRC error");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new FatalError("Failed to extract " + String.valueOf(file) + ": " + e.getMessage(), e);
        }
    }
}

