/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata.screenshot;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.FrameProvider;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.capturedata.screenshot.Screenshot;
import com.arm.streamline.performanceadvisor.capturedata.screenshot.ScreenshotUtils;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import com.arm.utils.NullChecking;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;

public class ScreenshotProvider
extends Provider {
    private static final int SCREENSHOT_HEIGHT = 200;
    private List<Path> screenshotPathList;
    private List<Path> screenshotFilenameList;
    private List<String> filteredScreenshotPathList;
    private List<Screenshot> screenshots;
    private UserProvidedPath lwiPath;
    private Optional<String> eglContext;

    public ScreenshotProvider(CaptureData captureData, UserProvidedPath lwiPath, Optional<String> eglContext) {
        super(captureData);
        this.lwiPath = lwiPath;
        this.screenshots = Collections.emptyList();
        this.screenshotPathList = Collections.emptyList();
        this.eglContext = eglContext;
    }

    @Override
    public ProblemList initialise() {
        ProblemList problemList = new ProblemList();
        if (this.lwiPath != null) {
            Application.LOG.fine("Looking for screenshots in " + String.valueOf(this.lwiPath.getAdjustedPath()));
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Stream<Path> walk = Files.walk(this.lwiPath.getAdjustedPath(), 1, new FileVisitOption[0]);){
                    this.screenshotPathList = walk.filter(f -> f.toString().endsWith(".png") || f.toString().endsWith(".bmp")).collect(Collectors.toCollection(ArrayList::new));
                    if (this.screenshotPathList.isEmpty()) {
                        problemList.addWarning("No screenshots found in " + String.valueOf(this.lwiPath.getUserProvidedPath()) + ".", "If this is not expected, check the interceptor was used correctly.");
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | UncheckedIOException e) {
                problemList.addError("Cannot read screenshot directory.", "Check directory exists and correct permissions are set.");
            }
        }
        return problemList;
    }

    @Override
    public void execute() {
        FrameProvider frameProvider = this.captureData.getFrameProvider();
        int numFrames = frameProvider.getNumFrames();
        double[] frameStarts = frameProvider.getFrameStarts();
        Path reportPath = this.captureData.getReportsPathList().get(0);
        Path reportDir = reportPath.getParent();
        String reportFileName = reportPath.getFileName().toString();
        if (reportFileName.contains(".html")) {
            reportFileName = reportFileName.replace(".html", "");
        } else if (reportFileName.contains(".json")) {
            reportFileName = reportFileName.replace(".json", "");
        }
        String newScreenshotDirName = reportFileName + "_images";
        this.screenshots = new ArrayList<Screenshot>();
        this.screenshotFilenameList = new ArrayList<Path>();
        this.filteredScreenshotPathList = new ArrayList<String>();
        if (this.eglContext.isPresent()) {
            System.out.println("Using EGL context " + this.eglContext.get());
        } else {
            this.eglContext = ScreenshotUtils.findDominantContext(this.screenshotPathList);
        }
        for (Path screenshot : this.screenshotPathList) {
            Optional<Integer> frameNumber;
            Optional<String> base64;
            if (this.eglContext.isPresent() && !screenshot.getFileName().toString().contains(this.eglContext.get()) || !(base64 = this.processScreenshot(screenshot)).isPresent() || !(frameNumber = ScreenshotUtils.getFrameNumberFromFilename(screenshot, numFrames)).isPresent()) continue;
            Integer num = frameNumber.get();
            double start = frameStarts[num];
            Path filename = screenshot.getFileName();
            this.screenshots.add(new Screenshot(num, start, base64.get(), 200));
            this.screenshotFilenameList.add(filename);
        }
        if (!this.screenshots.isEmpty()) {
            Path newScreenshotDirPath = reportDir.resolve(newScreenshotDirName).toAbsolutePath();
            if (Files.exists(newScreenshotDirPath, new LinkOption[0])) {
                Application.LOG.warning(newScreenshotDirPath.toString() + " already exists. The directory content will be overwritten.");
            }
            Application.LOG.fine("Copying screenshots to " + newScreenshotDirPath.toString());
            try {
                Files.createDirectories(newScreenshotDirPath, new FileAttribute[0]);
                for (Path file : this.screenshotFilenameList) {
                    String modifiedFileName = file.toString().replaceAll("\\.[^.]*$", "") + ".png";
                    Path source = Path.of(this.lwiPath.getAdjustedPath().toString(), file.toString());
                    Path dest = Path.of(newScreenshotDirPath.toString(), modifiedFileName);
                    this.filteredScreenshotPathList.add(Path.of(".", newScreenshotDirName, modifiedFileName).toString());
                    if (this.saveImageAsPng(source, dest)) continue;
                    Application.LOG.warning("Couldn't save screenshot " + source.toString());
                }
            }
            catch (IOException e) {
                Application.LOG.warning(Arrays.toString(e.getStackTrace()));
                Application.LOG.warning(e.toString());
                throw new FatalError("Couldn't copy screenshots to " + newScreenshotDirName.toString());
            }
        }
    }

    private Optional<BufferedImage> openImageAndRemoveAlpha(Path source) {
        BufferedImage img;
        try {
            img = ImageIO.read(source.toFile());
        }
        catch (IOException e) {
            Application.LOG.warning(Arrays.toString(e.getStackTrace()));
            Application.LOG.warning(e.toString());
            return Optional.empty();
        }
        if (img == null) {
            Application.LOG.warning(() -> String.valueOf(source) + " could not be read.");
            return Optional.empty();
        }
        img = this.removeAlphaChannel(img);
        return Optional.of((BufferedImage)NullChecking.neverNull((Object)img));
    }

    private boolean saveImageAsPng(Path source, Path destination) throws IOException {
        Optional<BufferedImage> optImg = this.openImageAndRemoveAlpha(source);
        if (optImg.isPresent()) {
            BufferedImage img = optImg.get();
            File output = new File(destination.toAbsolutePath().toString());
            ImageIO.write((RenderedImage)img, "PNG", output);
            return true;
        }
        return false;
    }

    private Optional<String> processScreenshot(Path path) {
        Optional<BufferedImage> optImg = this.openImageAndRemoveAlpha(path);
        if (optImg.isPresent()) {
            String base64;
            BufferedImage img = optImg.get();
            img = (BufferedImage)NullChecking.neverNull((Object)this.resizeImageForNewHeight((BufferedImage)NullChecking.neverNull((Object)img), 200));
            try {
                base64 = this.encodeImageInBase64(img);
            }
            catch (IOException e) {
                Application.LOG.warning(String.valueOf(path) + " could not be encoded into base64.");
                return Optional.empty();
            }
            return Optional.of((String)NullChecking.neverNull((Object)base64));
        }
        return Optional.empty();
    }

    public BufferedImage resizeImageForNewHeight(BufferedImage img, int newHeight) {
        double scalingFactor = (double)img.getWidth() / (double)img.getHeight();
        int newWidth = (int)Math.round((double)newHeight * scalingFactor);
        if (Application.LOG.isLoggable(Level.FINE)) {
            Application.LOG.fine("Resizing image from " + img.getHeight() + "h x " + img.getWidth() + "w to " + newHeight + "h x " + newWidth + "w");
        }
        Image resizedImage = img.getScaledInstance(newWidth, newHeight, 4);
        BufferedImage newImage = new BufferedImage(newWidth, newHeight, 1);
        Graphics2D g2d = newImage.createGraphics();
        g2d.drawImage(resizedImage, 0, 0, newWidth, newHeight, null);
        g2d.dispose();
        return newImage;
    }

    public BufferedImage removeAlphaChannel(BufferedImage img) {
        if (img.getColorModel().hasAlpha()) {
            int i = 0;
            while (i < img.getWidth()) {
                int j = 0;
                while (j < img.getHeight()) {
                    int rgb = img.getRGB(i, j);
                    rgb = 0xFF000000 | rgb;
                    img.setRGB(i, j, rgb);
                    ++j;
                }
                ++i;
            }
        }
        return img;
    }

    public String encodeImageInBase64(BufferedImage img) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "PNG", out);
        byte[] bytes = out.toByteArray();
        return Base64.getEncoder().encodeToString(bytes);
    }

    public List<Screenshot> getScreenshots() {
        return this.screenshots;
    }

    public List<String> getScreenshotPathList() {
        return this.filteredScreenshotPathList;
    }
}

