/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.CpuActivitySeries;
import com.arm.streamline.performanceadvisor.capturedata.CpuCyclesProcessor;
import com.arm.streamline.performanceadvisor.capturedata.CpuFallbackSeries;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.ResourceProblem;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import com.arm.streamline.performanceadvisor.counterseries.EmptySeries;

public class CpuProvider
extends Provider {
    private String mainThread;
    private CounterSeries cpuUsageSeries;
    private CounterSeries criticalUsageSeries;
    private CounterSeries aggregateCyclesSeries;
    private boolean forceCycles;

    public CpuProvider(CaptureData captureData, String mainThread, boolean forceCycles) {
        super(captureData);
        this.mainThread = mainThread;
        this.forceCycles = forceCycles;
    }

    @Override
    public ProblemList initialise() {
        this.criticalUsageSeries = new EmptySeries();
        this.aggregateCyclesSeries = new EmptySeries();
        CpuCyclesProcessor cpuCyclesProcessor = new CpuCyclesProcessor();
        ProblemList clusterProblems = cpuCyclesProcessor.initialise(this.captureData, this.forceCycles);
        if (this.mainThread != null) {
            Application.LOG.fine("Using CPU activity as a main thread was specified");
            this.cpuUsageSeries = new CpuActivitySeries(this.mainThread);
            return this.cpuUsageSeries.initialise(this.captureData);
        }
        if (!clusterProblems.hasError()) {
            Application.LOG.fine("Using CPU cycles counter for the CPU usage metric");
            this.criticalUsageSeries = cpuCyclesProcessor.getCriticalUsage();
            this.aggregateCyclesSeries = cpuCyclesProcessor.getAggregateCycles();
            this.cpuUsageSeries = cpuCyclesProcessor.getAverageUsage();
            return clusterProblems;
        }
        Application.LOG.warning("Could not find CPU cycles counter. Requesting CPU activity.");
        this.cpuUsageSeries = new CpuActivitySeries();
        ProblemList usageProblems = this.cpuUsageSeries.initialise(this.captureData);
        if (!usageProblems.hasError()) {
            Application.LOG.fine("Using CPU activity data for the CPU usage metric");
            return usageProblems;
        }
        Application.LOG.warning("CPU activity data not available. Requesting fallback CPU activity.");
        this.cpuUsageSeries = new CpuFallbackSeries();
        ProblemList fallbackProblems = this.cpuUsageSeries.initialise(this.captureData);
        if (!fallbackProblems.hasError()) {
            Application.LOG.fine("Using fallback CPU activity counter for the CPU usage metric");
            fallbackProblems.add(new ResourceProblem(ResourceProblem.Severity.WARNING, "Using fallback for CPU data - data may not be as accurate", "Please refer to the user guide to make sure you have the best CPU data available, note that for some devices this is unavoidable"));
            return fallbackProblems;
        }
        return new ProblemList(new ResourceProblem(ResourceProblem.Severity.ERROR, "Cannot find any CPU usage data", "Please refer to the user guide for methods of getting CPU usage data"));
    }

    @Override
    public void execute() {
    }

    public CounterSeries getUsage() {
        return this.cpuUsageSeries;
    }

    public CounterSeries getCyclesSeries() {
        return this.aggregateCyclesSeries;
    }

    public CounterSeries getCriticalUsage() {
        return this.criticalUsageSeries;
    }

    public String getMainThread() {
        return this.mainThread;
    }
}

