/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.ResourceProblem;
import com.arm.streamline.performanceadvisor.common.VectorUtils;
import com.arm.streamline.performanceadvisor.counterseries.BasicSeries;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CpuFallbackSeries
extends BasicSeries {
    private @Nullable ISeriesDataProvider activitySource = null;
    private double @Nullable [] cachedData = null;
    private @Nullable CaptureData captureData = null;

    private static double @NonNull [] generateCpuUsageData(@Nullable ISeriesDataProvider activitySource, @Nullable CaptureData captureData) {
        if (activitySource == null) {
            return new double[0];
        }
        if (captureData == null) {
            throw new LogicError("CpuFallbackSeries was not initialized");
        }
        ArrayList<double @NonNull []> coreData = new ArrayList<double[]>();
        for (ProcessingElementReference pe : activitySource.getCoreInformationProvider().getChannelDescriptors()) {
            coreData.add((double[])NullChecking.neverNull((Object)activitySource.getData(pe, 0, captureData.getBinCount(), null)));
        }
        coreData.sort((s0, s1) -> Double.compare(VectorUtils.avg(s1), VectorUtils.avg(s0)));
        int clusterSize = coreData.size() / 2;
        coreData = coreData.stream().limit(clusterSize).collect(Collectors.toList());
        return VectorUtils.div(VectorUtils.add(coreData), coreData.size());
    }

    public CpuFallbackSeries() {
        super("CPU usage");
    }

    @Override
    public int getLength() {
        CaptureData captureData = this.captureData;
        if (captureData == null) {
            return 0;
        }
        return captureData.getBinCount();
    }

    @Override
    public ProblemList initialise(CaptureData captureData) {
        this.captureData = captureData;
        ProblemList problems = new ProblemList();
        this.activitySource = captureData.getSeriesForName("CPU Activity", "User").orElse(null);
        if (this.activitySource == null) {
            String description = "Cannot find CPU usage.";
            String resolution = "Ensure your capture includes CPU Activity";
            problems.add(new ResourceProblem(ResourceProblem.Severity.ERROR, "Cannot find CPU usage.", "Ensure your capture includes CPU Activity"));
        }
        return problems;
    }

    @Override
    public boolean isPresent() {
        return this.activitySource != null;
    }

    @Override
    public double @NonNull [] toArray() {
        if (!this.isPresent()) {
            throw new LogicError("No data for series " + this.getName());
        }
        double[] cachedData = this.cachedData;
        if (cachedData == null) {
            this.cachedData = cachedData = CpuFallbackSeries.generateCpuUsageData(this.activitySource, this.captureData);
        }
        return cachedData;
    }
}

