/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.analyser;

import com.arm.streamline.performanceadvisor.analyser.Analyser;
import com.arm.streamline.performanceadvisor.analyser.AnalyserFactory;
import com.arm.streamline.performanceadvisor.analyser.BinnedData;
import com.arm.streamline.performanceadvisor.capturedata.BoundnessProvider;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.ClippedRegionsProvider;
import com.arm.streamline.performanceadvisor.capturedata.FpsProvider;
import com.arm.streamline.performanceadvisor.capturedata.Region;
import com.arm.streamline.performanceadvisor.capturedata.gpuprovider.GpuProvider;
import com.arm.streamline.performanceadvisor.capturedata.screenshot.Screenshot;
import com.arm.streamline.performanceadvisor.capturedata.screenshot.ScreenshotProvider;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.FpsBoundnessChart;
import com.arm.streamline.performanceadvisor.section.LineChart;
import com.arm.streamline.performanceadvisor.section.Section;
import com.arm.streamline.performanceadvisor.section.TextBlock;
import com.arm.streamline.performanceadvisor.section.TextStyle;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class FpsBoundnessAnalyserFactory
extends AnalyserFactory {
    @Override
    public Analyser create(CaptureData captureData) {
        return new FpsBoundnessAnalyser(captureData);
    }

    public class FpsBoundnessAnalyser
    extends Analyser {
        private FpsProvider fpsProvider;
        private GpuProvider gpuProvider;
        private BoundnessProvider boundnessProvider;
        private ClippedRegionsProvider clippedRegionsProvider;

        public FpsBoundnessAnalyser(CaptureData captureData) {
            super(captureData);
        }

        @Override
        public ProblemList initialise() {
            this.fpsProvider = this.captureData.getFpsProvider();
            this.gpuProvider = this.captureData.getGpuProvider();
            this.boundnessProvider = this.captureData.getBoundnessProvider();
            this.clippedRegionsProvider = this.captureData.getClippedRegionsProvider();
            return new ProblemList();
        }

        @Override
        public Section execute(int userRegion) {
            LineChart hiddenLineChart;
            if (userRegion != 0) {
                throw new LogicError("Interactive FPS analysis chart is only for the overall capture");
            }
            String heading = this.fpsProvider.getPerFrame().getNameToDisplayLong() + " analysis";
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.add(new TextBlock(TextStyle.H2_HIDDEN, heading.substring(0, 1).toUpperCase() + heading.substring(1), "The " + heading + " chart shows how your frame rate changes in response to areas where your application is bound. To zoom in and analyze further, click and drag any part of the chart, or click on a region name if your capture contains defined regions. Click anywhere on the chart to reset the zoom.<p>If you have captured images when your frame rate dropped below a threshold value, hover over the icon inside the chart to expand the image.</p>"));
            Region region = this.clippedRegionsProvider.getClippedRegion(userRegion);
            int regionStartMs = region.getStart();
            int regionEndMs = region.getEnd();
            double[] frameSeriesData = this.fpsProvider.getPerBin().getSeriesToDisplay().toArray(regionStartMs, regionEndMs);
            int binSize = this.captureData.getPerFrameBinSizeMs();
            int samplesPerSecond = this.captureData.getSamplesPerSecond();
            BinnedData data = new BinnedData(binSize, samplesPerSecond, regionStartMs);
            data.addSeries(frameSeriesData, "FPS", false);
            ScreenshotProvider screenshotProvider = this.captureData.getScreenshotProvider();
            List<Screenshot> screenshotList = screenshotProvider.getScreenshots();
            List<String> screenshotPathList = screenshotProvider.getScreenshotPathList();
            ArrayList<Integer> screenshotBins = new ArrayList<Integer>();
            for (Screenshot screenshot : screenshotList) {
                screenshotBins.add((int)((screenshot.getTimeInMs() - (double)regionStartMs) / (double)binSize));
            }
            String group = "overall";
            LinkedHashMap<String, String> boundnessTypesWithCssRules = new LinkedHashMap<String, String>();
            this.gpuProvider.getBoundnessTypes().forEach(type -> {
                String string = boundnessTypesWithCssRules.put(type.toString(), type.getCssRule());
            });
            FpsBoundnessChart chart = FpsBoundnessChart.builder().setXAxis(data.getTimes()[0], data.getTimes().length, data.getBinDurationMs()).setYAxis(data.getSeries(0), this.fpsProvider.getPerFrame().getNameToDisplayShort()).setBoundness(this.boundnessProvider.getBoundnessRegions(regionStartMs, regionEndMs)).setRegions(this.clippedRegionsProvider.getClippedUserRegions()).setVSync(this.captureData.getTargetFrameRate().getTarget()).addScreenshots(screenshotList, screenshotBins, screenshotPathList).setGroup("overall").setCentiles(this.captureData.getOptions().getCentiles()).setBoundnessTypesWithCssRules(boundnessTypesWithCssRules).build();
            elements.add(chart);
            BinnedData lineChartBinnedData = new BinnedData(this.captureData.getPerFrameBinSizeMs(), this.captureData.getSamplesPerSecond(), 0.0);
            if (this.fpsProvider.getTargetFrameRate().getDisplayAsFrameTime()) {
                lineChartBinnedData.addSeries(this.fpsProvider.getPerBin().toArray(), "FPS", false);
                hiddenLineChart = new LineChart("Time (s)", lineChartBinnedData.getName(0), lineChartBinnedData.getTimes(), lineChartBinnedData.getSeries(0), "overall");
            } else {
                lineChartBinnedData.addSeries(this.fpsProvider.getPerBin().getMspf().toArray(), "msPerFrame", false);
                hiddenLineChart = new LineChart("Time (s)", lineChartBinnedData.getName(0), lineChartBinnedData.getTimes(), lineChartBinnedData.getSeries(0), "overall");
            }
            hiddenLineChart.setExcludeFromHtml(true);
            elements.add(hiddenLineChart);
            return new Section("fpsBoundness", elements);
        }
    }
}

