/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor;

import com.arm.streamline.performanceadvisor.RawOptions;
import com.arm.streamline.performanceadvisor.capturedata.ClipIndicator;
import com.arm.streamline.performanceadvisor.capturedata.ClipIndicatorParseException;
import com.arm.streamline.performanceadvisor.capturedata.ClipIndicatorParser;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.common.LogLevel;
import com.arm.streamline.performanceadvisor.common.TargetFrameRate;
import com.arm.streamline.performanceadvisor.io.PathValidation;
import com.arm.streamline.performanceadvisor.io.PlatformUtils;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import com.arm.streamline.performanceadvisor.renderer.RendererOptions;
import com.arm.streamline.performanceadvisor.report.ReportConfig;
import com.arm.streamline.performanceadvisor.report.ReportRequest;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import picocli.CommandLine;

public class Options {
    private final RawOptions raw;
    private final CommandLine cmd;
    private RendererOptions rendererOptions;
    private UserProvidedPath validatedLwiPath;
    private UserProvidedPath customReportPath;
    private UserProvidedPath directoryPath;
    private UserProvidedPath customCounterAliasesDirPath;
    private UserProvidedPath logOutputPath;
    private Optional<UserProvidedPath> regionsFilePath;
    private Optional<Double> minRegionLength;
    private Optional<Integer> maxRegionDepth;
    private ClipIndicator clipStartIndicator;
    private ClipIndicator clipEndIndicator;
    private TargetFrameRate targetFrameRate;
    private @NonNull List<@NonNull ReportRequest> reportRequests;
    private @NonNull ReportConfig reportConfig;

    public Options(@NonNull RawOptions options, @NonNull CommandLine cmd, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CommandLine.ParseResult parseResult) {
        this.raw = options;
        this.cmd = cmd;
        this.directoryPath = Options.adjustDefaultOutputDirectory(options);
        this.regionsFilePath = Options.setAndValidateRegionsFilePath(options);
        this.minRegionLength = Options.setAndValidateMinimumRegionLength(options);
        this.maxRegionDepth = Options.setAndValidateMaximumRegionDepth(options);
        this.validatedLwiPath = Options.setAndValidateLwiCapturePath(options);
        this.customReportPath = Options.setAndValidateCustomReportPath(options);
        this.customCounterAliasesDirPath = Options.setAndValidateCustomCounterAliasesDirPath(options);
        this.logOutputPath = Options.adjustAndValidateLogOutputPath(options);
        this.clipStartIndicator = Options.createClipIndicator(options.getClipStart(), "Start clip");
        this.clipEndIndicator = Options.createClipIndicator(options.getClipEnd(), "End clip");
        this.targetFrameRate = new TargetFrameRate(options.getTargetFps(), options.getDisplayMspf());
        this.rendererOptions = Options.validateAndCreateRendererOptions(options);
        this.reportRequests = Options.findReportRequests(parseResult);
        int windowSize = Options.validateWindowSize(options);
        this.reportConfig = new ReportConfig(Options.isCsvReportRequested(this.reportRequests), windowSize);
    }

    public @NonNull ReportConfig getReportConfig() {
        return this.reportConfig;
    }

    public void validateFilenameCount(int numExpected, String errorText) {
        List<String> fileNames = this.getFileNames();
        if (fileNames.isEmpty()) {
            throw new CommandLine.ParameterException(this.cmd, "Syntax error. " + errorText);
        }
        if (fileNames.size() != numExpected) {
            StringBuilder errMsg = new StringBuilder("Syntax error. ");
            if (fileNames.size() > numExpected) {
                errMsg.append("Too many");
            } else {
                errMsg.append("Not enough");
            }
            errMsg.append(" filenames:");
            for (String s : fileNames) {
                errMsg.append(String.format("%n  %s", s));
            }
            errMsg.append(String.format("%n%s", errorText));
            throw new CommandLine.ParameterException(this.cmd, errMsg.toString());
        }
    }

    private static UserProvidedPath adjustDefaultOutputDirectory(RawOptions options) {
        UserProvidedPath outputDir = options.getOutputDirectory();
        if (outputDir == null) {
            outputDir = new UserProvidedPath(Path.of("", new String[0]), PlatformUtils.adjustPathForMacWorkingDirectory(PlatformUtils.getCwd()));
        }
        return outputDir;
    }

    private static UserProvidedPath setAndValidateLwiCapturePath(RawOptions options) {
        UserProvidedPath frameCapturePath = options.getFrameCapturePath();
        if (frameCapturePath != null) {
            PathValidation.fatalErrorIfInvalidReadableDirectory(frameCapturePath);
        }
        return frameCapturePath;
    }

    private static UserProvidedPath setAndValidateCustomReportPath(RawOptions options) {
        UserProvidedPath rawCustomReportPath = options.getCustomReportPath();
        if (rawCustomReportPath != null) {
            PathValidation.fatalErrorIfInvalidReadableFile(rawCustomReportPath);
        }
        return rawCustomReportPath;
    }

    private static UserProvidedPath setAndValidateCustomCounterAliasesDirPath(RawOptions options) {
        UserProvidedPath rawCustomCounterAliasesDirPath = options.getCounterAliasesDirPath();
        if (rawCustomCounterAliasesDirPath != null) {
            PathValidation.fatalErrorIfInvalidReadableDirectory(rawCustomCounterAliasesDirPath);
        }
        return rawCustomCounterAliasesDirPath;
    }

    private static UserProvidedPath adjustAndValidateLogOutputPath(RawOptions options) {
        UserProvidedPath logOutput = options.getLogFilePath();
        if (logOutput != null) {
            PathValidation.fatalErrorIfInvalidForFileWrite(logOutput);
        }
        return logOutput;
    }

    private static int validateWindowSize(RawOptions options) {
        if (options.getWindowSize() <= 0) {
            throw new FatalError("Window size for averaging csv report values must be greater than zero");
        }
        return options.getWindowSize();
    }

    private static Optional<UserProvidedPath> setAndValidateRegionsFilePath(RawOptions options) {
        Optional<UserProvidedPath> path = Optional.ofNullable(options.getRegionsFilePath());
        if (path.isPresent()) {
            if (path.get().isEmpty()) {
                throw new FatalError("Missing regions filename");
            }
            PathValidation.fatalErrorIfInvalidReadableFile(path.get());
        }
        return path;
    }

    private static Optional<Double> setAndValidateMinimumRegionLength(RawOptions options) {
        Optional<Double> length = Optional.ofNullable(options.getMinimumRegionLength());
        if (length.isPresent() && length.get() <= 0.0) {
            throw new FatalError("Minimum region length must be greater than zero seconds");
        }
        return length;
    }

    private static Optional<Integer> setAndValidateMaximumRegionDepth(RawOptions options) {
        Optional<Integer> depth = Optional.ofNullable(options.getMaximumRegionDepth());
        if (depth.isPresent() && depth.get() <= 0) {
            throw new FatalError("Maximum region depth must be greater than zero");
        }
        return depth;
    }

    private static @NonNull ReportConfig.CsvReportStatus isCsvReportRequested(@NonNull List<@NonNull ReportRequest> reportRequests) {
        Optional<ReportRequest> optReport = reportRequests.stream().filter(rep -> rep.getType().compareToIgnoreCase("csv") == 0).findFirst();
        return optReport.isPresent() ? ReportConfig.CsvReportStatus.ENABLED : ReportConfig.CsvReportStatus.DISABLED;
    }

    private static ClipIndicator createClipIndicator(String clipStr, String desc) {
        ClipIndicator clipIndicator = null;
        if (clipStr != null) {
            try {
                clipIndicator = ClipIndicatorParser.parse(clipStr);
            }
            catch (ClipIndicatorParseException e) {
                throw new FatalError(desc + " " + String.valueOf(clipIndicator) + " in invalid format.");
            }
        }
        return clipIndicator;
    }

    private static RendererOptions validateAndCreateRendererOptions(RawOptions options) {
        return new RendererOptions(options.getCentiles(), options.getPrettyPrint());
    }

    private static @NonNull List<@NonNull ReportRequest> findReportRequests(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CommandLine.ParseResult parseResult) {
        ArrayList reportRequests = (ArrayList)parseResult.matchedOptionValue('t', new ArrayList());
        if (reportRequests.isEmpty()) {
            String defaultReportType = "html";
            reportRequests.add(new ReportRequest("html"));
        }
        return Collections.unmodifiableList(reportRequests);
    }

    public String getProcessName() {
        return this.raw.getProcessName();
    }

    public String getMainThread() {
        return this.raw.getMainThread();
    }

    public boolean getShowProgress() {
        return this.raw.getShowProgress();
    }

    public boolean getForceCycles() {
        return this.raw.getForceCycles();
    }

    public Path getChartListOutputPath() {
        return this.raw.getChartListOutputPath();
    }

    public boolean getDisplayMspf() {
        return this.raw.getDisplayMspf();
    }

    public boolean getPrettyPrint() {
        return this.raw.getPrettyPrint();
    }

    public LogLevel getLogLevel() {
        return this.raw.getLogLevel();
    }

    public boolean getShowProfile() {
        return this.raw.getShowProfile();
    }

    public String getClipStart() {
        return this.raw.getClipStart();
    }

    public String getClipEnd() {
        return this.raw.getClipEnd();
    }

    public int[] getCentiles() {
        return this.raw.getCentiles();
    }

    public int getTargetFps() {
        return this.raw.getTargetFps();
    }

    public int getWindowSize() {
        return this.raw.getWindowSize();
    }

    public boolean getDeveloperMode() {
        return this.raw.getDeveloperMode();
    }

    public RawOptions.ProvenanceArgs getProvenanceArgs() {
        return this.raw.getProvenanceArgs();
    }

    public String getAppName() {
        return this.raw.getProvenanceArgs().appName;
    }

    public String getAppBuildName() {
        return this.raw.getProvenanceArgs().appBuildName;
    }

    public String getAppBuildTimestamp() {
        return this.raw.getProvenanceArgs().appBuildTimestamp;
    }

    public String getDeviceName() {
        return this.raw.getProvenanceArgs().deviceName;
    }

    public String getPackageName() {
        return this.raw.getProvenanceArgs().packageName;
    }

    public String getActivityName() {
        return this.raw.getProvenanceArgs().activityName;
    }

    public String getActivityArguments() {
        return this.raw.getProvenanceArgs().activityArguments;
    }

    public @NonNull List<@NonNull ReportRequest> getReportRequests() {
        return this.reportRequests;
    }

    public Map<String, Double> getBudgets() {
        return this.raw.getBudgets();
    }

    public UserProvidedPath getValidatedLwiPath() {
        return this.validatedLwiPath;
    }

    public UserProvidedPath getCustomReportPath() {
        return this.customReportPath;
    }

    public UserProvidedPath getCustomCounterAliasesDirPath() {
        return this.customCounterAliasesDirPath;
    }

    public TargetFrameRate getTargetFrameRate() {
        return this.targetFrameRate;
    }

    public RendererOptions getRendererOptions() {
        return this.rendererOptions;
    }

    public ClipIndicator getStartClipIndicator() {
        return this.clipStartIndicator;
    }

    public ClipIndicator getEndClipIndicator() {
        return this.clipEndIndicator;
    }

    public List<String> getFileNames() {
        List<String> names = this.raw.getFileNames() == null ? Collections.emptyList() : Arrays.asList(this.raw.getFileNames());
        return names;
    }

    public UserProvidedPath getOutputDirectory() {
        return this.directoryPath;
    }

    public UserProvidedPath getLogFilePath() {
        return this.logOutputPath;
    }

    public boolean getDiffReportRequested() {
        return this.raw.getDiffReportRequested() || this.raw.getDiffReportFilePath() != null;
    }

    public Optional<UserProvidedPath> getRegionsFilePath() {
        return this.regionsFilePath;
    }

    public Optional<Double> getMinimumRegionLength() {
        return this.minRegionLength;
    }

    public Optional<Integer> getMaximumRegionDepth() {
        return this.maxRegionDepth;
    }

    public Optional<Path> getDiffReportFilePath() {
        return Optional.ofNullable(this.raw.getDiffReportFilePath());
    }

    public Optional<String> getEglContext() {
        return Optional.ofNullable(this.raw.getEglContext());
    }
}

