/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor;

import com.arm.streamline.performanceadvisor.AnalysisDriver;
import com.arm.streamline.performanceadvisor.DiffDriver;
import com.arm.streamline.performanceadvisor.Options;
import com.arm.streamline.performanceadvisor.RawOptions;
import com.arm.streamline.performanceadvisor.ReportDriver;
import com.arm.streamline.performanceadvisor.analyser.AnalyserLibrary;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.common.InsufficientDataException;
import com.arm.streamline.performanceadvisor.common.LogFormatter;
import com.arm.streamline.performanceadvisor.common.LogLevel;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.Profiler;
import com.arm.streamline.performanceadvisor.common.SimpleProfiler;
import com.arm.streamline.performanceadvisor.common.VersionProvider;
import com.arm.streamline.performanceadvisor.config.ConfigOptions;
import com.arm.streamline.performanceadvisor.developer.BinningTestReportHandler;
import com.arm.streamline.performanceadvisor.developer.DualAxisTestReportHandler;
import com.arm.streamline.performanceadvisor.developer.PerFrameScalingTestReportHandler;
import com.arm.streamline.performanceadvisor.io.PathValidation;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import com.arm.streamline.performanceadvisor.report.CsvReportHandler;
import com.arm.streamline.performanceadvisor.report.HandlerRegistry;
import com.arm.streamline.performanceadvisor.report.HtmlReportHandler;
import com.arm.streamline.performanceadvisor.report.JsonReportHandler;
import com.arm.streamline.performanceadvisor.report.ReportHandler;
import com.arm.streamline.performanceadvisor.report.ReportRequest;
import com.arm.streamline.performanceadvisor.report.ReportRequestConverter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.stream.Collectors;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.jdt.annotation.NonNull;
import picocli.CommandLine;

public class Application {
    public static final Profiler PROFILER = new SimpleProfiler();
    public static final Logger LOG = Logger.getGlobal();

    public Integer start(@NonNull List<@NonNull String> args) {
        int exitSuccess = IApplication.EXIT_OK;
        boolean exitFailure = true;
        Integer result = 1;
        try {
            AnalyserLibrary library = new AnalyserLibrary();
            ConfigOptions configOptions = new ConfigOptions();
            ArrayList configItems = new ArrayList();
            library.addAllConfigItems(configItems);
            configOptions.addConfigItems(configItems);
            HandlerRegistry handlerRegistry = new HandlerRegistry();
            handlerRegistry.register(new HtmlReportHandler());
            handlerRegistry.register(new JsonReportHandler());
            handlerRegistry.register(new CsvReportHandler());
            VersionProvider versionProvider = new VersionProvider();
            if (!versionProvider.isRelease()) {
                handlerRegistry.register(new BinningTestReportHandler());
                handlerRegistry.register(new DualAxisTestReportHandler());
                handlerRegistry.register(new PerFrameScalingTestReportHandler());
            }
            RawOptions rawOptions = new RawOptions();
            CommandLine cmd = new CommandLine((Object)rawOptions);
            cmd.registerConverter(ReportRequest.class, (CommandLine.ITypeConverter)new ReportRequestConverter());
            cmd.registerConverter(UserProvidedPath.class, s -> new UserProvidedPath(Path.of(s, new String[0])));
            cmd.setUseSimplifiedAtFiles(true);
            cmd.setTrimQuotes(true);
            cmd.setCaseInsensitiveEnumValuesAllowed(true);
            CommandLine.Model.CommandSpec cmdSpec = cmd.getCommandSpec();
            cmdSpec.usageMessage().header(new String[]{Arrays.toString(versionProvider.getVersion()).replace("[", "").replace("]", "")});
            this.addDynamicReportTypeOption(cmdSpec, handlerRegistry, false);
            configOptions.addToCommandSpec(cmdSpec, versionProvider.isRelease());
            String[] argsArray = new String[args.size()];
            CommandLine.ParseResult parseResult = cmd.parseArgs(this.getAppArgs(args.toArray(argsArray)));
            boolean isDeveloperMode = rawOptions.getDeveloperMode();
            if (isDeveloperMode && !versionProvider.isRelease()) {
                this.unhideOptionsForHelpMessage(cmdSpec);
                this.addDynamicReportTypeOption(cmdSpec, handlerRegistry, true);
            }
            if (!CommandLine.printHelpIfRequested((CommandLine.ParseResult)parseResult)) {
                Options options = new Options(rawOptions, cmd, parseResult);
                configOptions.update(parseResult, isDeveloperMode);
                this.configureLogger(options.getLogLevel(), options.getLogFilePath(), versionProvider.isRelease());
                this.logConfigurationOptions(parseResult);
                ReportDriver driver = options.getDiffReportRequested() ? new DiffDriver() : new AnalysisDriver(handlerRegistry, library, versionProvider);
                driver.validate(options);
                driver.generate();
            }
            result = exitSuccess;
        }
        catch (CommandLine.UnmatchedArgumentException e) {
            this.handleUnmatchedArgumentException(e);
        }
        catch (CommandLine.ParameterException e) {
            this.handleException(e, e.getCommandLine());
        }
        catch (LogicError | NoSuchElementException | CommandLine.InitializationException e) {
            this.handleException(e);
        }
        catch (InsufficientDataException e) {
        }
        catch (FatalError e) {
            this.handleException(e);
        }
        catch (InterruptedException e) {
            this.handleException(e, null, false, true);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.handleException(e, null, false, true);
        }
        return result;
    }

    private void addDynamicReportTypeOption(CommandLine.Model.CommandSpec cmdSpec, HandlerRegistry handlerRegistry, boolean developerMode) {
        int typeWidth = handlerRegistry.getMaxTypeLength();
        StringBuilder typeHelp = new StringBuilder("Comma-separated list of report types:%n");
        for (ReportHandler i : handlerRegistry) {
            if (!developerMode && i.isHidden()) continue;
            StringBuilder fmtSpec = new StringBuilder();
            fmtSpec.append("  %-");
            fmtSpec.append(typeWidth);
            fmtSpec.append("s  %s%%n");
            typeHelp.append(String.format(fmtSpec.toString(), i.getType(), i.getDescription()));
        }
        typeHelp.append("An output filename can be specified for each report.");
        CommandLine.Model.OptionSpec existingOption = cmdSpec.findOption("type");
        if (existingOption != null) {
            cmdSpec.remove((CommandLine.Model.ArgSpec)existingOption);
        }
        cmdSpec.addOption(((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)"-t", (String[])new String[]{"--type"}).paramLabel("type[:file]")).type(List.class)).splitRegex(",")).auxiliaryTypes(new Class[]{ReportRequest.class})).description(new String[]{typeHelp.toString()})).build());
    }

    private void unhideOptionsForHelpMessage(CommandLine.Model.CommandSpec cmdSpec) {
        List optionsList = cmdSpec.options();
        ArrayList<CommandLine.Model.OptionSpec> hiddenOptions = new ArrayList<CommandLine.Model.OptionSpec>();
        for (CommandLine.Model.OptionSpec option : optionsList) {
            if (!option.hidden()) continue;
            hiddenOptions.add(option);
        }
        for (CommandLine.Model.OptionSpec i : hiddenOptions) {
            CommandLine.Model.OptionSpec unhidden = ((CommandLine.Model.OptionSpec.Builder)i.toBuilder().hidden(false)).build();
            cmdSpec.remove((CommandLine.Model.ArgSpec)i);
            cmdSpec.addOption(unhidden);
        }
    }

    private String[] getAppArgs(String[] appArgs) {
        if (appArgs == null) {
            return new String[0];
        }
        int i = 0;
        while (i < appArgs.length) {
            if (appArgs[i].startsWith("@")) {
                Path argPath = Path.of(appArgs[i].substring(1), new String[0]);
                UserProvidedPath configPath = new UserProvidedPath(argPath);
                appArgs[i] = String.format("@%s", configPath.getAdjustedPath());
                PathValidation.fatalErrorIfInvalidReadableFile(configPath);
            }
            ++i;
        }
        return appArgs;
    }

    private void handleException(Throwable e) {
        this.handleException(e, null, false, false);
    }

    private void handleException(Throwable e, CommandLine cmd) {
        this.handleException(e, cmd, true, false);
    }

    private void handleException(Throwable e, CommandLine cmd, boolean printUsage, boolean dumpStack) {
        System.err.println(e.getMessage());
        if (printUsage) {
            this.printShortHelp(cmd);
        }
        if (dumpStack) {
            System.err.println(e);
        }
    }

    private void handleUnmatchedArgumentException(CommandLine.UnmatchedArgumentException e) {
        ArrayList<String> cmdOpts = new ArrayList<String>();
        ArrayList<String> fileOpts = new ArrayList<String>();
        if (this.splitUnmatchedArguments(e.getCommandLine(), cmdOpts, fileOpts)) {
            String separator = System.lineSeparator() + " ";
            if (!cmdOpts.isEmpty()) {
                System.err.format("Unknown option%s:%n %s%n", cmdOpts.size() != 1 ? "s" : "", cmdOpts.stream().collect(Collectors.joining(separator)));
            }
            if (!fileOpts.isEmpty()) {
                int maxEntries = 4;
                String entries = " " + fileOpts.stream().limit(4L).collect(Collectors.joining(separator));
                if (fileOpts.size() > 4) {
                    entries = entries + separator + "...";
                }
                System.err.println("Syntax error in argument file:");
                System.err.println(entries);
                System.err.print("Ensure you specify one option per line");
                System.err.println(" and use '=' between the option name and the specified value.");
            }
        }
        this.printShortHelp(e.getCommandLine());
    }

    private boolean splitUnmatchedArguments(CommandLine cmd, List<String> cmdOpts, List<String> fileOpts) {
        CommandLine.ParseResult parseResult = cmd.getParseResult();
        ArrayList originalOpts = new ArrayList(parseResult.originalArgs());
        List unmatched = parseResult.unmatched();
        int i = 0;
        while (i < unmatched.size()) {
            String opt = (String)unmatched.get(i);
            if (originalOpts.contains(opt)) {
                cmdOpts.add(opt);
                originalOpts.remove(opt);
            } else {
                fileOpts.add(opt);
            }
            ++i;
        }
        return !unmatched.isEmpty();
    }

    private void printShortHelp(CommandLine cmd) {
        PrintWriter writer = cmd.getErr();
        writer.print(cmd.getHelp().fullSynopsis());
        CommandLine.Model.CommandSpec spec = cmd.getCommandSpec();
        writer.printf("Try '%s --help' for more information.%n", spec.qualifiedName());
    }

    private void configureLogger(LogLevel level, UserProvidedPath userProvidedLogOutput, boolean isRelease) throws IOException {
        if (level != null) {
            StreamHandler handler;
            if (userProvidedLogOutput != null) {
                Path logOutput = userProvidedLogOutput.getAdjustedPath();
                handler = new FileHandler(logOutput.toString());
                handler.setFormatter(new LogFormatter(false));
                System.out.println("Logging to: " + String.valueOf(logOutput));
            } else {
                handler = new ConsoleHandler();
                handler.setFormatter(new LogFormatter(true));
            }
            if (isRelease && (level.getLevel() == Level.FINEST || level.getLevel() == Level.ALL)) {
                handler.setLevel(Level.FINE);
                LOG.addHandler(handler);
                LOG.setLevel(Level.FINE);
            } else {
                handler.setLevel(level.getLevel());
                LOG.addHandler(handler);
                LOG.setLevel(level.getLevel());
            }
            LOG.setUseParentHandlers(false);
        } else {
            LOG.setLevel(Level.OFF);
        }
    }

    private void logConfigurationOptions(CommandLine.ParseResult parseResult) {
        LOG.config("Command-line arguments:");
        List originalArgs = parseResult.originalArgs();
        originalArgs.forEach(LOG::config);
        List expArgs = parseResult.expandedArgs();
        if (!originalArgs.equals(expArgs)) {
            LOG.config("All configuration options:");
            expArgs.forEach(LOG::config);
        }
    }
}

