/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.transform;

import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.xml.counters.Category;
import com.arm.streamline.common.xml.counters.CounterSet;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.perf.InvalidPerfDataException;
import com.arm.streamline.perf.apc.EventsXml;
import com.arm.streamline.perf.records.EventAttribute;
import com.arm.streamline.perf.transform.CapturedCounters;
import com.arm.streamline.perf.transform.ClusterCoreMapping;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class CapturedCounter {
    protected final @NonNull Category category;
    protected final @NonNull StockCounter counter;
    protected final @NonNull EventAttribute eventAttribute;
    protected final int key;
    private final @NonNull String counterHandle;

    public static @Nullable CapturedCounter create(@NonNull CapturedCounters parent, @NonNull EventAttribute eventAttribute, int key, @NonNull String eventName, @Nullable IntFunction<@NonNull String> pmuMappings, @NonNull EventsXml eventsXml, @NonNull ClusterCoreMapping clusterCoreMap) throws InvalidPerfDataException {
        switch (eventAttribute.getType()) {
            case 0: 
            case 1: {
                return BuiltinCapturedCounter.create(parent, eventAttribute, key, eventName, eventsXml);
            }
            case 2: {
                return TracepointCapturedCounter.create(parent, eventAttribute, key, eventName, eventsXml, clusterCoreMap);
            }
            case 3: 
            case 4: 
            case 5: {
                return null;
            }
        }
        if (pmuMappings != null) {
            return PMUCapturedCounter.create(parent, eventAttribute, key, eventName, pmuMappings, eventsXml);
        }
        return null;
    }

    public static @NonNull CustomCapturedCounter customCounter(@NonNull CapturedCounters parent, @NonNull EventAttribute eventAttribute, int key, @NonNull String eventName) throws InvalidPerfDataException {
        return CustomCapturedCounter.create(parent, eventAttribute, key, eventName);
    }

    protected static @NonNull String makeCounterHandle(@NonNull CapturedCounters parent, @NonNull Category category, @NonNull StockCounter counter) {
        CounterSet counterSet;
        String counterName = counter.getCounterName();
        if (counterName != null && !counterName.isEmpty()) {
            return counterName;
        }
        String counterSetName = category.getCounterSetAttribute();
        CounterSet counterSet2 = counterSet = counterSetName != null ? (CounterSet)category.getCounterSets().get(0) : null;
        if (counterSet == null) {
            throw new AssertionError((Object)("Cannot determine counter handle: " + String.valueOf(counter)));
        }
        assert (counterSet.getName().equals(counterSetName));
        return parent.allocateCounterHandle((String)NullChecking.neverNull((Object)counterSet.getName()), counter);
    }

    protected CapturedCounter(@NonNull Category category, @NonNull StockCounter counter, @NonNull EventAttribute eventAttribute, int key, @NonNull String counterHandle) {
        this.eventAttribute = eventAttribute;
        this.category = category;
        this.counter = counter;
        this.counterHandle = counterHandle;
        this.key = key;
    }

    public abstract boolean equals(Object var1);

    public @NonNull Category getCategory() {
        return this.category;
    }

    public @NonNull StockCounter getCounter() {
        return this.counter;
    }

    public String getDisplayTitle() {
        return this.counter.getDisplayTitle();
    }

    public @Nullable Long getEventBasedThreshold() {
        EventAttribute attr = this.eventAttribute;
        if (!attr.isFlagSet(EventAttribute.Flags.FREQ) && attr.getSampleFreqOrPeriod() != 0L) {
            return attr.getSampleFreqOrPeriod();
        }
        return null;
    }

    public @NonNull EventAttribute getEventAttribute() {
        return this.eventAttribute;
    }

    public int getKey() {
        return this.key;
    }

    public abstract int hashCode();

    public abstract String toString();

    public void writeCapturedXml(@NonNull XMLGenerator generator) throws IOException {
        CounterRecord record = new CounterRecord(this.counter, this.getCounterHandle(), this.counter.getName(), this.key);
        generator.startTag("counter");
        record.write(generator);
        this.addEbsAttribute(generator);
        generator.endTag();
    }

    public void writeCountersXml(XMLGenerator generator) throws IOException {
        if (!this.isCustom()) {
            generator.startEmptyTag("counter");
            generator.addAttribute("name", this.getCounterHandle());
        }
    }

    protected void addEbsAttribute(@NonNull XMLGenerator generator) throws IOException {
        Long eventBasedThreshold = this.getEventBasedThreshold();
        if (eventBasedThreshold != null && !this.isIgnoredEbsThreshold(eventBasedThreshold)) {
            generator.addAttribute("count", eventBasedThreshold.longValue());
        }
    }

    protected @NonNull String getCounterHandle() {
        return this.counterHandle;
    }

    protected abstract boolean isCustom();

    private boolean isIgnoredEbsThreshold(long period) {
        if (period == 1L && this.eventAttribute.getType() == 2) {
            return true;
        }
        if (period == 1L && this.eventAttribute.getType() == 1) {
            return true;
        }
        return this.eventAttribute.getType() == 1 && this.eventAttribute.getConfig() == 0L;
    }

    public static final class BuiltinCapturedCounter
    extends CapturedCounter {
        private static final @NonNull Map<Integer, String> PERF_CATEGORY_NAMES = new HashMap<Integer, String>(){
            {
                this.put(1, "perf_software");
                this.put(0, "perf_hardware");
            }
        };

        public static @Nullable CapturedCounter create(@NonNull CapturedCounters parent, @NonNull EventAttribute eventAttribute, int key, @NonNull String eventName, @NonNull EventsXml eventsXml) throws InvalidPerfDataException {
            String categoryName = PERF_CATEGORY_NAMES.get(eventAttribute.getType());
            if (categoryName == null) {
                return null;
            }
            Category category = eventsXml.findCategoryForPmu(categoryName);
            if (category == null) {
                return null;
            }
            StockCounter counter = category.findCounterByEvent(eventAttribute.getConfig());
            if (counter == null) {
                return CustomCapturedCounter.create(parent, category, eventAttribute, key, eventName);
            }
            return new BuiltinCapturedCounter(parent, eventAttribute, key, category, counter);
        }

        public BuiltinCapturedCounter(@NonNull CapturedCounters parent, @NonNull EventAttribute eventAttribute, int key, @NonNull Category category, @NonNull StockCounter counter) {
            super(category, counter, eventAttribute, key, BuiltinCapturedCounter.makeCounterHandle(parent, category, counter));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof BuiltinCapturedCounter) {
                BuiltinCapturedCounter that = (BuiltinCapturedCounter)obj;
                return this.category.equals((Object)that.category) && this.counter.equals(that.counter);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.category.hashCode();
            result = 31 * result + this.eventAttribute.hashCode();
            result = 31 * result + this.counter.hashCode();
            return result;
        }

        @Override
        public String toString() {
            return String.format("BuiltinCapturedCounter [category=%s, counter=%s]", this.category.getName(), this.counter);
        }

        @Override
        protected boolean isCustom() {
            return false;
        }
    }

    public static final class CustomCapturedCounter
    extends CapturedCounter {
        protected static @Nullable CustomCapturedCounter create(@NonNull CapturedCounters parent, @NonNull Category category, @NonNull EventAttribute eventAttribute, int key, @NonNull String eventName) {
            StockCounter counter = CustomCapturedCounter.makeCounter(category, eventAttribute, eventName);
            return new CustomCapturedCounter(category, counter, eventAttribute, key);
        }

        protected static @NonNull CustomCapturedCounter create(@NonNull CapturedCounters parent, @NonNull EventAttribute eventAttribute, int key, @NonNull String eventName) throws InvalidPerfDataException {
            Category category = parent.makeCategory(eventAttribute, eventName);
            StockCounter counter = CustomCapturedCounter.makeCounter(category, eventAttribute, eventName);
            return new CustomCapturedCounter(category, counter, eventAttribute, key);
        }

        private static @NonNull StockCounter makeCounter(@NonNull Category category, @NonNull EventAttribute eventAttribute, @NonNull String eventName) {
            String[] nameParts;
            @NonNull String name = eventAttribute.getType() == 2 ? ((nameParts = eventName.split(":", 2)).length == 2 ? nameParts[1] : eventName) : eventName;
            return new StockCounter(category, "perf_event_" + eventName.replaceAll("[^0-9A-Za-z_]", "_"), category.getName(), name, true, String.format("Unknown perf event: 0x%s/0x%s", Integer.toHexString(eventAttribute.getType()), Long.toHexString(eventAttribute.getConfig())), null, null, null, false);
        }

        private CustomCapturedCounter(@NonNull Category category, @NonNull StockCounter counter, @NonNull EventAttribute eventAttribute, int key) {
            super(category, counter, eventAttribute, key, (String)NullChecking.neverNull((Object)counter.getCounterName()));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof CustomCapturedCounter) {
                CustomCapturedCounter that = (CustomCapturedCounter)obj;
                return this.eventAttribute.equals((Object)that.eventAttribute);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.eventAttribute.hashCode();
        }

        @Override
        public String toString() {
            return this.eventAttribute.toString();
        }

        @Override
        protected boolean isCustom() {
            return true;
        }
    }

    public static final class PMUCapturedCounter
    extends CapturedCounter {
        private final @NonNull String pmuMapping;

        public static @Nullable CapturedCounter create(@NonNull CapturedCounters parent, @NonNull EventAttribute eventAttribute, int key, @NonNull String eventName, @NonNull IntFunction<@NonNull String> pmuMappings, @NonNull EventsXml eventsXml) throws InvalidPerfDataException {
            String pmu = pmuMappings.apply(eventAttribute.getType());
            Category category = eventsXml.findCategoryForPmu(pmu);
            if (category == null) {
                return null;
            }
            StockCounter counter = category.findCounterByEvent(eventAttribute.getConfig());
            if (counter == null) {
                return CustomCapturedCounter.create(parent, category, eventAttribute, key, eventName);
            }
            return new PMUCapturedCounter(parent, eventAttribute, key, pmu, category, counter);
        }

        public PMUCapturedCounter(@NonNull CapturedCounters parent, @NonNull EventAttribute eventAttribute, int key, @NonNull String pmuMapping, @NonNull Category category, @NonNull StockCounter counter) {
            super(category, counter, eventAttribute, key, PMUCapturedCounter.makeCounterHandle(parent, category, counter));
            this.pmuMapping = pmuMapping;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof PMUCapturedCounter) {
                PMUCapturedCounter that = (PMUCapturedCounter)obj;
                return this.pmuMapping.equals(that.pmuMapping) && this.category.equals((Object)that.category) && this.counter.equals(that.counter);
            }
            return false;
        }

        public @NonNull String getPmuMapping() {
            return this.pmuMapping;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.category.hashCode();
            result = 31 * result + this.pmuMapping.hashCode();
            result = 31 * result + this.eventAttribute.hashCode();
            result = 31 * result + this.counter.hashCode();
            return result;
        }

        @Override
        public String toString() {
            return String.format("PMUCapturedCounter [pmuMapping=%s, category=%s, counter=%s]", this.pmuMapping, this.category.getName(), this.counter);
        }

        @Override
        protected boolean isCustom() {
            return false;
        }
    }

    public static final class TracepointCapturedCounter
    extends CapturedCounter {
        private static final @NonNull Map<String, PerPmuRecord> PER_PMU_COUNTERS = new HashMap<String, PerPmuRecord>(){
            {
                this.put("sched:sched_switch", new PerPmuRecord("Switch", "Scheduler", "Context switch events", "switch", "Linux_sched_sched_switch", null, null, null, false));
                this.put("power:cpu_frequency", new PerPmuRecord("Frequency", "Clock", "Frequency setting of the CPU", "freq", "Linux_power_cpu_freq", "absolute", "Hz", "overlay", true));
                this.put("irq:irq_handler_exit", new PerPmuRecord("IRQ", "Interrupts", "Linux IRQ taken", "irq", "Linux_irq", null, null, null, false));
                this.put("irq:softirq_exit", new PerPmuRecord("SoftIRQ", "Interrupts", "Linux SoftIRQ taken", "softirq", "Linux_softirq", null, null, null, false));
            }
        };

        public static @Nullable CapturedCounter create(@NonNull CapturedCounters parent, @NonNull EventAttribute eventAttribute, int key, @NonNull String eventName, @NonNull EventsXml eventsXml, @NonNull ClusterCoreMapping clusterCoreMap) throws InvalidPerfDataException {
            PerPmuRecord perPmuRecord = PER_PMU_COUNTERS.get(eventName);
            if (perPmuRecord != null) {
                Category category = eventsXml.findCategoryByName("linux");
                if (category == null) {
                    throw new AssertionError((Object)"Missing linux category");
                }
                StockCounter counter = perPmuRecord.counter;
                if (counter == null) {
                    String name = TracepointCapturedCounter.makePerPmuCounterName(eventsXml, clusterCoreMap, eventAttribute, perPmuRecord);
                    perPmuRecord.counter = counter = new StockCounter(category, name != null ? name : perPmuRecord.nameNoCluster, perPmuRecord.title, perPmuRecord.name, true, perPmuRecord.description, perPmuRecord.clazz, perPmuRecord.units, perPmuRecord.composition, perPmuRecord.averageCores);
                }
                return new TracepointCapturedCounter(parent, eventAttribute, key, category, counter);
            }
            Category category = eventsXml.findCategoryByName("ftrace");
            if (category == null) {
                return null;
            }
            StockCounter counter = category.findCounterByTracepoint((String)NullChecking.neverNull((Object)eventName.replace(':', '/')));
            if (counter == null) {
                return CustomCapturedCounter.create(parent, eventAttribute, key, eventName);
            }
            return new TracepointCapturedCounter(parent, eventAttribute, key, category, counter);
        }

        private static @Nullable String makePerPmuCounterName(@NonNull EventsXml eventsXml, @NonNull ClusterCoreMapping clusterCoreMap, @NonNull EventAttribute eventAttribute, @NonNull PerPmuRecord perPmuRecord) {
            String clusterName = clusterCoreMap.getClusterName(eventsXml, eventAttribute);
            if (clusterName != null) {
                return (String)NullChecking.neverNull((Object)String.format("%s_%s", clusterName, perPmuRecord.suffix));
            }
            return null;
        }

        public TracepointCapturedCounter(@NonNull CapturedCounters parent, @NonNull EventAttribute eventAttribute, int key, @NonNull Category category, @NonNull StockCounter counter) {
            super(category, counter, eventAttribute, key, TracepointCapturedCounter.makeCounterHandle(parent, category, counter));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof TracepointCapturedCounter) {
                TracepointCapturedCounter that = (TracepointCapturedCounter)obj;
                return this.category.equals((Object)that.category) && this.counter.equals(that.counter);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.category.hashCode();
            result = 31 * result + this.eventAttribute.hashCode();
            result = 31 * result + this.counter.hashCode();
            return result;
        }

        @Override
        public String toString() {
            return String.format("TracepointCapturedCounter [category=%s, counter=%s]", this.category.getName(), this.counter);
        }

        @Override
        protected boolean isCustom() {
            return false;
        }

        private static final class PerPmuRecord {
            public final boolean averageCores;
            public final @Nullable String clazz;
            public final @Nullable String composition;
            public @Nullable StockCounter counter;
            public final @NonNull String description;
            public final @NonNull String name;
            public final @NonNull String nameNoCluster;
            public final @NonNull String suffix;
            public final @NonNull String title;
            public final @Nullable String units;

            public PerPmuRecord(@NonNull String name, @NonNull String title, @NonNull String description, @NonNull String suffix, @NonNull String nameNoCluster, @Nullable String clazz, @Nullable String units, @Nullable String composition, boolean averageCores) {
                this.name = name;
                this.title = title;
                this.description = description;
                this.suffix = suffix;
                this.nameNoCluster = nameNoCluster;
                this.clazz = clazz;
                this.units = units;
                this.composition = composition;
                this.averageCores = averageCores;
            }
        }
    }
}

