/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.data_file.header_flag_values;

import com.arm.streamline.perf.io.StringIO;
import com.arm.streamline.perf.records.EventHeader;
import com.arm.utils.datainput.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class BuildIdRecord {
    private static final int BUILD_ID_LENGTH = 24;
    private final @NonNull EventHeader header;
    private final int pid;
    private final byte @NonNull [] buildId;
    private final @NonNull String filename;

    public static @NonNull List<@NonNull BuildIdRecord> create(@NonNull SeekableDataInput input, long sectionSize) throws IOException {
        ArrayList<@NonNull BuildIdRecord> result = new ArrayList<BuildIdRecord>();
        long baseOffset = input.offset();
        long size = 0L;
        while (size < sectionSize) {
            input.seek(baseOffset + size);
            BuildIdRecord buildIdRecord = new BuildIdRecord((DataInput)input);
            result.add(buildIdRecord);
            assert (baseOffset + (size += buildIdRecord.getHeader().getTotalSize()) == input.offset());
        }
        return result;
    }

    public BuildIdRecord(@NonNull DataInput input) throws IOException {
        this.header = EventHeader.fromDataInput((DataInput)input);
        int payloadLength = this.header.getPayloadSizeAsInt();
        int stringLength = payloadLength - 28;
        assert (payloadLength >= 0) : "Invalid header.size";
        this.pid = input.readInt();
        this.buildId = new byte[24];
        input.readFully(this.buildId);
        this.filename = StringIO.readFixedStringNullTerminated((DataInput)input, (int)stringLength);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BuildIdRecord) {
            BuildIdRecord that = (BuildIdRecord)obj;
            return this.header.equals((Object)that.header) && this.pid == that.pid && Arrays.equals(this.buildId, that.buildId) && this.filename.equals(that.filename);
        }
        return false;
    }

    public byte @NonNull [] getBuildId() {
        return this.buildId;
    }

    public @NonNull String getFilename() {
        return this.filename;
    }

    public @NonNull EventHeader getHeader() {
        return this.header;
    }

    public int getPid() {
        return this.pid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.buildId);
        result = 31 * result + this.filename.hashCode();
        result = 31 * result + this.header.hashCode();
        result = 31 * result + this.pid;
        return result;
    }

    public String toString() {
        StringBuilder buildIdString = new StringBuilder();
        byte[] byArray = this.buildId;
        int n = this.buildId.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            int bval = element & 0xFF;
            if (bval < 16) {
                buildIdString.append('0');
            }
            buildIdString.append(Integer.toHexString(bval));
            ++n2;
        }
        return String.format("BuildIdRecord [header=%s, pid=%s, buildId=0x%s, filename=%s]", this.header, this.pid, buildIdString, this.filename);
    }
}

