/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.data_file;

import com.arm.streamline.perf.data_file.FileSection;
import com.arm.streamline.perf.data_file.header_flag_values.BuildIdRecord;
import com.arm.streamline.perf.data_file.header_flag_values.CacheDescription;
import com.arm.streamline.perf.data_file.header_flag_values.CpuTopology;
import com.arm.streamline.perf.data_file.header_flag_values.EventDescription;
import com.arm.streamline.perf.data_file.header_flag_values.GroupDescription;
import com.arm.streamline.perf.data_file.header_flag_values.NumaNode;
import com.arm.streamline.perf.data_file.header_flag_values.NumberOfCpus;
import com.arm.streamline.perf.data_file.header_flag_values.PmuMapping;
import com.arm.streamline.perf.data_file.header_flag_values.TracingData;
import com.arm.streamline.perf.io.StringIO;
import com.arm.utils.NullChecking;
import com.arm.utils.datainput.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class HeaderFlags<T> {
    public static final @NonNull HeaderFlags<String> HEADER_ARCH = new HeaderFlags<String>(6){

        @Override
        public @NonNull String readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            return StringIO.stripNullTerminator((String)1.readHeaderString(input, section));
        }

        @Override
        public String toString() {
            return "HEADER_ARCH";
        }
    };
    public static final @NonNull HeaderFlags<Object> HEADER_AUXTRACE = new HeaderFlags<Object>(18){

        @Override
        public Object readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) {
            return null;
        }

        @Override
        public String toString() {
            return "HEADER_AUXTRACE";
        }
    };
    public static final @NonNull HeaderFlags<Object> HEADER_BRANCH_STACK = new HeaderFlags<Object>(15){

        @Override
        public Object readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) {
            return null;
        }

        @Override
        public String toString() {
            return "HEADER_BRANCH_STACK";
        }
    };
    public static final @NonNull HeaderFlags<List<@NonNull BuildIdRecord>> HEADER_BUILD_ID = new HeaderFlags<List<BuildIdRecord>>(2){

        @Override
        public @NonNull List<@NonNull BuildIdRecord> readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            input.seek(section.getOffset());
            return BuildIdRecord.create(input, section.getSize());
        }

        @Override
        public String toString() {
            return "HEADER_BUILD_ID";
        }
    };
    public static final @NonNull HeaderFlags<List<@NonNull CacheDescription>> HEADER_CACHE = new HeaderFlags<List<CacheDescription>>(20){

        @Override
        public @NonNull List<@NonNull CacheDescription> readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            input.seek(section.getOffset());
            return CacheDescription.create((DataInput)input);
        }

        @Override
        public String toString() {
            return "HEADER_CACHE";
        }
    };
    public static final @NonNull HeaderFlags<List<@NonNull String>> HEADER_CMDLINE = new HeaderFlags<List<String>>(11){

        @Override
        public @NonNull List<@NonNull String> readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            return 6.readHeaderStringList(input, section).stream().map(s -> StringIO.stripNullTerminator((String)s)).collect(Collectors.toList());
        }

        @Override
        public String toString() {
            return "HEADER_CMDLINE";
        }
    };
    public static final @NonNull HeaderFlags<CpuTopology> HEADER_CPU_TOPOLOGY = new HeaderFlags<CpuTopology>(13){

        @Override
        public @NonNull CpuTopology readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            input.seek(section.getOffset());
            return new CpuTopology((DataInput)input);
        }

        @Override
        public String toString() {
            return "HEADER_CPU_TOPOLOGY";
        }
    };
    public static final @NonNull HeaderFlags<String> HEADER_CPUDESC = new HeaderFlags<String>(8){

        @Override
        public @NonNull String readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            return StringIO.stripNullTerminator((String)8.readHeaderString(input, section));
        }

        @Override
        public String toString() {
            return "HEADER_CPUDESC";
        }
    };
    public static final @NonNull HeaderFlags<String> HEADER_CPUID = new HeaderFlags<String>(9){

        @Override
        public @NonNull String readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            return StringIO.stripNullTerminator((String)9.readHeaderString(input, section));
        }

        @Override
        public String toString() {
            return "HEADER_CPUID";
        }
    };
    public static final @NonNull HeaderFlags<List<@NonNull EventDescription>> HEADER_EVENT_DESC = new HeaderFlags<List<EventDescription>>(12){

        @Override
        public @NonNull List<@NonNull EventDescription> readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            input.seek(section.getOffset());
            return EventDescription.create((DataInput)input);
        }

        @Override
        public String toString() {
            return "HEADER_EVENT_DESC";
        }
    };
    public static final @NonNull HeaderFlags<List<@NonNull GroupDescription>> HEADER_GROUP_DESC = new HeaderFlags<List<GroupDescription>>(17){

        @Override
        public @NonNull List<@NonNull GroupDescription> readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            input.seek(section.getOffset());
            return GroupDescription.create((DataInput)input);
        }

        @Override
        public String toString() {
            return "HEADER_GROUP_DESC";
        }
    };
    public static final @NonNull HeaderFlags<String> HEADER_HOSTNAME = new HeaderFlags<String>(3){

        @Override
        public @NonNull String readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            return StringIO.stripNullTerminator((String)12.readHeaderString(input, section));
        }

        @Override
        public String toString() {
            return "HEADER_HOSTNAME";
        }
    };
    public static final @NonNull HeaderFlags<NumberOfCpus> HEADER_NRCPUS = new HeaderFlags<NumberOfCpus>(7){

        @Override
        public @NonNull NumberOfCpus readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            input.seek(section.getOffset());
            return new NumberOfCpus((DataInput)input);
        }

        @Override
        public String toString() {
            return "HEADER_NRCPUS";
        }
    };
    public static final @NonNull HeaderFlags<List<@NonNull NumaNode>> HEADER_NUMA_TOPOLOGY = new HeaderFlags<List<NumaNode>>(14){

        @Override
        public @NonNull List<@NonNull NumaNode> readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            input.seek(section.getOffset());
            return NumaNode.create((DataInput)input);
        }

        @Override
        public String toString() {
            return "HEADER_NUMA_TOPOLOGY";
        }
    };
    public static final @NonNull HeaderFlags<String> HEADER_OSRELEASE = new HeaderFlags<String>(4){

        @Override
        public @NonNull String readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            return StringIO.stripNullTerminator((String)15.readHeaderString(input, section));
        }

        @Override
        public String toString() {
            return "HEADER_OSRELEASE";
        }
    };
    public static final @NonNull HeaderFlags<List<@NonNull PmuMapping>> HEADER_PMU_MAPPINGS = new HeaderFlags<List<PmuMapping>>(16){

        @Override
        public @NonNull List<@NonNull PmuMapping> readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            input.seek(section.getOffset());
            return PmuMapping.create((DataInput)input);
        }

        @Override
        public String toString() {
            return "HEADER_PMU_MAPPINGS";
        }
    };
    public static final @NonNull HeaderFlags<Object> HEADER_STAT = new HeaderFlags<Object>(19){

        @Override
        public Object readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) {
            return null;
        }

        @Override
        public String toString() {
            return "HEADER_STAT";
        }
    };
    public static final @NonNull HeaderFlags<Long> HEADER_TOTAL_MEM = new HeaderFlags<Long>(10){

        @Override
        public @NonNull Long readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            input.seek(section.getOffset());
            return (Long)NullChecking.neverNull((Object)input.readLong());
        }

        @Override
        public String toString() {
            return "HEADER_TOTAL_MEM";
        }
    };
    public static final @NonNull HeaderFlags<Map<@NonNull String, @NonNull String>> HEADER_SIMPLEPERF_META_INFO = new HeaderFlags<Map<String, String>>(129){

        @Override
        public @NonNull Map<@NonNull String, @NonNull String> readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            input.seek(section.getOffset());
            HashMap<@NonNull String, @NonNull String> result = new HashMap<String, String>();
            while (input.offset() < section.getEnd()) {
                String key = StringIO.readCString((DataInput)input);
                String value = StringIO.readCString((DataInput)input);
                result.put(key, value);
            }
            return result;
        }

        @Override
        public String toString() {
            return "HEADER_SIMPLEPERF_META_INFO";
        }
    };
    public static final @NonNull HeaderFlags<TracingData> HEADER_TRACING_DATA = new HeaderFlags<TracingData>(1){

        @Override
        public @NonNull TracingData readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            input.seek(section.getOffset());
            return new TracingData((DataInput)input);
        }

        @Override
        public String toString() {
            return "HEADER_TRACING_DATA";
        }
    };
    public static final @NonNull HeaderFlags<String> HEADER_VERSION = new HeaderFlags<String>(5){

        @Override
        public @NonNull String readHeaderValue(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
            return StringIO.stripNullTerminator((String)21.readHeaderString(input, section));
        }

        @Override
        public String toString() {
            return "HEADER_VERSION";
        }
    };
    public final int bit;

    public static @Nullable HeaderFlags<?> getByBit(int bit) {
        HeaderFlags<?> @NonNull [] values = ValuesByBitOrder.getValueByBitOrder();
        if (bit < values.length) {
            return values[bit];
        }
        return null;
    }

    public static @NonNull String readHeaderString(@NonNull DataInput input) throws IOException {
        int length = input.readInt();
        return (String)NullChecking.neverNull((Object)String.valueOf(StringIO.readFixedString((DataInput)input, (int)length)));
    }

    public static @NonNull String readHeaderString(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
        input.seek(section.getOffset());
        return HeaderFlags.readHeaderString((DataInput)input);
    }

    public static @NonNull List<@NonNull String> readHeaderStringList(@NonNull DataInput input) throws IOException {
        ArrayList<@NonNull String> result = new ArrayList<String>();
        int length = input.readInt();
        int i = 0;
        while (i < length) {
            result.add(HeaderFlags.readHeaderString(input));
            ++i;
        }
        return result;
    }

    public static @NonNull List<@NonNull String> readHeaderStringList(@NonNull SeekableDataInput input, @NonNull FileSection section) throws IOException {
        input.seek(section.getOffset());
        return HeaderFlags.readHeaderStringList((DataInput)input);
    }

    public static @Nullable HeaderFlags<?> @NonNull [] valuesByBitOrder() {
        return ValuesByBitOrder.getValueByBitOrder();
    }

    protected HeaderFlags(int bit) {
        this.bit = bit;
        HeaderFlags<?> @NonNull [] values = ValuesByBitOrder.getValueByBitOrder();
        if (values[bit] != null) {
            throw new AssertionError(this);
        }
        values[bit] = this;
    }

    public abstract @Nullable T readHeaderValue(@NonNull SeekableDataInput var1, @NonNull FileSection var2) throws IOException;

    public abstract @NonNull String toString();

    private static final class ValuesByBitOrder {
        private static final @Nullable HeaderFlags<?> @NonNull [] _valueByBitOrder = new HeaderFlags[256];

        private ValuesByBitOrder() {
        }

        protected static @Nullable HeaderFlags<?> @NonNull [] getValueByBitOrder() {
            return _valueByBitOrder;
        }
    }
}

