/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.apc;

import com.arm.streamline.common.xml.counters.Category;
import com.arm.streamline.common.xml.counters.CounterSet;
import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.common.xml.counters.StockCounter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EventsXml {
    private final @NonNull List<@NonNull Category> categories;
    private final @NonNull Map<String, StockCounter> stockCounterMap;
    private final @NonNull Map<String, CounterSet> counterSets;
    private final @NonNull Map<String, Category> categoriesByCounterSet;
    private final @NonNull Map<String, Category> categoriesByName;

    public EventsXml(@NonNull InputStream input) throws IOException {
        Events events = Events.createWithAllEventsWithoutClusterInfo((InputStream)input);
        this.categoriesByName = new HashMap<String, Category>();
        this.categories = events.getCategories();
        this.stockCounterMap = events.getStockCounterMap();
        this.counterSets = new HashMap<String, CounterSet>();
        this.categoriesByCounterSet = new HashMap<String, Category>();
        for (Category category : this.categories) {
            this.categoriesByName.put(category.getName().toLowerCase(), category);
            for (CounterSet counterSet : category.getCounterSets()) {
                if (this.counterSets.put(counterSet.getName().toLowerCase(), counterSet) != null) {
                    throw new AssertionError((Object)("Duplicate named counter set: " + counterSet.getName()));
                }
                this.categoriesByCounterSet.put(counterSet.getName().toLowerCase(), category);
            }
        }
    }

    public @Nullable Category findCategoryByName(@NonNull String name) {
        return this.categoriesByName.get(name);
    }

    public @Nullable Category findCategoryForPmu(@NonNull String name) {
        String categoryName = name.toLowerCase().concat("_cnt");
        return this.categoriesByCounterSet.get(categoryName);
    }

    public @NonNull Map<String, StockCounter> getStockCounterMap() {
        return Collections.unmodifiableMap(this.stockCounterMap);
    }
}

