/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.timeline;

import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.bindata.TimelineAllBinData;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.model.capture.SeriesCoreInformationProvider;
import com.arm.streamline.model.chart.ChartModelMessages;
import com.arm.streamline.model.chart.ChartUtility;
import com.arm.streamline.model.chart.SeriesRangeCalculator;
import com.arm.streamline.model.chart.SeriesRangeInfo;
import com.arm.streamline.model.timeline.TimelineChartDataProvider;
import com.arm.streamline.utility.expression2.ExpressionData;
import com.arm.streamline.utility.expression2.ExpressionException;
import com.arm.utils.NullChecking;
import gnu.trove.map.hash.TIntDoubleHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TimelineSeriesDataProvider
implements ISeriesDataProvider,
SeriesConfig.IListener {
    private final @NonNull SeriesCoreInformationProvider coreInformationProvider;
    private Analysis mAnalysis;
    private TimelineChartDataProvider mChart;
    private final @NonNull SeriesConfig mConfig;
    private boolean mIsAverageSelectionPossible;
    private TIntDoubleHashMap mScaleToAggregateLimitMap = new TIntDoubleHashMap();
    private TIntDoubleHashMap mScaleToCoreLimitMap = new TIntDoubleHashMap();
    private @NonNull Set<@NonNull String> mSources = Collections.emptySet();
    private String mWarning;
    private ISeriesDataProvider.WarningSource mWarningSource;

    public TimelineSeriesDataProvider(Analysis analysis, TimelineChartDataProvider chart, @NonNull SeriesConfig config) {
        this.mAnalysis = analysis;
        this.mChart = chart;
        this.mConfig = config;
        this.mConfig.addListener(this);
        this.coreInformationProvider = new SeriesCoreInformationProvider(() -> this.mSources, s -> (IBinDataProvider)NullChecking.neverNull((Object)this.getAllBinData().getBinData((String)s)), c -> Arrays.asList(this.mAnalysis.getCores(c)));
        this.initializeDataDependentOnExpression();
    }

    @Override
    public void expressionOrDisplayModified() {
        this.initializeDataDependentOnExpression();
    }

    @Override
    public double getAggregateLimit() {
        return this.mScaleToAggregateLimitMap.get(this.mAnalysis.getScales().getZoomLevel().getBps());
    }

    @Override
    public final double getAggregateValueOfRangeFromDensestLevel(int start, int end, TIntSet filteredUids) {
        return this.getValueOfRangeFromDensestLevel(null, start, end, this.mAnalysis.getScales().getZoomLevel(), this.getSeriesRangeInfo(filteredUids), false);
    }

    public TimelineAllBinData getAllBinData() {
        return this.mAnalysis.getAllBinData();
    }

    public SeriesRangeCalculator getCalculator() {
        return this.getChart().getCaptureDataProvider().getSeriesRangeCalculator();
    }

    public ICaptureDataProvider getCaptureDataProvider() {
        return this.mAnalysis;
    }

    @Override
    public TimelineChartDataProvider getChart() {
        return this.mChart;
    }

    @Override
    public final @NonNull SeriesConfig getConfig() {
        return this.mConfig;
    }

    @Override
    public @NonNull ISeriesDataProvider.ISeriesCoreInformationProvider getCoreInformationProvider() {
        return this.coreInformationProvider;
    }

    @Override
    public double getCoreLimit() {
        return this.mScaleToCoreLimitMap.get(this.mAnalysis.getScales().getZoomLevel().getBps());
    }

    @Override
    public final double getCoreValueOfRangeFromDensestLevel(@NonNull ProcessingElementReference channelDescriptor, int start, int end, TIntSet filteredUids) {
        return this.getValueOfRangeFromDensestLevel(channelDescriptor, start, end, this.mAnalysis.getScales().getZoomLevel(), this.getSeriesRangeInfo(filteredUids), false);
    }

    @Override
    public final double[] getData(int start, int end, @Nullable TIntSet filteredUids) {
        return this.getData(null, start, end, filteredUids);
    }

    public final double getDataPointAtScale(@NonNull ZoomLevel zoomLevel, @Nullable ProcessingElementReference channel, int offset, SeriesRangeInfo info) {
        @NonNull ZoomLevel densestZoomLevel = this.mAnalysis.getScales().getDensestZoomLevel();
        int start = offset * (densestZoomLevel.getBps() / zoomLevel.getBps());
        int end = start + densestZoomLevel.getBps() / zoomLevel.getBps() - 1;
        double value = this.getValueOfRangeFromDensestLevel(channel, start, end, zoomLevel, info, true);
        return value;
    }

    @Override
    public String getDescription() {
        return this.mAnalysis.getVariableReplacer().replace(this.getConfig().getDescriptionFormat());
    }

    @Override
    public String getName() {
        return this.mAnalysis.getVariableReplacer().replace(this.getConfig().getName());
    }

    @Override
    public @NonNull Set<@NonNull String> getSources() {
        return this.mSources;
    }

    @Override
    public String getWarning() {
        return this.mWarning;
    }

    @Override
    public ISeriesDataProvider.WarningSource getWarningSource() {
        return this.mWarningSource;
    }

    @Override
    public void initializeLimits() {
        TLongHashSet limits = new TLongHashSet();
        Set<@NonNull String> sources = this.getSources();
        for (String source : sources) {
            @NonNull IBinDataProvider provider = (IBinDataProvider)NullChecking.neverNull((Object)this.getAllBinData().getBinData(source));
            limits.addAll(provider.getLimits());
        }
        if (limits.size() == 0) {
            limits.add(0L);
        }
        this.mScaleToAggregateLimitMap.clear();
        this.mScaleToCoreLimitMap.clear();
        SeriesRangeInfo info = this.getSeriesRangeInfo(null);
        ZoomLevel[] zoomLevelArray = this.mChart.getCaptureDataProvider().getScales().getAvailableZoomLevels();
        int n = zoomLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ZoomLevel zoomLevel = zoomLevelArray[n2];
            long[] lArray = limits.toArray();
            int n3 = lArray.length;
            int n4 = 0;
            while (n4 < n3) {
                long limitIndex = lArray[n4];
                info.setUIZoomLevelOverride(zoomLevel);
                this.getDataPointAtScale(zoomLevel, null, (int)limitIndex, info);
                @NonNull Set<@NonNull ProcessingElementReference> channels = this.coreInformationProvider.getChannelDescriptors();
                if (channels.size() > 1) {
                    for (ProcessingElementReference channel : channels) {
                        this.getDataPointAtScale(zoomLevel, channel, (int)limitIndex, info);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public boolean isAverageSelectionPossible() {
        return this.mIsAverageSelectionPossible;
    }

    @Override
    public boolean isDataHiddenDueToEfficientFtrace() {
        return false;
    }

    @Override
    public boolean isFilterable() {
        if (this.getWarning() == null) {
            for (String source : this.getSources()) {
                @NonNull IBinDataProvider provider = (IBinDataProvider)NullChecking.neverNull((Object)this.getAllBinData().getBinData(source));
                if (!provider.isFilterable()) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Counter Chart Series: " + this.getName();
    }

    private void adjustAggregateLimit(@NonNull ZoomLevel zoomLevel, double value) {
        if (value > this.mScaleToAggregateLimitMap.get(zoomLevel.getBps())) {
            this.mScaleToAggregateLimitMap.put(zoomLevel.getBps(), value);
        }
    }

    private void adjustCoreLimit(@NonNull ZoomLevel zoomLevel, double value) {
        if (value > this.mScaleToCoreLimitMap.get(zoomLevel.getBps())) {
            this.mScaleToCoreLimitMap.put(zoomLevel.getBps(), value);
        }
    }

    private void calculateWarnings() {
        @NonNull HashSet<@NonNull String> vars = new HashSet<String>();
        try {
            ChartUtility.getVariableSetFromExpression(this.mConfig.getExpression(), vars);
        }
        catch (ExpressionException e) {
            this.mWarningSource = ISeriesDataProvider.WarningSource.EXPRESSION;
            this.mWarning = ChartModelMessages.INVALID_EXPRESSION;
            return;
        }
        int indexForMissingSources = 0;
        int indexForIncompatibleDisplay = 0;
        TimelineAllBinData binData = this.mAnalysis.getAllBinData();
        String missingSources = null;
        String incompatibleDisplay = null;
        for (String v : vars) {
            if (SeriesRangeCalculator.isPredefinedVariable(v)) continue;
            if (!binData.isValidSource(v)) {
                if (indexForMissingSources++ == 0) {
                    missingSources = ChartModelMessages.MISSING_SOURCES + "$" + v;
                    continue;
                }
                missingSources = missingSources + ", $" + v;
                continue;
            }
            if (ChartUtility.isCompatible(this.mConfig.getDisplay(), ((IBinDataProvider)NullChecking.neverNull((Object)binData.getBinData(v))).getCounterRecord().getCounterClass())) continue;
            incompatibleDisplay = indexForIncompatibleDisplay++ == 0 ? "'" + this.mConfig.getDisplay().toString() + "' " + ChartModelMessages.INCOMPATIBLE_DISPLAY + " $" + v : incompatibleDisplay + ", $" + v;
        }
        if (missingSources != null) {
            this.mWarningSource = ISeriesDataProvider.WarningSource.EXPRESSION;
            this.mWarning = missingSources;
        } else if (incompatibleDisplay != null) {
            this.mWarningSource = ISeriesDataProvider.WarningSource.COUNTER_DISPLAY;
            this.mWarning = incompatibleDisplay;
        } else {
            this.mWarningSource = ISeriesDataProvider.WarningSource.NONE;
            this.mWarning = null;
        }
    }

    @Override
    public final @NonNull IBinDataProvider getBinData(String source) {
        return (IBinDataProvider)NullChecking.neverNull((Object)this.getAllBinData().getBinData(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final double[] getData(@Nullable ProcessingElementReference channel, int start, int end, @Nullable TIntSet filteredUids) {
        Analysis analysis = this.mAnalysis;
        synchronized (analysis) {
            @NonNull ZoomLevel zoomLevel = this.mAnalysis.getScales().getZoomLevel();
            if (this.mAnalysis.isReportGenerationActive()) {
                this.getAllBinData().prepareRange(zoomLevel, start, end, this.getSources());
            } else {
                this.getAllBinData().prepareRange(zoomLevel, start, end);
            }
            double[] data = new double[1 + end - start];
            this.getAllBinData().withBulkTransaction(() -> {
                SeriesRangeInfo info = this.getSeriesRangeInfo(filteredUids);
                int i = start;
                while (i <= end) {
                    dArray[i - n] = this.getDataPointAtScale(zoomLevel, channel, i, info);
                    ++i;
                }
            });
            return data;
        }
    }

    private SeriesRangeInfo getSeriesRangeInfo(@Nullable TIntSet filteredUids) {
        TIntHashSet filteredThreadUids = this.getChart().getCaptureDataProvider().convertToThreadUIDs(filteredUids);
        ExpressionData expression = this.mConfig.getExpression();
        return new SeriesRangeInfo(this, filteredThreadUids, ChartUtility.getVariableSetFromExpression(expression), ChartUtility.isExpressionComplex(expression));
    }

    private double getValueOfRangeFromDensestLevel(@Nullable ProcessingElementReference channelDescriptor, int start, int end, @NonNull ZoomLevel zoomLevel, SeriesRangeInfo info, boolean adjustLimit) {
        double value;
        boolean perCore = channelDescriptor != null;
        double d = value = channelDescriptor != null ? this.getCalculator().getCoreRange(info, start, end, channelDescriptor) : this.getCalculator().getAggregateRange(info, start, end);
        if (adjustLimit && perCore) {
            this.adjustCoreLimit(zoomLevel, value);
        } else if (adjustLimit) {
            this.adjustAggregateLimit(zoomLevel, value);
        }
        double limit = this.mChart.getNonPercentageLimit(perCore);
        return this.handlePercentageAndRound(limit, value);
    }

    private double handlePercentageAndRound(double limit, double value) {
        if (this.mChart.isPercentage()) {
            if (limit == 0.0) {
                value = 0.0;
            } else {
                if (limit < 1.0) {
                    limit = 1.0;
                }
                value /= limit;
                value = (double)Math.round(value * 10000.0) / 10000.0;
            }
        }
        return value;
    }

    private void initializeDataDependentOnExpression() {
        ExpressionData expression = this.mConfig.getExpression();
        this.mIsAverageSelectionPossible = ChartUtility.isAverageSelectionPossible(this.mConfig.getDisplay(), ChartUtility.isExpressionComplex(expression));
        @NonNull Set<@NonNull String> set = ChartUtility.getVariableSetFromExpression(expression);
        this.getAllBinData().retainAndReplaceSourcesFromSelected(set);
        this.mSources = set;
        this.calculateWarnings();
        this.initializeLimits();
    }

    @Override
    public void refreshWarnings() {
        this.calculateWarnings();
    }
}

