/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.templates;

import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.model.bindata.IAllBinDataProvider;
import com.arm.streamline.model.capture.AbstractSeriesConfig;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.model.chart.ChartUtility;
import com.arm.streamline.model.chart.SeriesRangeCalculator;
import com.arm.streamline.model.templates.ITemplatePath;
import com.arm.streamline.model.templates.TemplateFile;
import com.arm.streamline.model.templates.TemplatePath;
import com.arm.streamline.model.templates.TemplatesMessages;
import com.arm.streamline.utility.expression2.ExpressionData;
import com.arm.streamline.widget.Error;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.ObjBoolPair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.FileDialog;

public class TemplateUtils {
    private static final @NonNull String TEMPLATE_WILDCARD_INDICATOR = "+";
    public static final Pattern TEMPLATE_GPU_NAME_PATTERN = Pattern.compile("((?:Mali-[A-Za-z0-9]+)|(?:Mali [A-Z0-9]+-[A-Za-z]+)|(?:Immortalis-[A-Za-z0-9]+))");

    public static @NonNull Set<@NonNull String> addTemplate(@NonNull Function<@NonNull Stream<@NonNull String>, Collection<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull StockCounter.Combination>> addToConfig, @NonNull Collection<@NonNull ChartAndSeriesConfig> templateChartsConfig, @NonNull List<@NonNull String> sources) {
        Map<Boolean, List<ObjBoolPair>> aliasesAndOptionalFlags = templateChartsConfig.stream().flatMap(c -> c.getAllExpandedSeries(sources).stream()).map(TemplateUtils::getNotPredefinedVariables).collect(Collectors.groupingBy(p -> p.second));
        Stream requiredAliases = ((List)NullChecking.neverNullOrCreate(aliasesAndOptionalFlags.get(Boolean.FALSE), Collections::emptyList)).stream().flatMap(p -> (Stream)p.first);
        Stream optionalAliases = ((List)NullChecking.neverNullOrCreate(aliasesAndOptionalFlags.get(Boolean.TRUE), Collections::emptyList)).stream().flatMap(p -> (Stream)p.first);
        Set<String> result = addToConfig.apply(requiredAliases).stream().map(StockCounter.Combination::getUniqueSourceNameWithFriendlyClusterName).collect(Collectors.toSet());
        addToConfig.apply(optionalAliases);
        return result;
    }

    private static <T> T getValidSeriesWithResult(@NonNull Collection<@NonNull ChartAndSeriesConfig> templateChartsConfigs, @Nullable ICaptureDataProvider dataProvider, @NonNull List<@NonNull String> sources, @NonNull Predicate<@NonNull String> testIsValid, @NonNull TemplateSelectedFrom selectedFrom, @NonNull GetValidSeriesCallable<T> callback) {
        AtomicBoolean hasWildCard = new AtomicBoolean(false);
        @NonNull ArrayList<@NonNull AbstractSeriesConfig> seriesValid = new ArrayList<AbstractSeriesConfig>();
        @NonNull ArrayList<@NonNull AbstractSeriesConfig> totalSeriesWithWildCardsFixed = new ArrayList<AbstractSeriesConfig>();
        templateChartsConfigs.stream().forEach(templateChart -> {
            if (!hasWildCard.get() && selectedFrom == TemplateSelectedFrom.CounterDialog) {
                hasWildCard.set(templateChart.getUnexpandedSeries().stream().anyMatch(c -> c.isWildcardSeries()));
            }
            totalSeriesWithWildCardsFixed.addAll(TemplateUtils.getWildCardResolvedForSeries(templateChart, dataProvider, sources, selectedFrom));
        });
        seriesValid.addAll(TemplateUtils.findValidSeries(totalSeriesWithWildCardsFixed, testIsValid));
        return callback.call(seriesValid, hasWildCard.get(), totalSeriesWithWildCardsFixed);
    }

    public static @NonNull String getValidSeriesMessage(@NonNull Collection<@NonNull ChartAndSeriesConfig> templateChartsConfigs, @Nullable ICaptureDataProvider dataProvider, @NonNull List<@NonNull String> sources, @NonNull Predicate<@NonNull String> testIsValid, @NonNull TemplateSelectedFrom selectedFrom) {
        return TemplateUtils.getValidSeriesWithResult(templateChartsConfigs, dataProvider, sources, testIsValid, selectedFrom, (seriesValid, hasWildcard, totalSeriesWithWildCardsFixed) -> {
            String wildCardIndicator = hasWildcard ? TEMPLATE_WILDCARD_INDICATOR : "";
            return " (" + seriesValid.size() + "/" + totalSeriesWithWildCardsFixed.size() + wildCardIndicator + ")";
        });
    }

    public static int getValidSeries(@NonNull Collection<@NonNull ChartAndSeriesConfig> templateChartsConfigs, @Nullable ICaptureDataProvider dataProvider, @NonNull List<@NonNull String> sources, @NonNull Predicate<@NonNull String> testIsValid, @NonNull TemplateSelectedFrom selectedFrom) {
        return TemplateUtils.getValidSeriesWithResult(templateChartsConfigs, dataProvider, sources, testIsValid, selectedFrom, (seriesValid, hasWildcard, totalSeriesWithWildCardsFixed) -> seriesValid.size());
    }

    public static @NonNull ObjBoolPair<@NonNull Stream<@NonNull String>> getNotPredefinedVariables(@NonNull AbstractSeriesConfig seriesConfig) {
        ExpressionData expression = seriesConfig.getExpression();
        if (expression == null) {
            return new ObjBoolPair(Stream.of(new String[0]), seriesConfig.isOptional());
        }
        return new ObjBoolPair(ChartUtility.getVariableSetFromExpression(expression).stream().filter(v -> !SeriesRangeCalculator.isPredefinedVariable(v)), seriesConfig.isOptional());
    }

    public static @NonNull List<@NonNull AbstractSeriesConfig> findValidSeries(@NonNull Collection<@NonNull AbstractSeriesConfig> totalSeries, @NonNull Predicate<@NonNull String> testIsValid) {
        return totalSeries.stream().filter(s -> !s.isWildcardSeries()).filter(s -> ((Stream)TemplateUtils.getNotPredefinedVariables((AbstractSeriesConfig)s).first).allMatch(testIsValid)).collect(Collectors.toList());
    }

    public static boolean hasAllSources(@NonNull AbstractSeriesConfig config, @NonNull IAllBinDataProvider binData) {
        return ((Stream)TemplateUtils.getNotPredefinedVariables((AbstractSeriesConfig)config).first).allMatch(TemplateUtils.isValid(binData));
    }

    public static @NonNull Predicate<@NonNull String> isValid(@NonNull IAllBinDataProvider allBinData) {
        return variableFromExpression -> {
            String validSourceNameFromAlias = allBinData.makeValidSourceNameFromAlias((String)variableFromExpression);
            return allBinData.isValidSource(validSourceNameFromAlias);
        };
    }

    public static @NonNull List<@NonNull ChartAndSeriesConfig> getChartAndSeriesConfigsToBeApplied(TemplateFile template, boolean includeMissingSeries, @NonNull ICaptureDataProvider cdp) {
        return TemplateUtils.getChartAndSeriesConfigsToBeApplied(template, includeMissingSeries, (ChartAndSeriesConfig config) -> config.getAllExpandedSeries(cdp));
    }

    public static @NonNull List<@NonNull ChartAndSeriesConfig> getChartAndSeriesConfigsToBeApplied(TemplateFile template, boolean includeMissingSeries, boolean filterForWildCards, @NonNull List<@NonNull String> sources) {
        return TemplateUtils.getChartAndSeriesConfigsToBeApplied(template, includeMissingSeries, (ChartAndSeriesConfig config) -> filterForWildCards ? config.getAllExpandedSeriesOnlyForWildCards(sources) : config.getAllExpandedSeries(sources));
    }

    private static @NonNull List<@NonNull ChartAndSeriesConfig> getChartAndSeriesConfigsToBeApplied(TemplateFile template, boolean includeMissingSeries, @NonNull Function<@NonNull ChartAndSeriesConfig, List<@NonNull SeriesConfig>> expandedSeries) {
        @NonNull ArrayList<@NonNull ChartAndSeriesConfig> toBeAppliedConfigs = new ArrayList<ChartAndSeriesConfig>();
        for (ChartAndSeriesConfig config : template.getCharts()) {
            ChartAndSeriesConfig toBeApplied;
            if (config.getChart().getSeriesComposition() == SeriesComposition.VISUAL_ANNOTATION) continue;
            if (includeMissingSeries) {
                toBeApplied = config;
            } else {
                List<@NonNull SeriesConfig> seriesWithSources = expandedSeries.apply(config);
                if (seriesWithSources.isEmpty()) continue;
                toBeApplied = new ChartAndSeriesConfig(config.getChart());
                if (!seriesWithSources.isEmpty()) {
                    toBeApplied.addAllSeries(seriesWithSources);
                }
            }
            toBeAppliedConfigs.add(toBeApplied);
        }
        return toBeAppliedConfigs;
    }

    private static @NonNull List<@NonNull AbstractSeriesConfig> getWildCardResolvedForSeries(@NonNull ChartAndSeriesConfig charts, @Nullable ICaptureDataProvider dataProvider, @NonNull List<@NonNull String> sources, @NonNull TemplateSelectedFrom selectedFrom) {
        switch (selectedFrom) {
            case CounterDialog: {
                return charts.getUnexpandedSeries().stream().map(s -> {
                    List<SeriesConfig> createSeriesFromSources;
                    if (!sources.isEmpty() && !(createSeriesFromSources = s.createSeriesFromSources(sources)).isEmpty()) {
                        return createSeriesFromSources.iterator().next();
                    }
                    return s;
                }).filter(TemplateUtils.wildcardSeriesFilter()).collect(Collectors.toList());
            }
            case Timeline: {
                return charts.getUnexpandedSeries().stream().map(s -> {
                    List<SeriesConfig> createSeriesFromSources;
                    if (dataProvider != null && !(createSeriesFromSources = s.createSeriesFromSources(dataProvider)).isEmpty()) {
                        return createSeriesFromSources.iterator().next();
                    }
                    return s;
                }).filter(TemplateUtils.wildcardSeriesFilter()).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    private static @NonNull Predicate<@NonNull AbstractSeriesConfig> wildcardSeriesFilter() {
        return series -> {
            ExpressionData expression = series.getExpression();
            if (expression != null && expression.getString().equals("$MaliTimelineEventsPerfetto")) {
                return false;
            }
            return !series.isWildcardSeries();
        };
    }

    public static Optional<File> installAndLoad() {
        String lastPath = StreamlinePreferences.lastTemplateInstallLoadPath();
        FileDialog dialog = new FileDialog(WorkspaceUtils.getShell(), 4096);
        dialog.setText(TemplatesMessages.INSTALL_AND_LOAD);
        dialog.setFilterExtensions(new String[]{"*.st"});
        dialog.setFilterNames(new String[]{TemplatesMessages.TEMPLATE_FILES});
        dialog.setFilterPath(lastPath);
        String result = dialog.open();
        if (result != null) {
            lastPath = dialog.getFilterPath();
            StreamlinePreferences.setLastTemplateInstallLoadPath((String)NullChecking.neverNull((Object)lastPath));
            @NonNull File file = new File(result).getAbsoluteFile();
            @NonNull File parentDir = (File)NullChecking.neverNull((Object)file.getParentFile());
            @NonNull File templateDir = TemplatePath.DEFAULT_DIR.getAbsoluteFile();
            @NonNull String fileName = file.getName();
            @NonNull String fileNameWithoutExtension = (String)NullChecking.neverNull((Object)FilePath.getLeafName((String)fileName, (boolean)false));
            if (parentDir.equals(templateDir)) {
                Error.show(String.format(TemplatesMessages.ALREADY_INSTALLED, fileNameWithoutExtension));
                return Optional.empty();
            }
            if (!TemplatePath.isNamePermitted(file)) {
                Error.show(String.format(TemplatesMessages.ALREADY_EXISTS, fileNameWithoutExtension));
                return Optional.empty();
            }
            File dest = new File(templateDir, fileName);
            if (dest.exists()) {
                Error.show(String.format(TemplatesMessages.ALREADY_EXISTS, fileNameWithoutExtension));
                return Optional.empty();
            }
            try {
                CommonFileUtils.copyFile((File)file, (File)dest);
            }
            catch (Exception exception) {
                Error.show(String.format(TemplatesMessages.UNABLE_TO_INSTALL, fileNameWithoutExtension), exception, true);
                return Optional.empty();
            }
            return Optional.of(file);
        }
        return Optional.empty();
    }

    public static @Nullable TemplatePath getTemplateFromBuiltIn(@NonNull String maliDeviceName) {
        return TemplateUtils.hasTemplateFromBuiltIn(maliDeviceName).map(c -> new TemplatePath((String)c, true)).orElse(null);
    }

    public static @NonNull Optional<@NonNull String> hasTemplateFromBuiltIn(@NonNull String maliDeviceName) {
        return TemplatePath.STOCK_NAMES.stream().filter(c -> {
            @Nullable String matchedGpuTemplate = null;
            Matcher matcher = TEMPLATE_GPU_NAME_PATTERN.matcher((CharSequence)c);
            if (matcher.find()) {
                matchedGpuTemplate = matcher.group(1);
            }
            return matchedGpuTemplate != null && matchedGpuTemplate.equals(maliDeviceName);
        }).findFirst();
    }

    public static boolean checkIfTemplateMatchesDeviceGpu(@NonNull TemplateFile template, @NonNull String deviceGpu) {
        Matcher matcher = TEMPLATE_GPU_NAME_PATTERN.matcher(template.getName());
        if (matcher.find() && matcher.groupCount() > 0) {
            String templateGpu = (String)NullChecking.neverNull((Object)matcher.group(1));
            return templateGpu.equals(deviceGpu);
        }
        return true;
    }

    public static boolean isUserTemplate(@Nullable ITemplatePath path) {
        return path == null || !path.isStock();
    }

    public static boolean templateShouldBeAdded(@NonNull TemplateFile template, @NonNull Optional<@Nullable String> deviceGpu, @NonNull Collection<@NonNull String> availableSPE, boolean hasValidSeries) {
        if (TemplateUtils.isUserTemplate(template.getPath())) {
            return true;
        }
        boolean maliTemplate = template.getName().startsWith("Mali");
        boolean immortalisTemplate = template.getName().startsWith("Immortalis");
        boolean speTemplate = template.getName().contentEquals("SPE");
        if ((maliTemplate || immortalisTemplate) && deviceGpu.isPresent() && TemplateUtils.checkIfTemplateMatchesDeviceGpu(template, deviceGpu.get())) {
            return true;
        }
        if (speTemplate && !availableSPE.isEmpty()) {
            return true;
        }
        if (maliTemplate || immortalisTemplate || speTemplate) {
            return false;
        }
        return hasValidSeries;
    }

    @FunctionalInterface
    private static interface GetValidSeriesCallable<T> {
        public T call(@NonNull List<@NonNull AbstractSeriesConfig> var1, boolean var2, @NonNull List<@NonNull AbstractSeriesConfig> var3);
    }

    public static enum TemplateSelectedFrom {
        CounterDialog,
        Timeline;

    }
}

