/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.process;

import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueID;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueProcessID;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueThreadID;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.annotation.Annotations;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.process.HeatMapThreadComparator;
import com.arm.streamline.model.process.HeatmapDataCompute;
import com.arm.streamline.model.process.ITimelineMapProvider;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.streamline.model.process.TimelineMapMode;
import com.arm.streamline.model.process.TimelineRow;
import com.arm.streamline.model.process.TimelineRowType;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TimelineMap
implements ITimelineMapProvider {
    public static final @NonNull ZoomLevel[] SCALES = Scales.HI_RES_ZOOM_LEVELS;
    private @Nullable ZoomLevel mZoomLevel;
    private final @NonNull Analysis mAnalysis;
    private @Nullable Annotations mAnnotations;
    private final @NonNull List<@NonNull ITimelineRowProvider> mRootRows = new ArrayList<ITimelineRowProvider>();
    private final @NonNull List<@NonNull ITimelineRowProvider> mProcessRows = new ArrayList<ITimelineRowProvider>();
    private @Nullable List<@NonNull ITimelineRowProvider> cachedLastCpuRows;
    private @Nullable ICaptureDataProvider.IFocusedEventSource cachedLastFocusSource;
    private @NonNull TimelineMapMode mMapMode = TimelineMapMode.HEAT_MAP;
    private @Nullable Pattern mPattern;
    private final @NonNull HeatmapDataCompute heatmapDataCompute;
    private final int firstFreeId;
    private boolean mInverted = false;

    public TimelineMap(@NonNull Analysis analysis) {
        this.mAnalysis = analysis;
        this.heatmapDataCompute = new HeatmapDataCompute(analysis);
        this.updateScale();
        this.firstFreeId = this.createTimelineRows();
    }

    public Analysis getAnalysis() {
        return this.mAnalysis;
    }

    public @NonNull HeatmapDataCompute getHeatmapDataCompute() {
        return this.heatmapDataCompute;
    }

    public Annotations getAnnotations() {
        this.updateScale();
        return this.mAnnotations;
    }

    public Pattern getFilterPattern() {
        return this.mPattern;
    }

    @Override
    public @NonNull List<@NonNull ITimelineRowProvider> getRootTimelineRows() {
        if (!this.mInverted) {
            return this.mRootRows;
        }
        ICaptureDataProvider.IFocusedEventSource cachedLastFocusSource = this.cachedLastFocusSource;
        List<ITimelineRowProvider> cachedLastCpuRows = this.cachedLastCpuRows;
        ICaptureDataProvider.IFocusedEventSource currentFocusSource = this.mAnalysis.getFocusedEventSource();
        if (currentFocusSource == cachedLastFocusSource && cachedLastCpuRows != null) {
            return cachedLastCpuRows;
        }
        List<ITimelineRowProvider> result = this.createCpuRows(currentFocusSource);
        this.cachedLastFocusSource = currentFocusSource;
        this.cachedLastCpuRows = result;
        return result;
    }

    @Override
    public boolean focusChartChanged() {
        ICaptureDataProvider.IFocusedEventSource currentFocusSource = this.mAnalysis.getFocusedEventSource();
        List<ITimelineRowProvider> result = this.createCpuRows(currentFocusSource);
        this.cachedLastFocusSource = currentFocusSource;
        this.cachedLastCpuRows = result;
        return this.mInverted;
    }

    @Override
    public boolean isFilterMatch(@NonNull IUniqueProcessID process) {
        Pattern mPattern = this.mPattern;
        if (mPattern == null) {
            return true;
        }
        String processName = String.format("%s #%s", NullChecking.neverNullOr((Object)process.getName(), (Object)"Unknown"), Integer.toUnsignedString(process.getOriginalID()));
        return mPattern.matcher(processName).find();
    }

    @Override
    public boolean isFilterMatch(@NonNull IUniqueThreadID thread) {
        Pattern mPattern = this.mPattern;
        if (mPattern == null) {
            return true;
        }
        String threadName = String.format("%s #%s", thread.getNameOrUnknown(), Integer.toUnsignedString(thread.getOriginalID()));
        return mPattern.matcher(threadName).find();
    }

    @Override
    public @NonNull List<@NonNull ITimelineRowProvider> getProcessLevelTimelineRows() {
        return this.mProcessRows;
    }

    @Override
    public @NonNull List<@NonNull ITimelineRowProvider> createCpuRows(@NonNull ICaptureDataProvider.IFocusedEventSource focus) {
        ArrayList<ITimelineRowProvider> result = new ArrayList<ITimelineRowProvider>();
        Collection<ICaptureDataProvider.IFocusedEventSourceCore> cores = focus.getCores();
        int index = 0;
        for (ICaptureDataProvider.IFocusedEventSourceCore core : cores) {
            result.add(new TimelineRow(this, this.mAnalysis.getUniqueIdMap(), core.getProcessingElementReference().vmUID, index, core.getDescriptiveLabel(), this.firstFreeId + index));
            ++index;
        }
        return result;
    }

    @Override
    public TimelineMapMode getMode() {
        return this.mMapMode;
    }

    @Override
    public void setFilterPattern(Pattern pattern) {
        if (this.mPattern != pattern) {
            for (ITimelineRowProvider row : this.mRootRows) {
                row.setPassesFilter(pattern == null || pattern.matcher(row.getName()).find());
            }
            this.mPattern = pattern;
        }
    }

    @Override
    public boolean setInverted(boolean inverted) {
        if (this.mInverted == inverted) {
            return false;
        }
        this.mInverted = inverted;
        return true;
    }

    @Override
    public void setMode(TimelineMapMode mode) {
        this.mMapMode = mode;
    }

    public void updateScale() {
        @NonNull ZoomLevel zoomLevel = this.getAnalysis().getScales().getZoomLevel();
        if (!zoomLevel.equals((Object)this.mZoomLevel)) {
            this.mZoomLevel = zoomLevel;
            this.mAnnotations = this.getAnalysis().getAnnotations(zoomLevel);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private int createTimelineRows() {
        int id = 0;
        @NonNull HeatMapThreadComparator comparator = new HeatMapThreadComparator(this.mAnalysis.getUniqueIdMap());
        boolean showProcesses = this.mAnalysis.shouldShowProcesses();
        boolean showIdle = !this.mAnalysis.isApplicationTracingMode();
        IUniqueIds uniqueIdMap = this.mAnalysis.getUniqueIdMap();
        List<@NonNull T> roots = showProcesses ? this.mAnalysis.getUniqueIdMap().getProcesses().collect(Collectors.toList()) : this.mAnalysis.getUniqueIdMap().getThreads().collect(Collectors.toList());
        Collections.sort(roots, comparator);
        for (IUniqueID root : roots) {
            TimelineRow th;
            if (root.getVmUID() != 0L) {
                String kind = showProcesses ? "process" : "thread";
                throw new AssertionError((Object)("Unexpected vmuid " + root.getVmUID() + " for a " + kind + ", name: " + root.getName() + ".  Vmuid expected to be 0"));
            }
            if (!showIdle && uniqueIdMap.isIdleUID(root.getUID())) continue;
            id = Math.max(id, root.getUID());
            if (showProcesses) {
                th = new TimelineRow(this, comparator, root, TimelineRowType.PROCESS, uniqueIdMap);
                this.mRootRows.add(th);
                this.mProcessRows.add(th);
                continue;
            }
            th = new TimelineRow(this, comparator, root, TimelineRowType.THREAD, uniqueIdMap);
            this.mRootRows.add(th);
            this.mProcessRows.add(th);
            id = Math.max(id, root.getUID());
        }
        for (ITimelineRowProvider row : this.mRootRows) {
            id = this.createUniqueIDs(row, id);
        }
        return id;
    }

    private int createUniqueIDs(ITimelineRowProvider row, int id) {
        switch (row.getRowType()) {
            case GROUP: 
            case ANNOTATION: 
            case CPU: {
                ((TimelineRow)row).setThreadHierarchyUniqueID(++id);
                break;
            }
            case PROCESS: 
            case THREAD: 
            case VMUID: {
                break;
            }
            default: {
                throw new AssertionError((Object)row.getRowType());
            }
        }
        for (ITimelineRowProvider child : row.getChildren()) {
            id = this.createUniqueIDs(child, id);
        }
        return id;
    }
}

