/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.process;

import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.io.StreamUtils;
import com.arm.streamline.report.model.uids.IUniqueLifetimes;
import gnu.trove.list.array.TLongArrayList;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.OptionalLong;

public class ThreadLifetime
implements IUniqueLifetimes {
    public static final String THREAD_LIFETIME_FILE = "thread_lifetime.bin";
    public static final String THREAD_LIFETIME_PATH = "/timeline/focus/thread_lifetime.bin";
    private TLongArrayList mSpawnTimes = new TLongArrayList();
    private TLongArrayList mKillTimes = new TLongArrayList();
    private int maxUID;

    public ThreadLifetime(File reportDir) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DataInputStream in = StreamUtils.createBufferedDataInput((File)new File(reportDir, FilePath.PATH_SEPARATOR + THREAD_LIFETIME_PATH));){
                while (in.available() >= 16) {
                    this.mSpawnTimes.add(in.readLong());
                    this.mKillTimes.add(in.readLong());
                }
                this.maxUID = this.mSpawnTimes.size() - 1;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public OptionalLong getEndTime(int uid) {
        if (uid > this.maxUID) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(this.mKillTimes.get(uid));
    }

    public OptionalLong getStartTime(int uid) {
        if (uid > this.maxUID) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(this.mSpawnTimes.get(uid));
    }
}

