/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.process;

import com.arm.streamline.utility.RGBUtils;
import com.arm.streamline.widget.Colors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;

public class ThreadAnnotation {
    private RGB mColor;
    private String mDescription;
    private int mId;
    private boolean mIsStartFrame;
    private boolean mIsEndFrame;

    public ThreadAnnotation(RGB color, String description, int id, boolean startFrame, boolean endFrame) {
        this.mColor = color;
        this.mDescription = description;
        this.mId = id;
        this.mIsStartFrame = startFrame;
        this.mIsEndFrame = endFrame;
    }

    public final @NonNull ThreadAnnotation duplicate(int id) {
        return new ThreadAnnotation(this.mColor, this.mDescription, id, this.mIsStartFrame, this.mIsEndFrame);
    }

    public final RGB getColor() {
        return this.mColor;
    }

    public final String getDescription() {
        return this.mDescription;
    }

    public final int getId() {
        return this.mId;
    }

    public final boolean isEndFrame() {
        return this.mIsEndFrame;
    }

    public final boolean isStartFrame() {
        return this.mIsStartFrame;
    }

    public final void setId(int id) {
        this.mId = id;
    }

    public final String toString() {
        return "color = " + RGBUtils.encode(this.mColor) + ", start = " + this.mIsStartFrame + ", stop = " + this.mIsEndFrame + ", id = " + this.mId;
    }

    public final void update(ThreadAnnotation first) {
        this.mColor = Colors.getDarkGray().getRGB();
        this.mDescription = "";
        if (first.isStartFrame()) {
            this.mIsStartFrame = true;
        }
        if (first.isEndFrame()) {
            this.mIsEndFrame = true;
        }
    }
}

