/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.iterable;

import com.arm.streamline.jni.apcdbgen.proto.CallPathNode;
import com.arm.streamline.jni.apcdbgen.proto.IBasicSourceReference;
import com.arm.streamline.jni.apcdbgen.proto.IExtractable;
import com.arm.streamline.jni.apcdbgen.proto.ISourceLineReference;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueID;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueProcessID;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueThreadID;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import com.arm.streamline.jni.apcdbgen.proto.Symbol;
import com.arm.streamline.jni.reportmodel.icounters.CallPathRowValue;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterSource;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.iterable.SelectionIterator;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.ISelection;

public class CallPathSelectionIterator
extends SelectionIterator<CallPathNode> {
    private final @NonNull Analysis mAnalysis;

    public CallPathSelectionIterator(ISelection selection, @NonNull Analysis analysis) {
        super(selection);
        this.mAnalysis = analysis;
    }

    @Override
    protected void extract(@NonNull IExtractable extractable, final @NonNull List<@NonNull CallPathNode> list) {
        extractable.accept((IExtractable.IExtractableVisitor)new IExtractable.IExtractableVisitor<Void, RuntimeException>(){

            public Void visit(@NonNull CallPathNode value) throws RuntimeException {
                list.add(value);
                return null;
            }

            public Void visit(@NonNull IBasicSourceReference value) throws RuntimeException {
                return null;
            }

            public Void visit(@NonNull ISourceLineReference value) throws RuntimeException {
                return null;
            }

            public Void visit(@NonNull IUniqueProcessID value) throws RuntimeException {
                CallPathSelectionIterator.this.extractCallPathNodes((IUniqueID)value, list);
                return null;
            }

            public Void visit(@NonNull IUniqueThreadID value) throws RuntimeException {
                CallPathSelectionIterator.this.extractCallPathNodes((IUniqueID)value, list);
                return null;
            }

            public Void visit(@NonNull ReferencedSymbol value) throws RuntimeException {
                return null;
            }

            public Void visit(@NonNull ReferencedSymbol value, @NonNull Collection<@NonNull CallPathNode> associatedPaths) throws RuntimeException {
                list.addAll(associatedPaths);
                return null;
            }

            public Void visit(@NonNull SourceFile value) throws RuntimeException {
                return null;
            }

            public Void visit(@NonNull Symbol value) throws RuntimeException {
                return null;
            }
        });
    }

    private void extractCallPathNodes(@NonNull IUniqueID uid, @NonNull List<@NonNull CallPathNode> list) {
        for (IInstructionCounterSource source : this.mAnalysis.getInstructionCounterModel().getInstructionCounterSources()) {
            CallPathRowValue node = source.getCallPathForUniqueID(uid);
            if (node == null) continue;
            list.add(node.getCallPathNode());
        }
    }
}

