/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.icounters.legacyimpl;

import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.jni.apcdbgen.ProfilingFilterParams;
import com.arm.streamline.jni.apcdbgen.ProfilingLoadOptions;
import com.arm.streamline.jni.apcdbgen.impl.ApcReport;
import com.arm.streamline.jni.apcdbgen.proto.IApcReport;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterColumnAccessorFactory;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReport;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReportData;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReportPeriodicSamplesData;
import com.arm.streamline.jni.apcdbgen.proto.ImageFile;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import com.arm.streamline.jni.common.CancellationPredicate;
import com.arm.streamline.jni.common.IProgressMonitorFactory;
import com.arm.streamline.jni.common.WarningItem;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterModel;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterSource;
import com.arm.streamline.jni.reportmodel.icounters.SamplesData;
import com.arm.streamline.model.icounters.legacyimpl.InstructionCounterSource;
import com.arm.streamline.report.model.IVirtualMachineBasicProperties;
import com.arm.streamline.report.model.PathSubstitutionsFile;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.utils.NullChecking;
import com.arm.utils.StreamUtils;
import com.arm.utils.function.Throwing;
import gnu.trove.map.TLongObjectMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class InstructionCountersModel
implements IInstructionCounterModel {
    private final @NonNull IApcReport apcReport;
    private final @NonNull String largestFilename;
    private final boolean nativeBackend;
    private final @NonNull PathSubstitutionsFile pathSubstitutionsFile;
    private final @Nullable InstructionCounterSource periodicSamplesSource;
    private final @NonNull List<@NonNull InstructionCounterSource> sources = new ArrayList<InstructionCounterSource>();

    public static @NonNull InstructionCountersModel fromNative(@NonNull ApcReport apcReport, @NonNull CancellationPredicate cancellationPredicate, @NonNull IProgressMonitorFactory progressMonitorFactory, @NonNull IUniqueIds uniqueIds, @NonNull IProgressTracker tracker, @NonNull File reportDirectory, @NonNull TLongObjectMap<? extends IVirtualMachineBasicProperties> vmStateMap, @NonNull PathSubstitutionsFile pathSubstitutionsFile, boolean filterCallStacks, boolean filterKernelAddresses, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ProfilingLoadOptions.GroupingMode groupingMode, boolean useInlines) throws Exception {
        return new InstructionCountersModel((IApcReport)apcReport, cancellationPredicate, progressMonitorFactory, uniqueIds, tracker, reportDirectory, vmStateMap, pathSubstitutionsFile, filterCallStacks, filterKernelAddresses, groupingMode, useInlines, true);
    }

    private static @NonNull String computeLargestFilenameInImage(@NonNull ImageFile image) {
        String srcName = (String)NullChecking.neverNull((Object)StreamUtils.filterOutNull(image.symbols.stream().map(s -> s.sourceLocation)).map(l -> l.sourceFile.getFileName()).max(Comparator.comparing(String::length)).orElse(""));
        String imageName = image.getNameWithContainer();
        if (srcName.length() > imageName.length()) {
            return srcName;
        }
        return imageName;
    }

    private InstructionCountersModel(@NonNull IApcReport apcReport, @NonNull CancellationPredicate cancellationPredicate, @NonNull IProgressMonitorFactory progressMonitorFactory, @NonNull IUniqueIds uniqueIds, @NonNull IProgressTracker tracker, @NonNull File reportDirectory, @NonNull TLongObjectMap<? extends IVirtualMachineBasicProperties> vmStateMap, @NonNull PathSubstitutionsFile pathSubstitutionsFile, boolean filterCallStacks, boolean filterKernelAddresses, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ProfilingLoadOptions.GroupingMode groupingMode, boolean useInlines, boolean nativeBackend) throws Exception {
        this.pathSubstitutionsFile = pathSubstitutionsFile;
        this.apcReport = apcReport;
        this.nativeBackend = nativeBackend;
        InstructionCounterSource periodicSamplesSource = null;
        try {
            for (ISamplesReport report : apcReport.getSampleReports()) {
                ISamplesReportData data = report.computeFilteredSampleData(new ProfilingFilterParams(null, null, filterCallStacks, filterKernelAddresses), new ProfilingLoadOptions(useInlines, true, true, groupingMode), cancellationPredicate, progressMonitorFactory);
                if (data == null) {
                    throw new InterruptedException();
                }
                try {
                    InstructionCounterSource source = new InstructionCounterSource(this, report, data);
                    this.sources.add(source);
                    if (!report.hasPeriodicSamplesCount()) continue;
                    assert (periodicSamplesSource == null);
                    periodicSamplesSource = source;
                }
                catch (Throwable t) {
                    try {
                        data.close();
                    }
                    catch (Throwable t1) {
                        t.addSuppressed(t1);
                    }
                    throw t;
                }
            }
        }
        catch (Throwable t) {
            try {
                Throwing.closeAllIfCloseable((Iterable[])new Iterable[]{this.sources, List.of(apcReport)});
            }
            catch (Throwable t1) {
                t.addSuppressed(t1);
            }
            throw t;
        }
        this.periodicSamplesSource = periodicSamplesSource;
        this.largestFilename = (String)NullChecking.neverNull((Object)apcReport.getSampleReports().stream().map(ISamplesReport::getSymbols).flatMap(Collection::stream).map(s -> s.symbol.image).distinct().map(InstructionCountersModel::computeLargestFilenameInImage).max(Comparator.comparing(String::length)).orElse(""));
    }

    public boolean canFilterThreadsDynamically() {
        return this.nativeBackend;
    }

    public void close() throws Exception {
        Throwing.closeAllIfCloseable((Iterable[])new Iterable[]{this.sources, List.of(this.apcReport)});
    }

    public @NonNull String computeFullPath(@NonNull SourceFile sourceFile) {
        return this.pathSubstitutionsFile.computeUpdatedPath(sourceFile);
    }

    public @NonNull Callable<@NonNull List<@NonNull SamplesData>> createRecomputeCSMSamplesData(@NonNull CancellationPredicate cancellationPredicate, @NonNull IProgressMonitorFactory progressMonitorFactory, long fromUs, long toUs, boolean filterCallStacks, boolean filterKernelAddresses, boolean useInlines) {
        return () -> {
            List reports = this.apcReport.getSampleReports();
            @Nullable ISamplesReport periodicSamplesReport = reports.stream().filter(r -> r.hasPeriodicSamplesCount()).findFirst().orElse(null);
            if (periodicSamplesReport == null) {
                return Collections.emptyList();
            }
            ISamplesReportPeriodicSamplesData data = periodicSamplesReport.computeFilteredPeriodicSamplesCount(new ProfilingFilterParams(Long.valueOf(fromUs * 1000L), Long.valueOf(toUs * 1000L), filterCallStacks, filterKernelAddresses), new ProfilingLoadOptions(useInlines, true, true, ProfilingLoadOptions.GroupingMode.THREAD), cancellationPredicate, progressMonitorFactory);
            if (data == null) {
                return Collections.emptyList();
            }
            long total = data.getTotalValue();
            return StreamUtils.filterOutNull(data.getReferencedSymbols().stream().map(s -> {
                Long value = data.getValueFor(s.uid);
                if (value == null) {
                    return null;
                }
                ISampleCounterColumnAccessorFactory.PercentAndLong percent = ISampleCounterColumnAccessorFactory.PercentAndLong.fromValueAndTotal((long)value, (long)total);
                if (percent == null) {
                    return null;
                }
                return new SamplesData(s, percent);
            })).collect(Collectors.toUnmodifiableList());
        };
    }

    public @NonNull Callable<Void> createRecomputeSelectedCounterRange(@NonNull CancellationPredicate cancellationPredicate, @NonNull IProgressMonitorFactory progressMonitorFactory, long fromUs, long toUs, boolean filterCallStacks, boolean filterKernelAddresses, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ProfilingLoadOptions.GroupingMode groupingMode, boolean useInlines, long @Nullable [] upids, long @Nullable [] utids) {
        assert (upids == null || this.nativeBackend);
        assert (utids == null || this.nativeBackend);
        return () -> {
            List reports = this.apcReport.getSampleReports();
            ArrayList<ISamplesReportData> newData = new ArrayList<ISamplesReportData>(reports.size());
            try {
                for (ISamplesReport report : reports) {
                    ISamplesReportData data = report.computeFilteredSampleData(new ProfilingFilterParams(null, null, null, null, null, null, upids, null, utids, null, Long.valueOf(fromUs * 1000L), Long.valueOf(toUs * 1000L), filterCallStacks, filterKernelAddresses), new ProfilingLoadOptions(useInlines, true, true, groupingMode), cancellationPredicate, progressMonitorFactory);
                    if (data == null) {
                        throw new InterruptedException();
                    }
                    try {
                        newData.add(data);
                    }
                    catch (Throwable t) {
                        try {
                            data.close();
                        }
                        catch (Throwable t1) {
                            t.addSuppressed(t1);
                        }
                        throw t;
                    }
                }
                assert (this.sources.size() == reports.size());
                assert (this.sources.size() == newData.size());
                int i = 0;
                while (i < newData.size()) {
                    this.sources.get(i).update((ISamplesReportData)newData.get(i));
                    ++i;
                }
            }
            catch (Throwable t) {
                try {
                    Throwing.closeAllIfCloseable((Iterable[])new Iterable[]{newData});
                }
                catch (Throwable t1) {
                    t.addSuppressed(t1);
                }
                throw t;
            }
            return null;
        };
    }

    public @NonNull IInstructionCounterSource getDefaultSource() {
        InstructionCounterSource periodicSamplesSource = this.periodicSamplesSource;
        if (periodicSamplesSource != null) {
            return periodicSamplesSource;
        }
        return this.sources.get(0);
    }

    public @NonNull List<@NonNull IInstructionCounterSource> getInstructionCounterSources() {
        return Collections.unmodifiableList(this.sources);
    }

    public @NonNull String getLargestFileName() {
        return this.largestFilename;
    }

    public @Nullable IInstructionCounterSource getSamplesPanelSource() {
        return this.periodicSamplesSource;
    }

    public @NonNull List<@NonNull String> getUnadjustedSourceDirectories() {
        return this.apcReport.getUnadjustedSourceDirectories();
    }

    public @NonNull Set<@NonNull WarningItem> getWarnings() {
        return this.apcReport.getWarnings();
    }

    public boolean shouldShowProcesses() {
        return this.apcReport.shouldCallPathTreeIncludeProcesses();
    }
}

