/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.chart;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.CounterMode;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.model.bindata.IAllBinDataProvider;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.chart.ChartUtility;
import com.arm.streamline.model.chart.ITimelineLadderWalker;
import com.arm.streamline.model.chart.SeriesRangeInfo;
import com.arm.streamline.utility.expression2.ExpressionException;
import com.arm.streamline.utility.expression2.ExpressionNodeFactory;
import com.arm.streamline.utility.expression2.IExpressionEvaluatorHelper;
import com.arm.utils.NullChecking;
import gnu.trove.set.TIntSet;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SeriesRangeCalculator {
    public static final @NonNull String ZOOM_VARIABLE = "ZOOM";
    private static final int[] REMAINDER_THRESHOLD_2;
    private static final int[] REMAINDER_THRESHOLD_5;
    private static final int[] REMAINDER_THRESHOLD_10;
    private static final int MAXIMUM_FRACTION_DIGITS = 10;
    private final DecimalFormat decimalFormat = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.getDefault()));
    private final @NonNull ICaptureDataProvider mCaptureDataProvider;
    private final @NonNull ZoomLevel @NonNull [] allZoomLevels;
    private final @NonNull ZoomLevel mDensestZoomLevel;
    private final @NonNull IAllBinDataProvider mBinData;
    private final boolean mUseLadder;

    static {
        int[] nArray = new int[2];
        nArray[1] = 1;
        REMAINDER_THRESHOLD_2 = nArray;
        int[] nArray2 = new int[5];
        nArray2[1] = 2;
        nArray2[2] = 4;
        nArray2[3] = 3;
        nArray2[4] = 1;
        REMAINDER_THRESHOLD_5 = nArray2;
        int[] nArray3 = new int[10];
        nArray3[1] = 5;
        nArray3[2] = 2;
        nArray3[3] = 7;
        nArray3[4] = 4;
        nArray3[5] = 9;
        nArray3[6] = 8;
        nArray3[7] = 3;
        nArray3[8] = 6;
        nArray3[9] = 1;
        REMAINDER_THRESHOLD_10 = nArray3;
    }

    public static boolean isPredefinedVariable(@NonNull String variable) {
        return variable.equals(ZOOM_VARIABLE);
    }

    private static long highResolutionValue(long value, int rescaleFactor, long desiredBin, int scale) {
        int zoomLevelOfValue = scale;
        int desiredZoom = rescaleFactor * scale;
        int factor = desiredZoom / zoomLevelOfValue;
        while (factor >= 2) {
            int[] threshold;
            int itrFactor = factor >= 10 ? 10 : (factor % 5 == 0 ? 5 : 2);
            int remainder = (int)(value % (long)itrFactor);
            int position = (int)(desiredBin / (long)(factor / itrFactor) % (long)itrFactor);
            factor /= itrFactor;
            value /= (long)itrFactor;
            switch (itrFactor) {
                case 10: {
                    threshold = REMAINDER_THRESHOLD_10;
                    break;
                }
                case 5: {
                    threshold = REMAINDER_THRESHOLD_5;
                    break;
                }
                case 2: {
                    threshold = REMAINDER_THRESHOLD_2;
                    break;
                }
                default: {
                    threshold = REMAINDER_THRESHOLD_10;
                    CommonPlugin.error((String)"Invalid threshold", (Throwable)new Throwable());
                }
            }
            if (remainder <= threshold[position]) continue;
            ++value;
        }
        return value;
    }

    public SeriesRangeCalculator(@NonNull ICaptureDataProvider captureDataProvider, @NonNull IAllBinDataProvider binData, boolean useLadder) {
        Scales scales = captureDataProvider.getScales();
        this.mCaptureDataProvider = captureDataProvider;
        this.allZoomLevels = scales.getAvailableZoomLevels();
        this.mDensestZoomLevel = scales.getDensestZoomLevel();
        this.mBinData = binData;
        this.mUseLadder = useLadder;
        this.decimalFormat.setMaximumFractionDigits(10);
    }

    public double getAggregateRange(SeriesRangeInfo info, int start, int end) {
        return this.getRangeAndAveragePerCore(info, start, end, info.getChannelDescriptors());
    }

    public double getCoreRange(SeriesRangeInfo info, int start, int end, @NonNull ProcessingElementReference peReference) {
        return this.getRangeAndAveragePerCore(info, start, end, new ProcessingElementReference[]{peReference});
    }

    private double getRangeAndAveragePerCore(SeriesRangeInfo info, int start, int end, @NonNull ProcessingElementReference @NonNull [] peReferences) {
        int lastValidBin = this.mCaptureDataProvider.getBinCountForDensestScale() - 1;
        int originalEnd = end;
        int n = end = end > lastValidBin ? lastValidBin : end;
        if (start < 0 || end < start || start > lastValidBin) {
            return 0.0;
        }
        double value = 0.0;
        if (info.isAverageCores()) {
            ProcessingElementReference[] processingElementReferenceArray = peReferences;
            int n2 = peReferences.length;
            int n3 = 0;
            while (n3 < n2) {
                ProcessingElementReference peReference = processingElementReferenceArray[n3];
                value += this.getRangeUsingLadder(info, start, end, originalEnd, new ProcessingElementReference[]{peReference});
                ++n3;
            }
            value /= (double)peReferences.length;
        } else {
            value = this.getRangeUsingLadder(info, start, end, originalEnd, peReferences);
        }
        return value;
    }

    private void getRangeAtScale(@NonNull ZoomLevel ladderZoomLevel, SeriesRangeInfo info, @NonNull String @Nullable [] sources, double[] values, int start, int end, @NonNull ProcessingElementReference @NonNull [] peReferences, double averageFactor) {
        CounterDisplay display = info.getDisplay();
        if (peReferences.length <= 0) {
            return;
        }
        if (sources == null) {
            return;
        }
        int sourceIndex = 0;
        while (sourceIndex < sources.length) {
            @NonNull IBinDataProvider provider = (IBinDataProvider)NullChecking.neverNull((Object)this.mBinData.getBinData(sources[sourceIndex]));
            boolean isConstant = provider.getCounterRecord().getCounterClass() == CounterClass.CONSTANT;
            boolean isSystemWide = provider.getCounterRecord().getMode() == CounterMode.SYSTEM_WIDE;
            @NonNull CounterDisplay loadDisplay = isConstant ? CounterDisplay.AVERAGE : display;
            ProcessingElementReference[] processingElementReferenceArray = peReferences;
            int n = peReferences.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessingElementReference peReference = processingElementReferenceArray[n2];
                int channelNumber = provider.mapChannelNumber(peReference);
                if (isConstant && isSystemWide) {
                    peReference = ProcessingElementReference.create((DeviceType)peReference.deviceType, (long)peReference.vmUID, (int)0);
                }
                if (channelNumber >= 0) {
                    int i = start;
                    while (i <= end) {
                        double result = SeriesRangeCalculator.getSourceValue(i, provider, channelNumber, ladderZoomLevel, loadDisplay, (TIntSet)info.getUtids());
                        if (isConstant) {
                            values[sourceIndex] = result;
                        } else {
                            switch (display) {
                                case MAXIMUM: {
                                    if (!(result > values[sourceIndex])) break;
                                    values[sourceIndex] = result;
                                    break;
                                }
                                case MINIMUM: {
                                    if (!(result < values[sourceIndex])) break;
                                    values[sourceIndex] = result;
                                    break;
                                }
                                case AVERAGE: {
                                    int n3 = sourceIndex;
                                    values[n3] = values[n3] + result * averageFactor / (double)peReferences.length;
                                    break;
                                }
                                default: {
                                    int n4 = sourceIndex;
                                    values[n4] = values[n4] + result;
                                }
                            }
                        }
                        ++i;
                    }
                }
                ++n2;
            }
            ++sourceIndex;
        }
    }

    private double getRangeUsingLadder(SeriesRangeInfo info, int start, int end, int originalEnd, @NonNull ProcessingElementReference @NonNull [] peReferences) {
        boolean isExpressionASingleValidSource;
        double value = 0.0;
        final @NonNull ZoomLevel uiZoomLevel = info.getUIZoomLevelOverride() != null ? (ZoomLevel)NullChecking.neverNull((Object)info.getUIZoomLevelOverride()) : this.mCaptureDataProvider.getScales().getZoomLevel();
        CounterDisplay display = info.getDisplay();
        Set<@NonNull String> variables = info.getExpressionSources();
        this.mBinData.retainAndReplaceSourcesFromSelected(variables);
        final @NonNull String @NonNull [] sources = variables.toArray(new String[variables.size()]);
        double[] sourceValues = new double[sources.length];
        if (display.isMinimum()) {
            int d = 0;
            while (d < sourceValues.length) {
                sourceValues[d] = Double.MAX_VALUE;
                ++d;
            }
        }
        if (this.mUseLadder) {
            ITimelineLadderWalker.walkLadder(this.allZoomLevels, uiZoomLevel, start, end - start + 1, (zoom, from, len, factor) -> {
                int to = from + len - 1;
                this.getRangeAtScale(zoom, info, sources, sourceValues, from, to, peReferences, factor);
            });
        } else {
            this.getRangeAtScale(this.mDensestZoomLevel, info, sources, sourceValues, start, end, peReferences, 1.0);
        }
        final double[] finalSourceValues = sourceValues;
        int numBinsSelectedAtDensestScale = end - start + 1;
        double thisScaleToUIZoomLevelRatio = (double)this.mDensestZoomLevel.getBps() / (double)uiZoomLevel.getBps();
        final double numBinsSelectedAtUIZoomLevelAccountingForFractionalLastBin = (double)numBinsSelectedAtDensestScale / thisScaleToUIZoomLevelRatio;
        int numBinsOriginallSelectedAtDensestZoomLevel = originalEnd - start + 1;
        double numBinsSelectedAtUIZoomLevelNotAccountingForFractionalLastBin = (double)numBinsOriginallSelectedAtDensestZoomLevel / thisScaleToUIZoomLevelRatio;
        if (display.isAverage()) {
            int index = 0;
            while (index < finalSourceValues.length) {
                int n = index++;
                finalSourceValues[n] = finalSourceValues[n] / numBinsSelectedAtUIZoomLevelAccountingForFractionalLastBin;
            }
        }
        String expressionSourceName = info.getExpression().asSingleSourceNameExpression();
        boolean bl = isExpressionASingleValidSource = sources.length == 1 && expressionSourceName != null ? sources[0].contentEquals(this.mBinData.makeValidSourceNameFromAlias(expressionSourceName)) : false;
        if (isExpressionASingleValidSource) {
            value = finalSourceValues[0];
        } else {
            try {
                ExpressionNodeFactory.IBaseExpressionNode tree = info.getExpression().getSyntaxTree();
                if (tree != null) {
                    value = tree.evaluateToNumber(new IExpressionEvaluatorHelper(){

                        @Override
                        public double evaluateZoom() {
                            return 1.0 / (double)uiZoomLevel.getBps() * numBinsSelectedAtUIZoomLevelAccountingForFractionalLastBin;
                        }

                        @Override
                        public double evaluateVariable(@NonNull String variable) throws ExpressionException {
                            int sourceIndex = 0;
                            while (sourceIndex < sources.length) {
                                if (sources[sourceIndex].contentEquals(variable)) {
                                    return finalSourceValues[sourceIndex];
                                }
                                ++sourceIndex;
                            }
                            return 0.0;
                        }
                    });
                }
            }
            catch (ExpressionException expressionException) {
                // empty catch block
            }
        }
        if (display.isHertz()) {
            value *= (double)uiZoomLevel.getBps();
        }
        if (info.isAverageSelection() && ChartUtility.isAverageSelectionPossible(display, info.isExpressionComplex())) {
            value /= numBinsSelectedAtUIZoomLevelNotAccountingForFractionalLastBin;
        }
        return value;
    }

    private static double getSourceValue(int timeIndex, @NonNull IBinDataProvider provider, int channelNumber, @NonNull ZoomLevel ladderZoomLevel, @NonNull CounterDisplay display, @Nullable TIntSet tids) {
        double value;
        int rescaleFactor = provider.getRescale(ladderZoomLevel);
        int scale = ladderZoomLevel.getBps() / rescaleFactor;
        long longValue = provider.getValue(display, scale, timeIndex / rescaleFactor, channelNumber, tids);
        if ((display.isAccumulate() || display.isHertz()) && rescaleFactor > 1) {
            longValue = SeriesRangeCalculator.highResolutionValue(longValue, rescaleFactor, timeIndex, scale);
        }
        if ((value = (double)longValue * provider.getCounterRecord().getMultiplier()) < 0.0) {
            value = 0.0;
        }
        return value;
    }
}

