/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.capture;

import com.arm.streamline.common.model.InvalidVersionException;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.model.capture.CAMConfig;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ChartAndSeriesXMLParser;
import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class TimelineConfig
implements Cloneable {
    private static final int CURRENT_VERSION = 10;
    private static final int MINIMUM_VERSION = 9;
    private static final String TAG = "capture_configuration";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_HANDLE_WIDTH = "handle_width";
    private static final String ATTR_SCALE = "scale";
    private static final String ATTR_SCROLL = "scroll";
    private static final String ATTR_DIVIDER = "divider";
    private static final String ATTR_CSM_LEFT = "csm_left";
    private static final String ATTR_CSM_RIGHT = "csm_right";
    private static final String ATTR_CALIPER_LEFT = "caliper_left";
    private static final String ATTR_CALIPER_RIGHT = "caliper_right";
    private static final String ATTR_DETAIL_AREA_MODE = "detail_area_mode";
    private static final String ATTR_IS_FROM_LIVE = "is_from_live";
    private static final String ATTR_SHOW_BOOKMARKS = "show_bookmarks";
    private static final String ATTR_SHOW_ALL_CAM_CONNECTIONS = "show_all_cam_connections";
    private static final String ATTR_TEMPLATE = "template";
    private static final String ATTR_HEATMAP_FILTER = "heatmap_filter";
    private static final String ATTR_ANNOTATION_FILTER = "annotation_filter";
    private static final String ATTR_HEATMAP_SHOW_AVERAGE_PER_CORE = "heatmap_average_per_core";
    private static final String ATTR_FOCUS_SOURCE = "focus_source";
    private static final String TAG_OPEN_HEATMAP_ROW = "open_heatmap_row";
    private static final String TAG_SELECTED_HEATMAP_ROW = "selected_heatmap_row";
    private static final String ATTR_ID = "id";
    private static final int DEFAULT_SCALE = 60;
    private @NonNull List<@NonNull ChartAndSeriesConfig> mCharts = new ArrayList<ChartAndSeriesConfig>();
    private int mHandleWidth;
    private int mScale = 60;
    private long mScrollPosition;
    private int mDividerPosition = -1;
    private long mCalipersLeft = -1L;
    private long mCalipersRight = -1L;
    private long mCrossSectionMarkerLeft = -1L;
    private long mCrossSectionMarkerRight = -1L;
    private String mDetailAreaMode;
    public boolean mIsFromLive;
    private String mTemplate = "";
    private String mFocusSource = "CPU Activity";
    private String mHeatMapFilterRegex = "";
    private String mAnnotationFilterRegex = "";
    private TIntHashSet mOpenHeatMapRowIds = new TIntHashSet();
    private TIntHashSet mSelectedHeatMapRowIds = new TIntHashSet();
    private boolean mShowAllCAMConnections;
    private boolean mShowBookmarks;
    private boolean mHeatmapAveragePerCore = true;
    private final @NonNull List<@NonNull CAMConfig> mCamConfigs = new ArrayList<CAMConfig>();

    public static final TimelineConfig load(@NonNull File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XMLParser in = XMLParser.create((File)file);){
            String tag;
            while ((tag = in.nextTag()) != null) {
                if (TAG.equals(tag)) {
                    TimelineConfig timelineConfig = new TimelineConfig();
                    timelineConfig.load(in);
                    return timelineConfig;
                }
                in.skip();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throw InvalidVersionException.createReportDirectoryVersionTooOldException();
    }

    private static final String filter(String text) {
        return text == null ? "" : text;
    }

    public final @NonNull ChartAndSeriesConfig addNewChartConfiguration() {
        ChartAndSeriesConfig chart = new ChartAndSeriesConfig();
        this.mCharts.add(chart);
        return chart;
    }

    public final void addNewChartConfiguration(@NonNull ChartAndSeriesConfig chart) {
        this.mCharts.add(chart);
    }

    private CAMConfig addNewCamConfiguration() {
        CAMConfig config = new CAMConfig();
        this.mCamConfigs.add(config);
        return config;
    }

    public final TimelineConfig clone() {
        try {
            TimelineConfig clone = (TimelineConfig)super.clone();
            clone.mCharts = new ArrayList<ChartAndSeriesConfig>();
            clone.mOpenHeatMapRowIds = new TIntHashSet((TIntCollection)this.mOpenHeatMapRowIds);
            clone.mSelectedHeatMapRowIds = new TIntHashSet((TIntCollection)this.mSelectedHeatMapRowIds);
            for (ChartAndSeriesConfig chart : this.mCharts) {
                clone.mCharts.add(chart.clone());
            }
            this.mCamConfigs.forEach(cfg -> {
                boolean bl = timelineConfig.mCamConfigs.add(cfg.clone());
            });
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError();
        }
    }

    public final String getAnnotationFilter() {
        return this.mAnnotationFilterRegex;
    }

    public final long getCalipersLeft() {
        return this.mCalipersLeft;
    }

    public final long getCalipersRight() {
        return this.mCalipersRight;
    }

    public final @NonNull List<@NonNull ChartAndSeriesConfig> getCharts() {
        return this.mCharts;
    }

    public final long getCrossSectionMarkerLeft() {
        return this.mCrossSectionMarkerLeft;
    }

    public final long getCrossSectionMarkerRight() {
        return this.mCrossSectionMarkerRight;
    }

    public final String getDetailAreaMode() {
        return this.mDetailAreaMode;
    }

    public final int getDividerPosition() {
        return this.mDividerPosition;
    }

    public final String getFocusSource() {
        return this.mFocusSource;
    }

    public final int getHandleWidth() {
        return this.mHandleWidth;
    }

    public final String getHeatMapFilter() {
        return this.mHeatMapFilterRegex;
    }

    public final TIntHashSet getOpenHeatMapRowIds() {
        return this.mOpenHeatMapRowIds;
    }

    public final int getScale() {
        return this.mScale;
    }

    public final long getScrollPosition() {
        return this.mScrollPosition;
    }

    public final TIntHashSet getSelectedHeatMapRowIds() {
        return this.mSelectedHeatMapRowIds;
    }

    public final boolean isHeatmapAveragePerCore() {
        return this.mHeatmapAveragePerCore;
    }

    public final void setHeatmapAveragePerCore(boolean average) {
        this.mHeatmapAveragePerCore = average;
    }

    public final String getTemplate() {
        return this.mTemplate;
    }

    public final void save(@NonNull File file, boolean isFromLive) throws IOException {
        this.mIsFromLive = isFromLive;
        Throwable throwable = null;
        Object var4_5 = null;
        try (XMLGenerator xml = XMLGenerator.create((File)file);){
            xml.startDocument();
            this.save(xml);
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public final void setAnnotationFilter(String regex) {
        this.mAnnotationFilterRegex = TimelineConfig.filter(regex);
    }

    public final void setCalipersLeft(long value) {
        this.mCalipersLeft = value;
    }

    public final void setCalipersRight(long value) {
        this.mCalipersRight = value;
    }

    public final void setCrossSectionMarkerLeft(long value) {
        this.mCrossSectionMarkerLeft = value;
    }

    public final void setCrossSectionMarkerRight(long value) {
        this.mCrossSectionMarkerRight = value;
    }

    public final void setDetailAreaMode(String detailAreaMode) {
        this.mDetailAreaMode = detailAreaMode;
    }

    public final void setDividerPosition(int dividerPosition) {
        this.mDividerPosition = dividerPosition;
    }

    public final void setFocusSource(String focusSource) {
        this.mFocusSource = focusSource;
    }

    public final void setHandleWidth(int handleWidth) {
        this.mHandleWidth = handleWidth;
    }

    public final void setHeatMapFilter(String regex) {
        this.mHeatMapFilterRegex = TimelineConfig.filter(regex);
    }

    public final void setScale(int scale) {
        this.mScale = scale;
    }

    public final void setScrollPosition(long scrollPosition) {
        this.mScrollPosition = scrollPosition;
    }

    public final void setShowBookmarks(boolean show) {
        this.mShowBookmarks = show;
    }

    public final void setTemplate(String template) {
        this.mTemplate = TimelineConfig.filter(template);
    }

    public final boolean showBookmarks() {
        return this.mShowBookmarks;
    }

    private void load(XMLParser in) throws IOException {
        String tag;
        String marker = in.getMarker();
        int version = in.getIntegerAttribute(ATTR_VERSION, 0);
        if (version > 10) {
            throw InvalidVersionException.createReportDirectoryVersionTooNewException();
        }
        if (version < 9) {
            throw InvalidVersionException.createReportDirectoryVersionTooOldException();
        }
        this.mHandleWidth = in.getIntegerAttribute(ATTR_HANDLE_WIDTH);
        this.mScale = in.getIntegerAttribute(ATTR_SCALE, 60);
        this.mScrollPosition = in.getLongAttribute(ATTR_SCROLL);
        this.mDividerPosition = in.getIntegerAttribute(ATTR_DIVIDER, -1);
        this.mIsFromLive = in.isAttributeSet(ATTR_IS_FROM_LIVE, false);
        this.mCalipersLeft = in.getLongAttribute(ATTR_CALIPER_LEFT, -1L);
        this.mCalipersRight = in.getLongAttribute(ATTR_CALIPER_RIGHT, -1L);
        this.mCrossSectionMarkerLeft = in.getLongAttribute(ATTR_CSM_LEFT, -1L);
        this.mCrossSectionMarkerRight = in.getLongAttribute(ATTR_CSM_RIGHT, -1L);
        this.mDetailAreaMode = this.mIsFromLive ? null : in.getAttribute(ATTR_DETAIL_AREA_MODE);
        this.mShowBookmarks = in.isAttributeSet(ATTR_SHOW_BOOKMARKS);
        this.mShowAllCAMConnections = in.isAttributeSet(ATTR_SHOW_ALL_CAM_CONNECTIONS);
        this.mFocusSource = in.getAttribute(ATTR_FOCUS_SOURCE, "CPU Activity");
        this.mTemplate = in.getAttribute(ATTR_TEMPLATE, "");
        this.mHeatMapFilterRegex = in.getAttribute(ATTR_HEATMAP_FILTER, "");
        this.mAnnotationFilterRegex = in.getAttribute(ATTR_ANNOTATION_FILTER, "");
        this.mHeatmapAveragePerCore = in.isAttributeSet(ATTR_HEATMAP_SHOW_AVERAGE_PER_CORE, true);
        this.mCharts.clear();
        this.mCamConfigs.clear();
        while ((tag = in.nextTag(marker)) != null) {
            if (TAG_OPEN_HEATMAP_ROW.equals(tag)) {
                this.mOpenHeatMapRowIds.add(in.getIntegerAttribute(ATTR_ID));
                in.skip();
                continue;
            }
            if (TAG_SELECTED_HEATMAP_ROW.equals(tag)) {
                this.mSelectedHeatMapRowIds.add(in.getIntegerAttribute(ATTR_ID));
                in.skip();
                continue;
            }
            if ("chart".equals(tag)) {
                this.mCharts.addAll(ChartAndSeriesXMLParser.load(in, false, Collections.emptyMap()));
                continue;
            }
            if ("cam".equals(tag)) {
                this.addNewCamConfiguration().load(in);
                continue;
            }
            in.skip();
        }
    }

    private final void save(XMLGenerator xml) throws IOException {
        xml.startTag(TAG);
        xml.addAttribute(ATTR_VERSION, 10);
        xml.addAttribute(ATTR_HANDLE_WIDTH, this.mHandleWidth);
        xml.addAttribute(ATTR_SCALE, this.mScale);
        xml.addAttributeNot(ATTR_SCROLL, this.mScrollPosition, 0L);
        xml.addAttributeNot(ATTR_DIVIDER, this.mDividerPosition, -1);
        xml.addAttributeNot(ATTR_IS_FROM_LIVE, this.mIsFromLive, false);
        xml.addAttributeNot(ATTR_CALIPER_LEFT, this.mCalipersLeft, -1L);
        xml.addAttributeNot(ATTR_CALIPER_RIGHT, this.mCalipersRight, -1L);
        xml.addAttributeNot(ATTR_CSM_LEFT, this.mCrossSectionMarkerLeft, -1L);
        xml.addAttributeNot(ATTR_CSM_RIGHT, this.mCrossSectionMarkerRight, -1L);
        if (!this.mIsFromLive) {
            xml.addAttribute(ATTR_DETAIL_AREA_MODE, this.mDetailAreaMode);
        }
        xml.addAttribute(ATTR_SHOW_BOOKMARKS, this.mShowBookmarks);
        xml.addAttribute(ATTR_FOCUS_SOURCE, this.mFocusSource);
        xml.addAttributeNotEmpty(ATTR_TEMPLATE, this.mTemplate);
        xml.addAttributeNotEmpty(ATTR_HEATMAP_FILTER, this.mHeatMapFilterRegex);
        xml.addAttributeNotEmpty(ATTR_ANNOTATION_FILTER, this.mAnnotationFilterRegex);
        xml.addAttributeNot(ATTR_HEATMAP_SHOW_AVERAGE_PER_CORE, this.mHeatmapAveragePerCore, true);
        TIntIterator iterator = this.mOpenHeatMapRowIds.iterator();
        while (iterator.hasNext()) {
            xml.startEmptyTag(TAG_OPEN_HEATMAP_ROW);
            xml.addAttribute(ATTR_ID, iterator.next());
        }
        iterator = this.mSelectedHeatMapRowIds.iterator();
        while (iterator.hasNext()) {
            xml.startEmptyTag(TAG_SELECTED_HEATMAP_ROW);
            xml.addAttribute(ATTR_ID, iterator.next());
        }
        ChartAndSeriesXMLParser.save(xml, this.mCharts);
        for (CAMConfig cfg : this.mCamConfigs) {
            cfg.save(xml);
        }
        xml.endTag();
    }

    public @NonNull CAMConfig findCamConfig(String key) {
        return this.mCamConfigs.stream().filter(cfg -> cfg.getViewId().equals(key)).findFirst().orElse(new CAMConfig(this.mShowAllCAMConnections));
    }

    public void setCamConfigs(@NonNull List<@NonNull CAMConfig> allCamConfigs) {
        this.mCamConfigs.clear();
        this.mCamConfigs.addAll(allCamConfigs);
    }

    public void removeAllChartAndSeriesConfigs() {
        this.mCharts.clear();
    }

    public void addChartAndSeriesConfigs(@NonNull List<@NonNull ChartAndSeriesConfig> chartAndSeriesConfigs) {
        this.mCharts.addAll(chartAndSeriesConfigs);
    }
}

