/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.capture;

import com.arm.streamline.model.capture.AbstractSeriesConfig;
import com.arm.streamline.model.capture.ChartConfig;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.IWildcardSeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;

public class ChartAndSeriesConfig
implements Cloneable {
    private final @NonNull ChartConfig mChart;
    private final @NonNull List<@NonNull AbstractSeriesConfig> mSeries = new ArrayList<AbstractSeriesConfig>();

    public ChartAndSeriesConfig() {
        this.mChart = new ChartConfig();
    }

    public ChartAndSeriesConfig(@NonNull ChartConfig chart) {
        this.mChart = chart;
    }

    public void addSeries(@NonNull AbstractSeriesConfig series) {
        this.mSeries.add(series);
    }

    public void removeSeriesByName(@NonNull String seriesName) {
        this.mSeries.removeIf(series -> series.getName().equals(seriesName));
    }

    public @NonNull ChartAndSeriesConfig clone() {
        ChartAndSeriesConfig chartAndSeries = new ChartAndSeriesConfig(this.mChart.clone());
        for (AbstractSeriesConfig series : this.mSeries) {
            chartAndSeries.mSeries.add(series.clone());
        }
        return chartAndSeries;
    }

    public @NonNull ChartConfig getChart() {
        return this.mChart;
    }

    public @NonNull List<@NonNull SeriesConfig> getAllExpandedSeries(@NonNull ICaptureDataProvider cdp) {
        return Collections.unmodifiableList(this.mSeries.stream().flatMap(m -> m.createSeriesFromSources(cdp).stream()).collect(Collectors.toList()));
    }

    public @NonNull List<@NonNull SeriesConfig> getAllExpandedSeries(@NonNull List<@NonNull String> sources) {
        return Collections.unmodifiableList(this.mSeries.stream().flatMap(m -> m.createSeriesFromSources(sources).stream()).collect(Collectors.toList()));
    }

    public @NonNull List<@NonNull SeriesConfig> getAllExpandedSeriesOnlyForWildCards(@NonNull List<@NonNull String> sources) {
        return Collections.unmodifiableList(this.mSeries.stream().filter(s -> s.isWildcardSeries()).flatMap(m -> m.createSeriesFromSources(sources).stream()).collect(Collectors.toList()));
    }

    public @NonNull List<@NonNull AbstractSeriesConfig> getUnexpandedSeries() {
        return Collections.unmodifiableList(this.mSeries);
    }

    public void load(IChartDataProvider chart) {
        this.mChart.load(chart);
        for (ISeriesDataProvider iSeriesDataProvider : chart.getSeries()) {
            this.mSeries.add(iSeriesDataProvider.getConfig().clone());
        }
        for (IWildcardSeriesDataProvider iWildcardSeriesDataProvider : chart.getWildcardSeries()) {
            this.mSeries.add(iWildcardSeriesDataProvider.getSeriesConfig().clone());
        }
    }

    public boolean matches(@NonNull ChartAndSeriesConfig other) {
        int size;
        if (this.mChart.matches(other.mChart) && (size = this.mSeries.size()) == other.mSeries.size()) {
            int i = 0;
            while (i < size) {
                AbstractSeriesConfig iSeriesConfigTemplate2;
                AbstractSeriesConfig iSeriesConfigTemplate = this.mSeries.get(i);
                if (!iSeriesConfigTemplate.matches(iSeriesConfigTemplate2 = other.mSeries.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void reset() {
        this.mSeries.clear();
    }

    public String toString() {
        return this.mChart.toString();
    }

    public void addAllSeries(@NonNull Collection<? extends @NonNull AbstractSeriesConfig> series) {
        this.mSeries.addAll(series);
    }
}

