/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.bindata;

import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.chart.SeriesComparator;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import gnu.trove.set.TIntSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IBinDataProvider
extends Comparable<IBinDataProvider>,
Runnable {
    public static int compareSeries(IBinDataProvider cThis, IBinDataProvider cThat) {
        return SeriesComparator.compareSeries((int)cThis.getCounterRecord().getOrder(), (String)cThis.getTitleFormat(), (String)cThis.getCounterRecord().getName(), (boolean)cThis.getCounterRecord().getCounterClass().isActivity(), (int)cThat.getCounterRecord().getOrder(), (String)cThat.getTitleFormat(), (String)cThat.getCounterRecord().getName(), (boolean)cThat.getCounterRecord().getCounterClass().isActivity());
    }

    @Override
    default public int compareTo(IBinDataProvider o) {
        return IBinDataProvider.compareSeries(this, o);
    }

    public @NonNull ProcessingElementReference @NonNull [] getChannelDescriptors();

    public @NonNull CounterRecord getCounterRecord();

    default public @NonNull String getExpressionFormat() {
        return this.getCounterRecord().getExpression();
    }

    public long @NonNull [] getLimits();

    public int getRescale(@NonNull ZoomLevel var1);

    default public @NonNull Object getSeriesHash() {
        String counterName;
        @NonNull StringBuilder seriesHash = new StringBuilder();
        @NonNull CounterRecord counterRecord = this.getCounterRecord();
        seriesHash.append(this.getTitleFormat());
        seriesHash.append(counterRecord.isPerCPU() ? "perCPU" : "perCluster");
        if (counterRecord.isAtraceCounter() && (counterName = counterRecord.getCounter()) != null) {
            String[] split = counterName.replace("atrace_dynamic_counter_", "").split("[^a-zA-Z0-9']+");
            seriesHash.append(split[0]);
        }
        return seriesHash.toString();
    }

    default public String getTitleFormat() {
        return this.getCounterRecord().getTitleFormat();
    }

    default public @NonNull String getUniqueSourceName() {
        return this.getCounterRecord().getAlias();
    }

    public long getValue(@NonNull CounterDisplay var1, int var2, long var3, int var5, @Nullable TIntSet var6);

    public boolean isFilterable();

    public int mapChannelNumber(@NonNull ProcessingElementReference var1);

    public void prepareRange(@NonNull ZoomLevel var1, long var2, long var4);

    default public void setBulkDataAccessMode(boolean value) {
    }
}

