/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.annotation;

import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.RGBString;
import com.arm.streamline.model.annotation.VisualAnnotation;
import com.arm.streamline.model.annotation.VisualAnnotationData;
import com.arm.streamline.report.model.uids.AbstractPerVmId;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;

public class VisualAnnotations
implements FileFilter {
    private List<VisualAnnotationData> mAnnotations = new ArrayList<VisualAnnotationData>();
    private Analysis mAnalysis;
    private static final Pattern FILENAME_PATTERN_LEGACY = Pattern.compile("(\\d+)");
    private static final Pattern FILENAME_PATTERN_VMUID = Pattern.compile("(\\d+)-(\\d+)");

    @Override
    public final boolean accept(File pathname) {
        if (!pathname.isDirectory()) {
            return false;
        }
        Matcher matcherVmUID = FILENAME_PATTERN_VMUID.matcher(pathname.getName());
        if (matcherVmUID.matches()) {
            return true;
        }
        Matcher matcherLegacy = FILENAME_PATTERN_LEGACY.matcher(pathname.getName());
        return matcherLegacy.matches();
    }

    public final List<VisualAnnotationData> getCollections() {
        return this.mAnnotations;
    }

    public VisualAnnotationData getVisualAnnotationData(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AbstractPerVmId.PerVmNonUniquePid id) {
        for (VisualAnnotationData data : this.mAnnotations) {
            if (!data.getID().equals((Object)id)) continue;
            return data;
        }
        return null;
    }

    public final void load(Analysis analysis) {
        this.mAnalysis = analysis;
        File path = this.mAnalysis.getReportDirectory();
        Object[] candidates = new File(path, "annotate/visual").listFiles(this);
        if (candidates != null) {
            Arrays.sort(candidates);
            Object[] objectArray = candidates;
            int n = candidates.length;
            int n2 = 0;
            while (n2 < n) {
                Object candidate = objectArray[n2];
                try {
                    this.readXML((File)candidate, path);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    private final void readXML(File file, File reportDir) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (XMLParser in = XMLParser.create((File)new File(file, "annotations.xml"));){
            this.addVisualAnnotaions(VisualAnnotations.parseName(file), reportDir, in, this.mAnalysis);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void addVisualAnnotaions(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AbstractPerVmId.PerVmNonUniquePid perVmNonUniquePid, @NonNull File reportDir, @NonNull XMLParser in, @NonNull Analysis mAnalysis) throws IOException {
        String tag;
        while ((tag = in.nextTag()) != null) {
            if ("visual_annotations".equals(tag)) {
                ArrayList<VisualAnnotation> annotations = new ArrayList<VisualAnnotation>();
                String marker = in.getMarker();
                String xmlTitle = in.getAttribute("title", "");
                while ((tag = in.nextTag(marker)) != null) {
                    long timeIndex;
                    if ("visual_annotation".equals(tag) && (timeIndex = in.getLongAttribute("time_index", -1L)) >= 0L) {
                        int index;
                        String fileName = in.getAttribute("filename", "");
                        String text = null;
                        RGBString vtext = mAnalysis.getMessage(in.getIntegerAttribute("id", -1));
                        if (vtext != null) {
                            text = vtext.getString();
                        }
                        if (text != null && !text.isEmpty() && text.charAt(0) == '\u001b' && (index = text.lastIndexOf(0)) >= 0) {
                            text = text.substring(index + 1);
                        }
                        if (text != null && text.length() == 0) {
                            text = null;
                        }
                        annotations.add(new VisualAnnotation(timeIndex, fileName, text));
                    }
                    in.skip();
                }
                Collections.sort(annotations);
                this.mAnnotations.add(new VisualAnnotationData(reportDir, xmlTitle, annotations, perVmNonUniquePid));
                continue;
            }
            in.skip();
        }
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AbstractPerVmId.PerVmNonUniquePid parseName(File file) throws IOException {
        Matcher matcher = FILENAME_PATTERN_VMUID.matcher(file.getName());
        if (matcher.matches()) {
            return new AbstractPerVmId.PerVmNonUniquePid(Long.parseLong(matcher.group(1)), Integer.parseInt(matcher.group(2)));
        }
        matcher = FILENAME_PATTERN_LEGACY.matcher(file.getName());
        if (matcher.matches()) {
            return new AbstractPerVmId.PerVmNonUniquePid(0L, Integer.parseInt(matcher.group(1)));
        }
        throw new IOException("bad visual annotation file name: " + file.getName());
    }
}

