/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.annotation;

import com.arm.utils.collections.ITimeStampedData;
import com.arm.utils.text.NumericStringComparator;

public class VisualAnnotation
implements ITimeStampedData,
Comparable<VisualAnnotation> {
    private long mTimestamp;
    private String mFilename;
    private String mText;

    public VisualAnnotation(long timestampInNanoseconds, String fileName, String text) {
        this.mTimestamp = timestampInNanoseconds;
        this.mFilename = fileName;
        this.mText = text;
    }

    @Override
    public int compareTo(VisualAnnotation other) {
        if (this.mTimestamp < other.mTimestamp) {
            return -1;
        }
        if (this.mTimestamp > other.mTimestamp) {
            return 1;
        }
        int result = NumericStringComparator.CASELESS_COMPARATOR.compare(this.mText, other.mText);
        if (result == 0) {
            result = NumericStringComparator.CASELESS_COMPARATOR.compare(this.mFilename, other.mFilename);
        }
        return result;
    }

    public final String getFilename() {
        return this.mFilename;
    }

    public final String getText() {
        return this.mText;
    }

    public final long getTimestamp() {
        return this.mTimestamp;
    }
}

