/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.annotation;

import com.arm.streamline.jni.apcdbgen.proto.IUniqueID;
import com.arm.streamline.model.RGBString;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;

public class AnnotationTimesliceData {
    private @NonNull IUniqueID mThread;
    private TIntObjectHashMap<SingleChannel> mChannels;

    public AnnotationTimesliceData(@NonNull IUniqueID thread, int channel, boolean startFrame, boolean endFrame) {
        this.mThread = thread;
        this.mChannels = new TIntObjectHashMap();
        SingleChannel sc = new SingleChannel(startFrame, endFrame);
        this.mChannels.put(channel, (Object)sc);
    }

    public void add(int channel, boolean startFrame, boolean endFrame) {
        SingleChannel sc = new SingleChannel(startFrame, endFrame);
        this.mChannels.put(channel, (Object)sc);
    }

    public void addLabel(int channel, RGBString label) {
        SingleChannel sc = (SingleChannel)this.mChannels.get(channel);
        if (sc != null) {
            sc.mLabels.add(label);
        }
    }

    public int[] getChannels() {
        return this.mChannels.keys();
    }

    public ArrayList<RGBString> getLabels(int channel) {
        if (this.mChannels.get(channel) != null) {
            return ((SingleChannel)this.mChannels.get((int)channel)).mLabels;
        }
        return new ArrayList<RGBString>();
    }

    public RGB getRGB(int channel) {
        SingleChannel sc = (SingleChannel)this.mChannels.get(channel);
        if (sc == null) {
            return RGBString.DEFAULT;
        }
        int count = sc.mLabels.size();
        if (count > 0) {
            RGB rgb = sc.mLabels.get(0).getRGB();
            int i = 1;
            while (i < count) {
                if (!rgb.equals((Object)sc.mLabels.get(i).getRGB())) {
                    return RGBString.DEFAULT;
                }
                ++i;
            }
            return rgb;
        }
        return RGBString.DEFAULT;
    }

    public @NonNull IUniqueID getThread() {
        return this.mThread;
    }

    public boolean hasChannel(int channel) {
        return this.mChannels.contains(channel);
    }

    public boolean isEndFrame(int channel) {
        if (this.mChannels.get(channel) != null) {
            return ((SingleChannel)this.mChannels.get((int)channel)).mEndFrame;
        }
        return false;
    }

    public boolean isStartFrame(int channel) {
        if (this.mChannels.get(channel) != null) {
            return ((SingleChannel)this.mChannels.get((int)channel)).mStartFrame;
        }
        return false;
    }

    public void prepareForMoreLabels(int count) {
        TIntObjectIterator itr = this.mChannels.iterator();
        while (itr.hasNext()) {
            itr.advance();
            SingleChannel sc = (SingleChannel)itr.value();
            sc.mLabels.ensureCapacity(sc.mLabels.size() + count);
        }
    }

    public String toString(int channel) {
        return this.toString(channel, "\n");
    }

    public String toString(int channel, String separator) {
        StringBuilder buffer = new StringBuilder();
        SingleChannel sc = (SingleChannel)this.mChannels.get(channel);
        if (sc == null) {
            return buffer.toString();
        }
        for (RGBString one : sc.mLabels) {
            if (buffer.length() > 0) {
                buffer.append(separator);
            }
            buffer.append(one);
        }
        return buffer.toString();
    }

    private static class SingleChannel {
        public ArrayList<RGBString> mLabels = new ArrayList();
        public boolean mStartFrame;
        public boolean mEndFrame;

        public SingleChannel(boolean startFrame, boolean endFrame) {
            this.mStartFrame = startFrame;
            this.mEndFrame = endFrame;
        }
    }
}

