/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model;

import com.arm.streamline.analysis.database.ApplicationsReader;
import com.arm.streamline.analysis.database.CoresReaderWriter;
import com.arm.streamline.analysis.database.EventsChart;
import com.arm.streamline.analysis.database.ProcessingElementReferenceSetReaderWriter;
import com.arm.streamline.analysis.database.VirtualMachinePropertiesReaderWriter;
import com.arm.streamline.analysis.gator.GatorCapturedRawXML;
import com.arm.streamline.analysis.model.AnnotationDataStructure;
import com.arm.streamline.analysis.model.ChannelDescriptorUtils;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.CaptureSubType;
import com.arm.streamline.common.model.IScaleChangeListener;
import com.arm.streamline.common.model.InvalidVersionException;
import com.arm.streamline.common.model.Position;
import com.arm.streamline.common.model.ProtocolType;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.common.model.warnings.Warnings;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.IProgressProvider;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.databrowser.DocumentsView;
import com.arm.streamline.editortabs.code.PathPrefixSubstitutionDialog;
import com.arm.streamline.jni.apcdbgen.AnalysisOptions;
import com.arm.streamline.jni.apcdbgen.impl.ApcReport;
import com.arm.streamline.jni.apcdbgen.impl.IUniqueIDsHelper;
import com.arm.streamline.jni.apcdbgen.proto.ICAMDataProvider;
import com.arm.streamline.jni.apcdbgen.proto.ICAMReport;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueProcessID;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueThreadID;
import com.arm.streamline.jni.apcdbgen.proto.ImageFile;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import com.arm.streamline.jni.common.CancellationPredicate;
import com.arm.streamline.jni.common.IProgressMonitor;
import com.arm.streamline.jni.common.IProgressMonitorFactory;
import com.arm.streamline.jni.common.WarningItem;
import com.arm.streamline.jni.common.WarningSeverity;
import com.arm.streamline.jni.common.WarningType;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterModel;
import com.arm.streamline.model.AnalysisRecompute;
import com.arm.streamline.model.EventBasedSampleInfo;
import com.arm.streamline.model.Focus;
import com.arm.streamline.model.IAnalysisListener;
import com.arm.streamline.model.IReAnalysisProgressListener;
import com.arm.streamline.model.ISamplesCallback;
import com.arm.streamline.model.LogEntriesFile;
import com.arm.streamline.model.ModelMessages;
import com.arm.streamline.model.RGBString;
import com.arm.streamline.model.StateFile;
import com.arm.streamline.model.annotation.AnnotationCache;
import com.arm.streamline.model.annotation.Annotations;
import com.arm.streamline.model.annotation.ChannelsFile;
import com.arm.streamline.model.annotation.VisualAnnotationData;
import com.arm.streamline.model.annotation.VisualAnnotations;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.bindata.TimelineAllBinData;
import com.arm.streamline.model.capture.Bookmark;
import com.arm.streamline.model.capture.Calipers;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ChartConfig;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.IChartAndSeriesListener;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.IProcessDataProvider;
import com.arm.streamline.model.capture.TimelineConfig;
import com.arm.streamline.model.chart.ChartUtility;
import com.arm.streamline.model.chart.Charts;
import com.arm.streamline.model.chart.SeriesRangeCalculator;
import com.arm.streamline.model.icounters.legacyimpl.InstructionCountersModel;
import com.arm.streamline.model.live.CoreClusterDescription;
import com.arm.streamline.model.process.ITimelineMapProvider;
import com.arm.streamline.model.process.TimelineMap;
import com.arm.streamline.model.templates.TemplateFile;
import com.arm.streamline.model.timeline.TimelineProcessDataProvider;
import com.arm.streamline.report.model.IVirtualMachineBasicProperties;
import com.arm.streamline.report.model.PathSubstitutionsFile;
import com.arm.streamline.report.model.VariableReplacer;
import com.arm.streamline.report.model.pe.ProcessingElementTopology;
import com.arm.streamline.report.model.topology.GatorClusters;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.report.model.topology.ICores;
import com.arm.streamline.report.model.topology.XmlClustersInfo;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.IUniqueLifetimes;
import com.arm.streamline.report.model.uids.NonUniqueId;
import com.arm.streamline.report.model.uids.UniqueProcess;
import com.arm.streamline.report.model.uids.UniqueThread;
import com.arm.streamline.utility.io.ProgressTracker;
import com.arm.streamline.widget.Error;
import com.arm.utils.NullChecking;
import com.arm.utils.OptionalUtils;
import com.arm.utils.StreamUtils;
import com.arm.utils.collections.Pair;
import com.arm.utils.io.FileUtils;
import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.LongFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class Analysis
implements ICaptureDataProvider,
IScaleChangeListener,
AutoCloseable {
    public static final String CHART_CONFIGURATION_XML = "chart_configuration.xml";
    public static final @NonNull String EMPTY = "";
    public static final String PARENT_DIRECTORY = "../";
    public static final String REPORT_DIR = "report";
    public static final String REPORT_DIR_V3 = "report-new";
    private @Nullable Job currentSourcePathSearchJob = null;
    private final @NonNull Object currentSourcePathSearchJobLock = new Object();
    private final @NonNull ProcessingElementReferenceSet mAllProcessingElementReferences;
    private @Nullable AnalysisRecompute mAnalysisMetrics;
    private final TIntObjectHashMap<Annotations> mAnnotations = new TIntObjectHashMap();
    private final @NonNull TimelineAllBinData mBinData;
    private @Nullable List<Bookmark> mBookmarks;
    private final Calipers mCalipers;
    private final @NonNull List<@NonNull ICAMDataProvider> mCAM;
    private final boolean mCanFilterCallStacksDynamically;
    private final ChannelsFile mChannelsFile;
    private @NonNull Charts mCharts;
    private final @NonNull IClustersInfo mClustersInfo;
    private final @NonNull ICores mCoresFile;
    private final CrossSectionMarker mCrossSectionMarker;
    private TimelineConfig mDefaultTimelineConfiguration;
    private long mFilterEndUs;
    private final @NonNull TIntSet mFilterPids = new TIntHashSet(10, 0.5f, -1);
    private long mFilterStartUs;
    private final @NonNull TIntSet mFilterTids = new TIntHashSet(10, 0.5f, -1);
    private final Focus mFocus;
    private final @NonNull AnnotationCache mImages;
    private final @NonNull File mImagesDirectory;
    private final @NonNull IInstructionCounterModel mInstructionCounterModel;
    private final List<IAnalysisListener> mListeners = new ArrayList<IAnalysisListener>();
    private final LogEntriesFile mLogEntriesFile;
    private final int mMaxClusters;
    private final int mMaxCores;
    private final AnnotationCache mMessages;
    private final @NonNull IPropertyChangeListener mPreferencesListener;
    private final @NonNull IPreferenceStore mPreferencesStore;
    private final @NonNull TimelineProcessDataProvider mProcessDataProvider;
    private final List<IReAnalysisProgressListener> mReAnalysisListeners = new ArrayList<IReAnalysisProgressListener>();
    private final @NonNull File mReportDirectory;
    private boolean mReportGenerationActive;
    private final Scales mScales;
    private final SeriesRangeCalculator mSeriesRangeCalculator;
    private @NonNull Set<@NonNull String> mSpeKeys;
    private final @NonNull StateFile mStateFile;
    private @NonNull List<@NonNull TemplateFile> mTemplates;
    private @Nullable TimelineConfig mTimelineConfiguration;
    private boolean mTimelineConfigurationLoadedFromFile = false;
    private final @NonNull TimelineMap mTimelineMap;
    private final @NonNull IUniqueIds mUniqueIdMap;
    private final @NonNull IUniqueLifetimes mUniqueLifetimes;
    private boolean mUseDefaultTemplates = false;
    private boolean mUseTimelineConfiguration = false;
    private final VariableReplacer mVariableReplacer = new VariableReplacer();
    private final VisualAnnotations mVisualAnnotations = new VisualAnnotations();
    private @NonNull IWarnings mWarnings;
    private final @NonNull PathSubstitutionsFile pathSubstitutionsFile;
    private boolean sourcePathSearchListenerCurrentState = false;
    private final @NonNull Set<@NonNull ISourcePathSearchListener> sourcePathSearchListeners = new HashSet<ISourcePathSearchListener>();
    final @NonNull TLongObjectMap<? extends IVirtualMachineBasicProperties> mVmStateMap;

    private static final TimelineConfig load(@NonNull File file) {
        if (CommonFileUtils.exists((File)file)) {
            try {
                return TimelineConfig.load(file);
            }
            catch (InvalidVersionException invalidVersionException) {
            }
            catch (Exception exception) {
                CommonPlugin.info((String)("Error while parsing file : " + file.getPath() + ", \n with message" + exception.getMessage()));
            }
        }
        return null;
    }

    private static @NonNull List<@NonNull ICAMDataProvider> loadNativeCAM(@NonNull ApcReport apcReport, @NonNull IProgressMonitorFactory progressMonitorFactory, @NonNull CancellationPredicate cancellationPredicate) throws Exception {
        ICAMReport camReport = apcReport.getCAMReport();
        if (camReport == null) {
            return Collections.emptyList();
        }
        return camReport.load(cancellationPredicate, progressMonitorFactory);
    }

    private static @Nullable ApcReport openNativeReport(@NonNull ExecutorService executorService, @NonNull CancellationPredicate cancellationPredicate, @NonNull IProgressMonitorFactory progressMonitorFactory, final @NonNull IUniqueIds uniqueIds, @NonNull File reportDirectory, boolean processDebugInfo) throws Exception {
        AnalysisOptions analysisOptions = new AnalysisOptions(false, true, true, true, processDebugInfo, null);
        return ApcReport.openReport((ExecutorService)executorService, (IProgressMonitorFactory)progressMonitorFactory, (CancellationPredicate)cancellationPredicate, (AnalysisOptions)analysisOptions, (File)FileUtils.canonicalise((File)((File)NullChecking.neverNull((Object)reportDirectory.getParentFile()))), (IUniqueIDsHelper)new IUniqueIDsHelper(){

            public @NonNull IUniqueProcessID getProcessByUID(long upid) {
                UniqueProcess result = uniqueIds.findProcess(Math.toIntExact(upid)).orElse(null);
                if (result == null) {
                    throw new IllegalArgumentException("Invalid UPID " + upid);
                }
                return result;
            }

            public @NonNull IUniqueProcessID getProcessForThreadUID(long utid) {
                UniqueThread result = uniqueIds.findThread(Math.toIntExact(utid)).orElse(null);
                if (result == null) {
                    throw new IllegalArgumentException("Invalid UTID " + utid);
                }
                return result.getProcess();
            }

            public @NonNull IUniqueThreadID getThreadByUID(long utid) {
                UniqueThread result = uniqueIds.findThread(Math.toIntExact(utid)).orElse(null);
                if (result == null) {
                    throw new IllegalArgumentException("Invalid UTID " + utid);
                }
                return result;
            }

            public @NonNull Stream<@NonNull IUniqueThreadID> getThreadsByProcessUID(long upid) throws IllegalArgumentException {
                return ((IntStream)NullChecking.neverNull((Object)uniqueIds.getThreadUidsOf(Math.toIntExact(upid)).orElse(IntStream.empty()))).mapToObj(utid -> {
                    IUniqueThreadID result = uniqueIds.findThread(utid).orElse(null);
                    return result;
                }).filter(t -> t != null);
            }
        });
    }

    private static @NonNull Pair<@NonNull TIntSet, @NonNull TIntSet> splitPidsAndTids(@NonNull TIntSet selection, @NonNull IUniqueIds uniqueIdMap) {
        TIntHashSet pids = new TIntHashSet(10, 0.5f, -1);
        TIntHashSet tids = new TIntHashSet(10, 0.5f, -1);
        for (int uid : selection) {
            Optional optProcess;
            Optional optThread = uniqueIdMap.findThread(uid);
            if (optThread.isPresent()) {
                tids.add(uid);
            }
            if (!(optProcess = uniqueIdMap.findProcess(uid)).isPresent()) continue;
            pids.add(uid);
        }
        return new Pair((Object)pids, (Object)tids);
    }

    public Analysis(@NonNull File apcDir, @NonNull CancellationPredicate cancellationPredicate) throws InvocationTargetException, InterruptedException, IOException {
        this(apcDir, (org.eclipse.core.runtime.IProgressMonitor)new NullProgressMonitor(), cancellationPredicate);
    }

    public Analysis(@NonNull File apcDir, @NonNull org.eclipse.core.runtime.IProgressMonitor monitor, @NonNull CancellationPredicate cancellationPredicate) throws InvocationTargetException, InterruptedException, IOException {
        this(apcDir, monitor, cancellationPredicate, true);
    }

    public Analysis(@NonNull File apcDir, @NonNull org.eclipse.core.runtime.IProgressMonitor monitor, @NonNull CancellationPredicate cancellationPredicate, boolean activateView) throws InvocationTargetException, InterruptedException, IOException {
        this(apcDir, monitor, cancellationPredicate, activateView, StreamlinePreferences.getPreferenceStore(), StreamlinePreferences::getEnabledDefaultSourcePaths);
    }

    public Analysis(@NonNull File apcDir, @NonNull org.eclipse.core.runtime.IProgressMonitor monitor, final @NonNull CancellationPredicate cancellationPredicate, boolean activateView, @NonNull IPreferenceStore preferencesStore, final @NonNull Supplier<@NonNull List<@NonNull File>> defaultSearchPathsSupplier) throws InvocationTargetException, InterruptedException, IOException {
        if (!apcDir.getName().toLowerCase().endsWith(".apc")) {
            throw new IllegalArgumentException("Unexpected capture dir: " + String.valueOf(apcDir) + " should be ending in '.apc'");
        }
        this.mCanFilterCallStacksDynamically = true;
        this.mReportDirectory = (File)NullChecking.neverNull((Object)new File(apcDir, REPORT_DIR).getAbsoluteFile());
        this.mImagesDirectory = (File)NullChecking.neverNull((Object)new File(apcDir, "images").getAbsoluteFile());
        this.mAllProcessingElementReferences = ProcessingElementReferenceSetReaderWriter.read((File)new File(this.mReportDirectory, "pe-references.xml"), (boolean)false);
        this.mTemplates = new ArrayList<TemplateFile>();
        this.mSpeKeys = new HashSet<String>();
        try {
            final ProgressTracker tracker = new ProgressTracker(ModelMessages.LOADING_DATA, monitor);
            this.mStateFile = StateFile.load(this.mReportDirectory, tracker);
            if (!this.mStateFile.isVersionValid()) {
                throw new Exception(this.mStateFile.invalidReason());
            }
            this.mCoresFile = CoresReaderWriter.read((File)new File(this.mReportDirectory, "cores.xml"), (ProcessingElementReferenceSet)this.mAllProcessingElementReferences);
            this.mClustersInfo = new XmlClustersInfo(new GatorClusters(this.mReportDirectory), this.mCoresFile);
            this.mChannelsFile = new ChannelsFile(this.mReportDirectory);
            this.mScales = new Scales((IScaleChangeListener)this, Scales.REPORT_DEFAULT_ZOOM_LEVEL, this.mStateFile.getResolution().toZoomLevels());
            this.mVmStateMap = VirtualMachinePropertiesReaderWriter.read((File)new File(this.mReportDirectory, "virtual-machines.xml"));
            this.mWarnings = new Warnings();
            this.mWarnings.load(this.mReportDirectory);
            this.mWarnings.load(new File(apcDir, "/stm_import"));
            this.mBinData = new TimelineAllBinData(this);
            this.tryLoadTimelineConfiguration();
            if (this.mStateFile.getProtocolType() != ProtocolType.BARMAN && this.mStateFile.getProtocolType() != ProtocolType.ASTF) {
                this.loadDataForTemplateMenu();
            }
            this.mSeriesRangeCalculator = new SeriesRangeCalculator(this, this.mBinData, true);
            this.mMessages = new AnnotationCache(this.mReportDirectory, "annotate/map/strings.bin");
            this.mImages = new AnnotationCache(this.mReportDirectory, "annotate/map/images.bin");
            this.mVisualAnnotations.load(this);
            this.pathSubstitutionsFile = new PathSubstitutionsFile(this.mReportDirectory, (IProgressTracker)tracker);
            this.createDefaultConfig();
            this.mCharts = new Charts(this);
            this.mFocus = new Focus(this);
            this.mCrossSectionMarker = new CrossSectionMarker(this);
            this.mCalipers = new Calipers(this);
            this.mVariableReplacer.readXML(this.mReportDirectory);
            final @NonNull IUniqueIds uniqueIds = ApplicationsReader.read((File)new File(this.mReportDirectory.getPath(), "applications.xml"));
            this.mUniqueLifetimes = new IUniqueLifetimes(){

                public OptionalLong getEndTime(int uid) {
                    return OptionalUtils.mapToLong((Optional)uniqueIds.findNonUid(uid), nonUid -> this.getEndTime((NonUniqueId<?>)nonUid));
                }

                public OptionalLong getStartTime(int uid) {
                    return OptionalUtils.mapToLong((Optional)uniqueIds.findNonUid(uid), nonUid -> this.getStartTime((NonUniqueId<?>)nonUid));
                }

                long getEndTime(NonUniqueId<?> nonUid) {
                    @Nullable IVirtualMachineBasicProperties vmProperties = (IVirtualMachineBasicProperties)Analysis.this.mVmStateMap.get(nonUid.getId().vmUID);
                    if (vmProperties == null) {
                        return nonUid.getEndTime();
                    }
                    return Math.max(nonUid.getEndTime(), vmProperties.getVmEndTimestamp() + 1L);
                }

                long getStartTime(NonUniqueId<?> nonUid) {
                    @Nullable IVirtualMachineBasicProperties vmProperties = (IVirtualMachineBasicProperties)Analysis.this.mVmStateMap.get(nonUid.getId().vmUID);
                    if (vmProperties == null) {
                        return nonUid.getStartTime();
                    }
                    return Math.max(nonUid.getStartTime(), vmProperties.getVmStartTimestamp());
                }
            };
            IProgressMonitorFactory progressMonitorFactory = new IProgressMonitorFactory(){

                public @NonNull IProgressMonitor create(@NonNull String name) {
                    return new MonitorAdapter(cancellationPredicate, name, tracker, Analysis.this.mWarnings);
                }
            };
            this.mUniqueIdMap = uniqueIds;
            this.mPreferencesListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("com.arm.streamline.source_search_paths".contentEquals(event.getProperty())) {
                        Analysis.this.startDefaultSourcePathsChangedTask(defaultSearchPathsSupplier);
                    }
                }
            };
            this.mPreferencesStore = preferencesStore;
            this.mPreferencesStore.addPropertyChangeListener(this.mPreferencesListener);
            ApcReport nativeApcReport = Analysis.openNativeReport(Task.getExecutorService(), cancellationPredicate, progressMonitorFactory, uniqueIds, this.mReportDirectory, this.mStateFile.isParseDebugInfoEnabled());
            if (nativeApcReport == null) {
                throw new InterruptedException();
            }
            try {
                this.mCAM = Analysis.loadNativeCAM(nativeApcReport, progressMonitorFactory, cancellationPredicate);
                this.mInstructionCounterModel = InstructionCountersModel.fromNative(nativeApcReport, cancellationPredicate, progressMonitorFactory, uniqueIds, tracker, this.mReportDirectory, this.mVmStateMap, this.pathSubstitutionsFile, this.shouldFilterCallStacks(), this.shouldFilterKernelAddresses(), this.profileGroupingMode(), this.shouldUseInlines());
            }
            catch (Throwable t) {
                try {
                    nativeApcReport.close();
                }
                catch (Throwable t1) {
                    t.addSuppressed(t1);
                }
                throw t;
            }
            this.mInstructionCounterModel.getWarnings().forEach(arg_0 -> ((IWarnings)this.mWarnings).add(arg_0));
            tracker.setSubTaskTitle("Populating default source mappings");
            this.startDefaultSourcePathsChangedTask(defaultSearchPathsSupplier);
            this.mLogEntriesFile = new LogEntriesFile(this, tracker);
            this.mTimelineMap = new TimelineMap(this);
            this.mProcessDataProvider = new TimelineProcessDataProvider(this);
            this.mMaxCores = Math.max(this.mCoresFile.getNumCores(), this.mFocus.getMaxChannels());
            this.mMaxClusters = this.mClustersInfo.getNumberOfClusters();
            if (activateView) {
                DocumentsView.makeVisible();
            }
            tracker.finish();
        }
        catch (InterruptedException ie) {
            try {
                this.closeNoSave();
            }
            catch (Throwable t) {
                ie.addSuppressed(t);
            }
            throw ie;
        }
        catch (Exception exception) {
            try {
                this.closeNoSave();
            }
            catch (Throwable t) {
                exception.addSuppressed(t);
            }
            String invalidMsg = MessageFormat.format(ModelMessages.UNABLE_TO_LOAD, this.mReportDirectory.getAbsolutePath());
            Object message = exception.getMessage();
            if (!invalidMsg.equals(message)) {
                message = message == null ? invalidMsg : invalidMsg + "\n\n" + (String)message;
                exception = new Exception((String)message, exception);
            }
            throw new InvocationTargetException(exception);
        }
    }

    @Override
    public final void addDynamicChartListener(IChartAndSeriesListener listener) {
    }

    public final void addListener(IAnalysisListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    @Override
    public void addListener(@NonNull Runnable listener) {
    }

    @Override
    public @Nullable IChartDataProvider addNewChart(@NonNull ChartAndSeriesConfig configChart) {
        IChartDataProvider result = this.mCharts.addNewChart(configChart);
        this.notifyChartsChanged();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addReAnalysisListener(IReAnalysisProgressListener listener) {
        List<IReAnalysisProgressListener> list = this.mReAnalysisListeners;
        synchronized (list) {
            this.mReAnalysisListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourcePathSearchListener(@NonNull ISourcePathSearchListener listener) {
        Object object = this.currentSourcePathSearchJobLock;
        synchronized (object) {
            if (this.sourcePathSearchListeners.add(listener)) {
                boolean active = this.sourcePathSearchListenerCurrentState;
                Task.callOnUIThread(() -> listener.onSourcePathSearchStateChange(active));
            }
        }
    }

    public void adjustToNewScale(@NonNull ZoomLevel oldZoomLevel, @NonNull ZoomLevel newZoomLevel) {
        this.getCalipers().adjustToNewScale(oldZoomLevel, newZoomLevel);
    }

    public final synchronized void cancelReAnalysis() {
        if (this.mAnalysisMetrics != null) {
            this.mAnalysisMetrics.cancel();
        }
    }

    public boolean canFilterStacksDynamically() {
        return this.mCanFilterCallStacksDynamically;
    }

    @Override
    public void close() throws Exception {
        this.closeNoSave();
        this.mStateFile.save(this.mReportDirectory);
    }

    @Override
    public @NonNull String computeFullPath(@NonNull SourceFile sourceFile) {
        return this.pathSubstitutionsFile.computeUpdatedPath(sourceFile);
    }

    @Override
    public @Nullable TIntHashSet convertToThreadUIDs(@Nullable TIntSet uids) {
        if (uids == null) {
            return null;
        }
        TIntHashSet set = StreamUtils.of((TIntCollection)uids).flatMap(arg_0 -> ((IUniqueIds)this.mUniqueIdMap).toThreadUids(arg_0)).collect(TIntHashSet::new, TIntSet::add, TIntSet::addAll);
        if (set.size() == 0) {
            return null;
        }
        return set;
    }

    @Override
    public final TimelineAllBinData getAllBinData() {
        return this.mBinData;
    }

    public final AnnotationDataStructure getAnnotationDataStructure() {
        return this.mChannelsFile.getAnnotationDataStructure();
    }

    public final synchronized Annotations getAnnotations(@NonNull ZoomLevel zoomLevel) {
        Annotations annotations = (Annotations)this.mAnnotations.get(zoomLevel.getBps());
        if (annotations == null) {
            try {
                annotations = new Annotations(this, zoomLevel);
            }
            catch (Exception exception) {
                annotations = new Annotations();
            }
            this.mAnnotations.put(zoomLevel.getBps(), (Object)annotations);
        }
        return annotations;
    }

    @Override
    public final int getBinCount() {
        return this.getBinCount(this.mScales.getZoomLevel());
    }

    public final int getBinCount(@NonNull ZoomLevel zoomLevel) {
        return this.getLastBin(zoomLevel) + 1;
    }

    @Override
    public final int getBinCountForDensestScale() {
        return this.getBinCount(this.mScales.getDensestZoomLevel());
    }

    @Override
    public final @NonNull List<Bookmark> getBookmarks() {
        if (this.mBookmarks == null) {
            this.mBookmarks = Bookmark.load(this.getBookmarksFile());
        }
        return (List)NullChecking.neverNull(this.mBookmarks);
    }

    @Override
    public final Calipers getCalipers() {
        return this.mCalipers;
    }

    @Override
    public final @NonNull List<@NonNull ICAMDataProvider> getCAMDataProviders() {
        return this.mCAM;
    }

    @Override
    public @NonNull CaptureSubType getCaptureSubType() {
        return this.mStateFile.getCaptureSubType();
    }

    @Override
    public @NonNull List<@NonNull IChartDataProvider> getChartList() {
        return this.mCharts.getCharts();
    }

    public final Charts getCharts() {
        return this.mCharts;
    }

    public int getClusterCount() {
        return this.mMaxClusters;
    }

    public final int getClusterID(int coreID) {
        return this.mClustersInfo.getClusterIndex(coreID);
    }

    public final @Nullable String getClusterNameFromCoreID(int coreID) {
        return this.mCoresFile.getCoreClusterLabel(coreID);
    }

    public final @Nullable String getClusterNameFromProcessingElementReference(@NonNull ProcessingElementReference peReference) {
        int index = this.mCoresFile.getCoreIndex(peReference);
        if (index < 0) {
            return null;
        }
        return this.mCoresFile.getCoreClusterLabel(index);
    }

    @Override
    public final List<ContentProposal> getContentProposals() {
        return this.mBinData.getContentProposals();
    }

    public @Nullable TIntList getCoreIndexes(int clusterIndex) {
        return this.mClustersInfo.getCores(clusterIndex);
    }

    public final int getCoreIndexFromProcessingElementReference(@NonNull ProcessingElementReference peReference) {
        return this.mCoresFile.getCoreIndex(peReference);
    }

    public @NonNull ProcessingElementReference @NonNull [] getCores(@NonNull CounterRecord record) {
        @Nullable Integer clusterId = record.getCluster();
        @NonNull ProcessingElementReference @NonNull [] channels = ChannelDescriptorUtils.makeChannelDescriptors((ProcessingElementReferenceSet)this.mAllProcessingElementReferences, (CounterRecord)record);
        if (clusterId == null) {
            return channels;
        }
        return this.getCores(clusterId);
    }

    public @NonNull ProcessingElementReference @NonNull [] getCores(int clusterIndex) {
        @NonNull TIntList indexes = (TIntList)NullChecking.neverNull((Object)this.getCoreIndexes(clusterIndex));
        @NonNull ProcessingElementReference @NonNull [] result = new ProcessingElementReference[indexes.size()];
        int i = 0;
        while (i < indexes.size()) {
            int cpu = indexes.get(i);
            result[i] = (ProcessingElementReference)NullChecking.neverNullOrCreate((Object)this.mCoresFile.getProcessingElementReference(cpu), () -> this.mAllProcessingElementReferences.get(DeviceType.CPU, 0L, cpu));
            ++i;
        }
        return result;
    }

    public @NonNull ICaptureDataProvider.IFocusedEventSource getCpuChannelsFocusedEventSource() {
        return new CpuFocusedEventSource(this.mClustersInfo, this.mCoresFile, this::getVmName, this.mCoresFile.getProcessingElementReferences());
    }

    @Override
    public final CrossSectionMarker getCrossSectionMarker() {
        return this.mCrossSectionMarker;
    }

    @Override
    public @NonNull TimelineConfig getDefaultTimelineConfiguration() {
        return (TimelineConfig)NullChecking.neverNull((Object)this.mDefaultTimelineConfiguration.clone());
    }

    @Override
    public final EventBasedSampleInfo getEventBasedSampleInfo() {
        return this.mStateFile.getEBSInfo();
    }

    @Override
    public @NonNull ICaptureDataProvider.IFocusedEventSource getFocusedEventSource() {
        @Nullable EventsChart focusedEventChart = this.mFocus.getFocusSourceEventsChart();
        if (focusedEventChart != null) {
            if (focusedEventChart.getDeviceType().isCPU()) {
                return new CpuFocusedEventSource(this.mClustersInfo, this.mCoresFile, this::getVmName, focusedEventChart.getChannelDescriptors());
            }
            return new DeviceEventSource(this.hasMultipleVms(), focusedEventChart.getPerCore(), focusedEventChart.getDeviceType(), this::getVmName, focusedEventChart.getChannelDescriptors());
        }
        return this.getCpuChannelsFocusedEventSource();
    }

    public final synchronized Focus getFocusObject() {
        return this.mFocus;
    }

    @Override
    public String getFocusSource() {
        return this.mFocus.getFocusSource();
    }

    @Override
    public List<String> getFocusSources() {
        return this.mFocus.getFocusSources();
    }

    public final RGBString getImage(int id) throws IOException {
        return this.mImages.get(id);
    }

    public @NonNull IInstructionCounterModel getInstructionCounterModel() {
        return this.mInstructionCounterModel;
    }

    public final int getLastBin(@NonNull ZoomLevel zoomLevel) {
        boolean remainder;
        int binsPerSecond = zoomLevel.getBps();
        long bins = this.mStateFile.getDuration() * (long)binsPerSecond / 1000000000L;
        boolean bl = remainder = this.mStateFile.getDuration() * (long)binsPerSecond % 1000000000L > 0L;
        if (remainder) {
            ++bins;
        }
        return (int)(bins - 1L);
    }

    @Override
    public int getLastBinCount() {
        return this.getBinCount();
    }

    public final LogEntriesFile getLogEntriesFile() {
        return this.mLogEntriesFile;
    }

    @Override
    public @NonNull ITimelineMapProvider getMapProvider() {
        return this.mTimelineMap;
    }

    public RGBString getMessage(int id) throws IOException {
        return this.mMessages.get(id);
    }

    public @NonNull PathSubstitutionsFile getPathSubstitutionsFile() {
        return this.pathSubstitutionsFile;
    }

    @Override
    public final @NonNull IProcessDataProvider getProcessDataProvider() {
        return this.mProcessDataProvider;
    }

    public @NonNull ProcessingElementReferenceSet getProcessingElementsReferenceSet() {
        return this.mAllProcessingElementReferences;
    }

    public final @Nullable ProcessingElementTopology getProcessingElementTopology(@NonNull ProcessingElementReference peReference) {
        int index = this.mCoresFile.getCoreIndex(peReference);
        if (index < 0) {
            return null;
        }
        return this.mCoresFile.getProcessingElementTopology(index);
    }

    @Override
    public @NonNull ProtocolType getProtocolType() {
        return this.mStateFile.getProtocolType();
    }

    public final int getRelativeCoreID(int coreIndex) {
        return this.mCoresFile.getRelativeCoreId(coreIndex);
    }

    public final @NonNull File getReportDirectory() {
        return this.mReportDirectory;
    }

    @Override
    public final Scales getScales() {
        return this.mScales;
    }

    @Override
    public SeriesRangeCalculator getSeriesRangeCalculator() {
        return this.mSeriesRangeCalculator;
    }

    public @NonNull Collection<@NonNull String> getSpeKeys() {
        return Collections.unmodifiableSet(this.mSpeKeys);
    }

    public final StateFile getStateFile() {
        return this.mStateFile;
    }

    public @NonNull List<@NonNull TemplateFile> getTemplates() {
        return Collections.unmodifiableList(this.mTemplates);
    }

    public final @NonNull TimelineConfig getTimelineConfiguration() {
        if (this.mTimelineConfiguration == null) {
            this.mTimelineConfiguration = this.getDefaultTimelineConfiguration();
        }
        return (TimelineConfig)NullChecking.neverNull((Object)this.mTimelineConfiguration);
    }

    @Override
    public @NonNull TimeUnit getTimeUnit() {
        return this.mStateFile.getTimeUnit();
    }

    public @NonNull IUniqueIds getUniqueIdMap() {
        return this.mUniqueIdMap;
    }

    public final @NonNull IUniqueLifetimes getUniqueLifetimes() {
        return this.mUniqueLifetimes;
    }

    public boolean getUseDefaultTemplates() {
        return this.mUseDefaultTemplates;
    }

    @Override
    public VariableReplacer getVariableReplacer() {
        return this.mVariableReplacer;
    }

    public final synchronized VisualAnnotations getVisualAnnotations() {
        return this.mVisualAnnotations;
    }

    public long getVmEndTimeNs(long vmUID) {
        @Nullable IVirtualMachineBasicProperties vmStateData = (IVirtualMachineBasicProperties)this.mVmStateMap.get(vmUID);
        if (vmStateData != null) {
            return vmStateData.getVmEndTimestamp();
        }
        return this.mStateFile.getDuration();
    }

    public final @Nullable String getVmName(long vmUID) {
        if (this.mVmStateMap.size() <= 1) {
            return null;
        }
        @Nullable IVirtualMachineBasicProperties vmStateData = (IVirtualMachineBasicProperties)this.mVmStateMap.get(vmUID);
        if (vmStateData == null) {
            throw new AssertionError(vmUID);
        }
        return (String)NullChecking.neverNullOr((Object)vmStateData.getVmName(), (Object)EMPTY);
    }

    public long getVmStartTimeNs(long vmUID) {
        @Nullable IVirtualMachineBasicProperties vmStateData = (IVirtualMachineBasicProperties)this.mVmStateMap.get(vmUID);
        if (vmStateData != null) {
            return vmStateData.getVmStartTimestamp();
        }
        return 0L;
    }

    @Override
    public final @NonNull IWarnings getWarnings() {
        return this.mWarnings;
    }

    public boolean hasMultipleVms() {
        return this.mVmStateMap.size() > 1;
    }

    @Override
    public boolean isApplicationTracingMode() {
        return this.mStateFile.isApplicationTracingMode();
    }

    public final synchronized boolean isBusy() {
        if (this.mAnalysisMetrics != null) {
            return this.mAnalysisMetrics.isAlive();
        }
        return false;
    }

    @Override
    public final boolean isLive() {
        return false;
    }

    public boolean isReportGenerationActive() {
        return this.mReportGenerationActive;
    }

    public boolean isTimelineConfigurationLoadedFromFile() {
        return this.mTimelineConfigurationLoadedFromFile;
    }

    @Override
    public void notifyChartsChanged() {
        TimelineProcessDataProvider pdp = (TimelineProcessDataProvider)NullChecking.nullable((Object)this.mProcessDataProvider);
        if (pdp != null) {
            pdp.notifyChartsChanged();
        }
    }

    public final void notifyOfSourceFilePathChange() {
        int count = this.mListeners.size();
        if (count > 0) {
            IAnalysisListener[] iAnalysisListenerArray = this.mListeners.toArray(new IAnalysisListener[count]);
            int n = iAnalysisListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnalysisListener listener = iAnalysisListenerArray[n2];
                listener.sourceFilePathChanged();
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyReAnalysisListenersOfCompletion() {
        IReAnalysisProgressListener[] listeners;
        List<IReAnalysisProgressListener> list = this.mReAnalysisListeners;
        synchronized (list) {
            listeners = this.mReAnalysisListeners.toArray(new IReAnalysisProgressListener[this.mReAnalysisListeners.size()]);
        }
        IReAnalysisProgressListener[] iReAnalysisProgressListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IReAnalysisProgressListener listener = iReAnalysisProgressListenerArray[n2];
            listener.reAnalysisFinished();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyRecomputeFromModel() {
        IAnalysisListener[] listeners;
        List<IAnalysisListener> list = this.mListeners;
        synchronized (list) {
            listeners = this.mListeners.toArray(new IAnalysisListener[this.mListeners.size()]);
        }
        IAnalysisListener[] iAnalysisListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IAnalysisListener listener = iAnalysisListenerArray[n2];
            listener.recomputeFromModel();
            ++n2;
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ProfilingLoadOptions.GroupingMode profileGroupingMode() {
        return this.mStateFile.profileGroupingMode();
    }

    public final void rebuildChartsModel() {
        this.mCharts = new Charts(this);
    }

    public final synchronized void reloadFilterRange(@NonNull Supplier<@NonNull Runnable> progressDialogFactory) {
        Calipers calipers = this.mCalipers;
        ZoomLevel zoomLevel = this.mScales.getZoomLevel();
        long startUs = Position.scale((long)calipers.getLeft(), (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_MICROSECOND_ZOOM_LEVEL);
        long endUs = Position.scale((long)calipers.getRight(), (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_MICROSECOND_ZOOM_LEVEL) - 1L;
        AnalysisRecompute metrics = this.getAnalysisRecompute();
        if (metrics != null) {
            this.mFilterStartUs = startUs;
            this.mFilterEndUs = endUs;
            Runnable closeDialog = progressDialogFactory.get();
            metrics.recomputeFilter(new RecomputeFilterProgressMonitorFactory(), startUs, endUs, this.mFilterPids, this.mFilterTids, closeDialog);
        }
    }

    @Override
    public void removeChart(@NonNull IChartDataProvider chart) {
        this.mCharts.getCharts().remove(chart);
        this.notifyChartsChanged();
    }

    @Override
    public final void removeDynamicChartListener(IChartAndSeriesListener listener) {
    }

    public final void removeListener(IAnalysisListener listener) {
        if (this.mListeners != null) {
            this.mListeners.remove(listener);
        }
    }

    @Override
    public void removeListener(@NonNull Runnable listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeReAnalysisListener(IReAnalysisProgressListener listener) {
        List<IReAnalysisProgressListener> list = this.mReAnalysisListeners;
        synchronized (list) {
            this.mReAnalysisListeners.remove(listener);
        }
    }

    @Override
    public final void saveBookmarks() {
        File file = this.getBookmarksFile();
        List<Bookmark> bookmarks = this.getBookmarks();
        if (bookmarks.isEmpty()) {
            file.delete();
        } else {
            Bookmark.save(file, bookmarks);
        }
    }

    public void setFilterCallStacks(boolean v, @NonNull Supplier<@NonNull Runnable> progressDialogFactory) {
        if (this.mStateFile.setFilterCallStacks(v)) {
            this.reloadFilterRange(progressDialogFactory);
        }
    }

    public void setFilterKernelAddresses(boolean v, @NonNull Supplier<@NonNull Runnable> progressDialogFactory) {
        if (this.mStateFile.setFilterKernelAddresses(v)) {
            this.reloadFilterRange(progressDialogFactory);
        }
    }

    @Override
    public final synchronized void setFilterRange(@NonNull ZoomLevel zoomLevel, long from, long to) {
        long startUs = Position.scale((long)from, (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_MICROSECOND_ZOOM_LEVEL);
        long endUs = Position.scale((long)to, (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_MICROSECOND_ZOOM_LEVEL) - 1L;
        if (startUs == this.mFilterStartUs && endUs == this.mFilterEndUs) {
            return;
        }
        AnalysisRecompute metrics = this.getAnalysisRecompute();
        if (metrics != null) {
            this.mFilterStartUs = startUs;
            this.mFilterEndUs = endUs;
            metrics.recomputeFilter(new RecomputeFilterProgressMonitorFactory(), startUs, endUs, this.mFilterPids, this.mFilterTids, () -> {});
        }
    }

    @Override
    public void setFilterThreads(@NonNull TIntSet selection) {
        if (!this.mInstructionCounterModel.canFilterThreadsDynamically()) {
            return;
        }
        Pair<TIntSet, TIntSet> pidsAndTids = Analysis.splitPidsAndTids(selection, this.mUniqueIdMap);
        if (this.mFilterPids.equals(pidsAndTids.first) && this.mFilterTids.equals(pidsAndTids.second)) {
            return;
        }
        AnalysisRecompute metrics = this.getAnalysisRecompute();
        if (metrics != null) {
            Calipers calipers = this.mCalipers;
            ZoomLevel zoomLevel = this.mScales.getZoomLevel();
            long startUs = Position.scale((long)calipers.getLeft(), (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_MICROSECOND_ZOOM_LEVEL);
            long endUs = Position.scale((long)calipers.getRight(), (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_MICROSECOND_ZOOM_LEVEL) - 1L;
            this.mFilterPids.clear();
            this.mFilterPids.addAll((TIntCollection)pidsAndTids.first);
            this.mFilterTids.clear();
            this.mFilterTids.addAll((TIntCollection)pidsAndTids.second);
            this.mFilterStartUs = startUs;
            this.mFilterEndUs = endUs;
            metrics.recomputeFilter(new RecomputeFilterProgressMonitorFactory(), startUs, endUs, this.mFilterPids, this.mFilterTids, () -> {});
        }
    }

    @Override
    public void setFocusSource(String focusSource) {
        this.mFocus.setFocus(focusSource);
    }

    public void setProfileGroupingMode(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ProfilingLoadOptions.GroupingMode v, @NonNull Supplier<@NonNull Runnable> progressDialogFactory) {
        if (this.mStateFile.setProfileGroupingMode(v)) {
            this.reloadFilterRange(progressDialogFactory);
        }
    }

    public void setReportGeneration(boolean isActive) {
        this.mReportGenerationActive = isActive;
    }

    @Override
    public final synchronized void setSamplesRange(@NonNull ZoomLevel zoomLevel, long from, long to, @NonNull IProgressMonitorFactory progressMonitorFactory, @NonNull ISamplesCallback callback) {
        long startUs = Position.scale((long)from, (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_MICROSECOND_ZOOM_LEVEL);
        long endUs = Position.scale((long)to, (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_MICROSECOND_ZOOM_LEVEL) - 1L;
        AnalysisRecompute metrics = this.getAnalysisRecompute();
        if (metrics != null) {
            metrics.recomputeSamples(progressMonitorFactory, startUs, endUs, callback);
        }
    }

    public final void setTimelineConfiguration(TimelineConfig config) {
        this.mTimelineConfiguration = config;
        try {
            config.save(new File(this.mReportDirectory, CHART_CONFIGURATION_XML), false);
        }
        catch (Exception exception) {
            Error.show(exception);
        }
    }

    public final void setUseDefaultTemplates(boolean toggle) {
        this.mUseDefaultTemplates = toggle;
    }

    public void setUseInlines(boolean v, @NonNull Supplier<@NonNull Runnable> progressDialogFactory) {
        if (this.mStateFile.setUseInlines(v)) {
            this.reloadFilterRange(progressDialogFactory);
        }
    }

    public final void setUseTimelineConfiguration(boolean toggle) {
        this.mUseTimelineConfiguration = toggle;
    }

    public boolean shouldFilterCallStacks() {
        return this.mStateFile.shouldFilterCallStacks();
    }

    public boolean shouldFilterKernelAddresses() {
        return this.mStateFile.shouldFilterKernelAddresses();
    }

    public boolean shouldShowProcesses() {
        return this.mInstructionCounterModel.shouldShowProcesses();
    }

    public boolean shouldUseInlines() {
        return this.mStateFile.shouldUseInlines();
    }

    @Override
    public final boolean showClusterMap() {
        return this.mMaxClusters > 1;
    }

    @Override
    public final boolean showCoreMap() {
        return this.mMaxCores > 1;
    }

    @Override
    public void showPathSubstitutionDialog() {
        PathPrefixSubstitutionDialog.show(this);
    }

    public @Nullable File toImageFilePath(@NonNull ImageFile imageFile) {
        File result;
        String containerName = imageFile.containerName;
        if (containerName != null && !containerName.isBlank() && (result = new File(this.mImagesDirectory, containerName)).isFile()) {
            return result;
        }
        result = new File(this.mImagesDirectory, imageFile.imageName);
        return result.isFile() ? result : null;
    }

    public final String toString() {
        String name = ((File)NullChecking.neverNull((Object)this.mReportDirectory.getParentFile())).getName();
        if (name.endsWith(".apc")) {
            name = name.substring(0, name.length() - ".apc".length());
        }
        return name;
    }

    @Override
    public void updateLastBinCount() {
    }

    public boolean useTimelineConfiguration() {
        return this.mUseTimelineConfiguration;
    }

    @Override
    public boolean visualAnnotationsPresent() {
        return this.mVisualAnnotations.getCollections().size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeNoSave() throws Exception {
        try {
            IPreferenceStore mPreferencesStore = (IPreferenceStore)NullChecking.nullable((Object)this.mPreferencesStore);
            IPropertyChangeListener mPreferencesListener = (IPropertyChangeListener)NullChecking.nullable((Object)this.mPreferencesListener);
            if (mPreferencesStore != null && mPreferencesListener != null) {
                mPreferencesStore.removePropertyChangeListener(mPreferencesListener);
            }
        }
        catch (Throwable throwable) {
            Object object = this.currentSourcePathSearchJobLock;
            synchronized (object) {
                try {
                    Job currentSourcePathSearchJob = this.currentSourcePathSearchJob;
                    this.currentSourcePathSearchJob = null;
                    if (currentSourcePathSearchJob != null) {
                        currentSourcePathSearchJob.cancel();
                    }
                }
                finally {
                    IInstructionCounterModel mInstructionCounterModel = (IInstructionCounterModel)NullChecking.nullable((Object)this.mInstructionCounterModel);
                    if (mInstructionCounterModel != null) {
                        mInstructionCounterModel.close();
                    }
                }
            }
            throw throwable;
        }
        Object object = this.currentSourcePathSearchJobLock;
        synchronized (object) {
            try {
                Job currentSourcePathSearchJob = this.currentSourcePathSearchJob;
                this.currentSourcePathSearchJob = null;
                if (currentSourcePathSearchJob != null) {
                    currentSourcePathSearchJob.cancel();
                }
            }
            finally {
                IInstructionCounterModel mInstructionCounterModel = (IInstructionCounterModel)NullChecking.nullable((Object)this.mInstructionCounterModel);
                if (mInstructionCounterModel != null) {
                    mInstructionCounterModel.close();
                }
            }
        }
    }

    private void createDefaultConfig() {
        List<@NonNull IBinDataProvider> providers = this.getAllBinData().getAllSelectedProviders();
        this.mDefaultTimelineConfiguration = ChartUtility.createTimelineConfig(providers);
        List<VisualAnnotationData> list = this.getVisualAnnotations().getCollections();
        for (VisualAnnotationData element : list) {
            ChartConfig chart = this.mDefaultTimelineConfiguration.addNewChartConfiguration().getChart();
            chart.setTitle(element.getTitle());
            chart.setSeriesComposition(SeriesComposition.VISUAL_ANNOTATION);
            chart.setID(element.getID());
        }
    }

    private final AnalysisRecompute getAnalysisRecompute() {
        if (this.mAnalysisMetrics == null) {
            this.mAnalysisMetrics = new AnalysisRecompute(this);
        }
        return this.mAnalysisMetrics;
    }

    private final @NonNull File getBookmarksFile() {
        return new File(this.mReportDirectory, "bookmarks.xml");
    }

    private void loadDataForTemplateMenu() {
        File parentDir = new File(this.mReportDirectory, PARENT_DIRECTORY);
        try {
            GatorCapturedRawXML captured = GatorCapturedRawXML.readFromDir(parentDir);
            this.mTemplates.addAll(captured.getTemplates());
            this.mSpeKeys.addAll(captured.getSpeKeys().valueCollection());
        }
        catch (IOException e) {
            CommonPlugin.warning((String)("Unable to load templates from captured.xml in directory: " + parentDir.getAbsolutePath()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOfSourceFileSearchJob(@NonNull Job job, boolean active) {
        Object object = this.currentSourcePathSearchJobLock;
        synchronized (object) {
            if (this.currentSourcePathSearchJob == job) {
                this.sourcePathSearchListenerCurrentState = active;
                for (ISourcePathSearchListener listener : this.sourcePathSearchListeners) {
                    Task.callOnUIThread(() -> listener.onSourcePathSearchStateChange(active));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDefaultSourcePathsChangedTask(final @NonNull Supplier<@NonNull List<@NonNull File>> defaultSearchPathsSupplier) {
        Job task = new Job("Search for matching source files"){

            protected IStatus run(@NonNull org.eclipse.core.runtime.IProgressMonitor monitor) {
                try {
                    Analysis.this.notifyOfSourceFileSearchJob(this, true);
                    PathSubstitutionsFile pathSubstitutionsFile = (PathSubstitutionsFile)NullChecking.nullable((Object)Analysis.this.pathSubstitutionsFile);
                    IInstructionCounterModel instructionCounterModel = (IInstructionCounterModel)NullChecking.nullable((Object)Analysis.this.mInstructionCounterModel);
                    if (pathSubstitutionsFile == null || instructionCounterModel == null) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    if (!pathSubstitutionsFile.prepopulateFrom(instructionCounterModel.getInstructionCounterSources().stream().flatMap(s -> s.getSymbols().stream()).map(r -> r.getReferencedSymbol()).map(s -> s.symbol.sourceLocation).map(l -> l != null ? l.sourceFile : null).filter(l -> l != null).collect(Collectors.toSet()), (List)defaultSearchPathsSupplier.get(), monitor)) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    Task.callOnUIThread(Analysis.this::notifyOfSourceFilePathChange);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    Analysis.this.notifyOfSourceFileSearchJob(this, false);
                }
            }
        };
        Object object = this.currentSourcePathSearchJobLock;
        synchronized (object) {
            Job currentSourcePathSearchJob = this.currentSourcePathSearchJob;
            this.currentSourcePathSearchJob = task;
            if (currentSourcePathSearchJob != null) {
                currentSourcePathSearchJob.cancel();
            }
            task.setPriority(30);
            task.setUser(true);
            task.schedule();
        }
    }

    private void tryLoadTimelineConfiguration() {
        TimelineConfig timelineConfiguration = Analysis.load(new File(this.mReportDirectory, CHART_CONFIGURATION_XML));
        if (timelineConfiguration == null) {
            timelineConfiguration = Analysis.load(new File(new File(this.mReportDirectory, PARENT_DIRECTORY), CHART_CONFIGURATION_XML));
        }
        if (timelineConfiguration != null && timelineConfiguration.mIsFromLive) {
            List<@NonNull IBinDataProvider> providers = this.getAllBinData().getAllSelectedProviders();
            ChartUtility.addToTimelineConfig(timelineConfiguration, providers.stream().filter(p -> !p.getCounterRecord().isMetric() && !p.getCounterRecord().isAvailableLive()));
        }
        this.mTimelineConfiguration = timelineConfiguration;
        this.mTimelineConfigurationLoadedFromFile = this.mTimelineConfiguration != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRecomputeProgressListeners(@NonNull String title, @Nullable String subTitle, int percent) {
        List<IReAnalysisProgressListener> list = this.mReAnalysisListeners;
        synchronized (list) {
            this.mReAnalysisListeners.forEach(l -> l.progress(title, subTitle, percent));
        }
    }

    private static final class CpuFocusedEventSource
    implements ICaptureDataProvider.IFocusedEventSource {
        private final @NonNull ProcessingElementReference @NonNull [] channelDescriptors;
        private final @NonNull IClustersInfo clustersInfo;
        private final @NonNull ICores coresFile;
        private final @NonNull LongFunction<@Nullable String> vmNameFunction;

        public CpuFocusedEventSource(@NonNull IClustersInfo clustersInfo, @NonNull ICores coresFile, @NonNull LongFunction<@Nullable String> vmNameFunction, @NonNull ProcessingElementReference @NonNull [] channelDescriptors) {
            this.clustersInfo = clustersInfo;
            this.coresFile = coresFile;
            this.vmNameFunction = vmNameFunction;
            this.channelDescriptors = channelDescriptors;
        }

        @Override
        public int getClusterCount() {
            return this.clustersInfo.getNumberOfClusters();
        }

        @Override
        public @NonNull String getClusterDescription(int clusterId) {
            return (String)NullChecking.neverNullOr((Object)this.clustersInfo.getClusterName(clusterId), (Object)Integer.toString(clusterId));
        }

        @Override
        public int getClusterID(int index) {
            int coreIndex = this.getCoreIndex(index);
            return this.clustersInfo.getClusterIndex(coreIndex);
        }

        @Override
        public int getCoreCount() {
            return this.channelDescriptors.length;
        }

        @Override
        public @NonNull String getCoreDescription(int index) {
            int coreIndex = this.getCoreIndex(index);
            @NonNull ProcessingElementReference channelDescriptor = this.channelDescriptors[index];
            return this.getCoreDescription(coreIndex, channelDescriptor);
        }

        @Override
        public @NonNull Collection<@NonNull ICaptureDataProvider.IFocusedEventSourceCore> getCores() {
            @NonNull ArrayList<@NonNull ICaptureDataProvider.IFocusedEventSourceCore> result = new ArrayList<ICaptureDataProvider.IFocusedEventSourceCore>();
            int index = 0;
            while (index < this.channelDescriptors.length) {
                int coreIndex;
                final @NonNull ProcessingElementReference channelDescriptor = this.channelDescriptors[index];
                final int colourIndex = coreIndex = this.getCoreIndex(index);
                @Nullable ProcessingElementTopology topology = this.coresFile.getProcessingElementTopology(coreIndex);
                final @NonNull String numericLabel = topology != null ? Integer.toString(topology.osID) : Long.toString(channelDescriptor.deviceNumber);
                final @NonNull String descriptiveLabel = this.getCoreDescription(coreIndex, channelDescriptor);
                result.add(new ICaptureDataProvider.IFocusedEventSourceCore(){

                    @Override
                    public int getColourIndex() {
                        return colourIndex;
                    }

                    @Override
                    public @NonNull String getDescriptiveLabel() {
                        return descriptiveLabel;
                    }

                    @Override
                    public @NonNull String getNumericLabel() {
                        return numericLabel;
                    }

                    @Override
                    public @NonNull ProcessingElementReference getProcessingElementReference() {
                        return channelDescriptor;
                    }
                });
                ++index;
            }
            return result;
        }

        private @NonNull String getCoreDescription(int coreIndex, @NonNull ProcessingElementReference channelDescriptor) {
            return CoreClusterDescription.generateTooltip(this.vmNameFunction.apply(channelDescriptor.vmUID), this.coresFile.getCoreClusterLabel(coreIndex), channelDescriptor, this.coresFile.getCoreClusterLabel(coreIndex), this.coresFile.getProcessingElementTopology(coreIndex), this.coresFile.getRelativeCoreId(coreIndex));
        }

        private int getCoreIndex(int channelIndex) {
            @NonNull ProcessingElementReference channelDescriptor = this.channelDescriptors[channelIndex];
            int coreIndex = this.coresFile.getCoreIndex(channelDescriptor);
            assert (coreIndex >= 0);
            return coreIndex;
        }
    }

    private static final class DeviceEventSource
    implements ICaptureDataProvider.IFocusedEventSource {
        private final @NonNull ProcessingElementReference @NonNull [] channelDescriptors;
        private final @NonNull DeviceType deviceType;
        private final boolean multipleVms;
        private final @NonNull String name;
        private final boolean perCore;
        private final @NonNull LongFunction<@Nullable String> vmNameFunction;

        public DeviceEventSource(boolean multipleVms, boolean perCore, @NonNull DeviceType deviceType, @NonNull LongFunction<@Nullable String> vmNameFunction, @NonNull ProcessingElementReference @NonNull [] channelDescriptors) {
            assert (!deviceType.isCPU());
            this.multipleVms = multipleVms;
            this.perCore = perCore;
            this.deviceType = deviceType;
            this.vmNameFunction = vmNameFunction;
            this.channelDescriptors = channelDescriptors;
            this.name = !deviceType.isSystemWide() ? deviceType.getName() : Analysis.EMPTY;
        }

        @Override
        public int getClusterCount() {
            return 1;
        }

        @Override
        public @NonNull String getClusterDescription(int clusterId) {
            assert (clusterId == 0);
            return this.name;
        }

        @Override
        public int getClusterID(int index) {
            return 0;
        }

        @Override
        public int getCoreCount() {
            return this.channelDescriptors.length;
        }

        @Override
        public @NonNull String getCoreDescription(int index) {
            @NonNull ProcessingElementReference channelDescriptor = this.channelDescriptors[index];
            return this.getCoreDescription(channelDescriptor);
        }

        @Override
        public @NonNull Collection<@NonNull ICaptureDataProvider.IFocusedEventSourceCore> getCores() {
            @NonNull ArrayList<@NonNull ICaptureDataProvider.IFocusedEventSourceCore> result = new ArrayList<ICaptureDataProvider.IFocusedEventSourceCore>();
            int index = 0;
            while (index < this.channelDescriptors.length) {
                final int colourIndex = index;
                final ProcessingElementReference channelDescriptor = this.channelDescriptors[index];
                final @NonNull String numericLabel = this.getNumericLabel(index, channelDescriptor);
                final @NonNull String descriptiveLabel = this.getCoreDescription(channelDescriptor);
                result.add(new ICaptureDataProvider.IFocusedEventSourceCore(){

                    @Override
                    public int getColourIndex() {
                        return colourIndex;
                    }

                    @Override
                    public @NonNull String getDescriptiveLabel() {
                        return descriptiveLabel;
                    }

                    @Override
                    public @NonNull String getNumericLabel() {
                        return numericLabel;
                    }

                    @Override
                    public @NonNull ProcessingElementReference getProcessingElementReference() {
                        return channelDescriptor;
                    }
                });
                ++index;
            }
            return result;
        }

        private @NonNull String getCoreDescription(@NonNull ProcessingElementReference channelDescriptor) {
            StringBuilder result = new StringBuilder();
            if (this.multipleVms) {
                @NonNull String vmName = (String)NullChecking.neverNull((Object)this.vmNameFunction.apply(channelDescriptor.vmUID));
                result.append("[").append(channelDescriptor.vmUID).append(": ").append(vmName).append("]");
            }
            if (!this.deviceType.isSystemWide()) {
                if (this.multipleVms) {
                    result.append(' ');
                }
                result.append(this.name);
            }
            if (this.perCore) {
                if (this.multipleVms || !this.deviceType.isSystemWide()) {
                    result.append(" - ");
                }
                result.append('#').append(channelDescriptor.deviceNumber);
            }
            return result.toString();
        }

        private @NonNull String getNumericLabel(int index, @NonNull ProcessingElementReference channelDescriptor) {
            if (this.multipleVms && this.perCore) {
                return Integer.toString(index);
            }
            if (this.perCore) {
                return Long.toString(channelDescriptor.deviceNumber);
            }
            if (this.multipleVms) {
                return Long.toString(channelDescriptor.vmUID);
            }
            return Analysis.EMPTY;
        }
    }

    @FunctionalInterface
    public static interface ISourcePathSearchListener {
        public void onSourcePathSearchStateChange(boolean var1);
    }

    public static final class MonitorAdapter
    implements IProgressMonitor,
    IProgressProvider {
        private final @NonNull CancellationPredicate cancellationPredicate;
        private int percent;
        private final @NonNull String title;
        private @Nullable IProgressTracker tracker;
        private final @NonNull IWarnings warningsConsumer;

        public MonitorAdapter(@NonNull CancellationPredicate cancellationPredicate, @NonNull String title, @NonNull IProgressTracker tracker, @NonNull IWarnings warningsConsumer) {
            this.tracker = tracker;
            this.cancellationPredicate = cancellationPredicate;
            this.warningsConsumer = warningsConsumer;
            this.title = title;
            tracker.setTaskTitle(title);
            tracker.setProgressProvider((IProgressProvider)this);
        }

        public void done() {
            IProgressTracker tracker = this.tracker;
            if (tracker != null) {
                this.tracker = null;
                tracker.setProgressProvider(null);
            }
        }

        public long getCurrentProgress() {
            return this.percent;
        }

        public long getTotalLength() {
            return 100L;
        }

        public void updateLabel(@NonNull String label) {
            IProgressTracker tracker = this.tracker;
            if (tracker != null) {
                tracker.setSubTaskTitle(label);
            }
        }

        public void updatePercent(int percent) {
            this.percent = percent;
            IProgressTracker tracker = this.tracker;
            if (tracker != null) {
                try {
                    tracker.update();
                }
                catch (InterruptedException e) {
                    this.cancellationPredicate.cancel();
                }
            }
        }

        public void warning(@NonNull String warning) {
            this.warningsConsumer.add(new WarningItem(WarningType.SESSION_PROCESSOR, WarningSeverity.MEDIUM, this.title, warning));
        }
    }

    private final class RecomputeFilterProgressMonitorFactory
    implements IProgressMonitorFactory {
        private RecomputeFilterProgressMonitorFactory() {
        }

        public @NonNull IProgressMonitor create(final @NonNull String label) {
            return new IProgressMonitor(){
                private int percent;
                private @Nullable String subLabel;

                public void done() {
                }

                public void updateLabel(@NonNull String subLabel) {
                    this.subLabel = subLabel;
                    Analysis.this.updateRecomputeProgressListeners(label, subLabel, this.percent);
                }

                public void updatePercent(int percent) {
                    this.percent = percent;
                    Analysis.this.updateRecomputeProgressListeners(label, this.subLabel, percent);
                }

                public void warning(@NonNull String warning) {
                }
            };
        }
    }
}

