/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.warnings;

import com.arm.streamline.common.utility.Task;
import com.arm.streamline.editortabs.warnings.WarningBadge;
import com.arm.streamline.editortabs.warnings.WarningsGroupPanel;
import com.arm.streamline.hacks.ControlHacks;
import com.arm.streamline.jni.common.WarningItem;
import com.arm.streamline.jni.common.WarningType;
import com.arm.streamline.widget.Colors;
import com.arm.utils.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class WarningsPopup
implements Listener,
Runnable {
    public static final Color BORDER = Colors.create(67, 102, 156);
    private static final int MAX_HEIGHT = 500;
    private static final int MARGIN = 1;
    private WarningBadge mOwner;
    private Shell mShell;
    private Shell mOwningShell;
    private ScrolledComposite mScroller;
    private Composite mContent;
    private boolean mWaitingForInitialParentDeactivate = true;

    public WarningsPopup(WarningBadge owner) {
        this.mOwner = owner;
        this.mOwningShell = owner.getShell();
        this.mShell = new Shell(this.mOwningShell, Platform.isLinux() ? 8 : 16392);
        ControlHacks.setBackground((Control)this.mShell, BORDER);
        this.mOwningShell.addListener(27, (Listener)this);
        this.mShell.addListener(27, (Listener)this);
        this.mShell.addDisposeListener((DisposeListener)this.mOwner);
        this.mShell.addDisposeListener(event -> {
            if (!this.mOwningShell.isDisposed()) {
                this.mOwningShell.removeListener(27, (Listener)this);
            }
        });
        GridLayoutFactory.fillDefaults().extendedMargins(1, 1, 1, 1).applyTo((Composite)this.mShell);
        this.mContent = this.createContent((Composite)this.mShell);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mContent);
        Point size = this.mShell.computeSize(-1, -1, true);
        if (size.y > 500) {
            this.mContent.dispose();
            this.mScroller = new ScrolledComposite((Composite)this.mShell, 0x20000200);
            this.mScroller.setAlwaysShowScrollBars(true);
            ControlHacks.setBackground((Control)this.mScroller, Colors.getWhite());
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mScroller);
            this.mContent = this.createContent((Composite)this.mScroller);
            this.mScroller.setContent((Control)this.mContent);
            size = this.mContent.computeSize(-1, -1, true);
            this.mContent.setSize(size);
            size.x += 2;
            if (this.mScroller.getScrollbarsMode() != 2) {
                size.x += this.mScroller.getVerticalBar().getSize().x;
            }
            size.y = 500;
        }
        this.mShell.setSize(size);
    }

    public final void handleEvent(Event event) {
        if (event.type == 27) {
            if (this.mWaitingForInitialParentDeactivate && event.widget == this.mOwningShell) {
                this.mWaitingForInitialParentDeactivate = false;
            } else {
                Task.callOnUIThread((Runnable)this);
            }
        }
    }

    public void open() {
        Point where = this.mOwner.toDisplay(this.mOwner.getLocation());
        this.mShell.setLocation(where.x, where.y + this.mOwner.getSize().y - 1);
        this.mShell.open();
    }

    @Override
    public final void run() {
        if (this.mShell != null && !this.mShell.isDisposed()) {
            this.mShell.dispose();
        }
    }

    private Composite createContent(Composite parent) {
        Composite content = new Composite(parent, 0x20000000);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(content);
        HashMap<WarningType, ArrayList<WarningItem>> map = new HashMap<WarningType, ArrayList<WarningItem>>();
        for (WarningItem item : this.mOwner.getWarnings()) {
            ArrayList<WarningItem> list = (ArrayList<WarningItem>)map.get(item.getType());
            if (list == null) {
                list = new ArrayList<WarningItem>();
                map.put(item.getType(), list);
            }
            list.add(item);
        }
        WarningType[] warningTypeArray = WarningType.values();
        int n = warningTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            WarningType type = warningTypeArray[n2];
            List list = (List)map.get(type);
            if (list != null) {
                WarningsGroupPanel group = new WarningsGroupPanel(content, type);
                GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)group);
                for (WarningItem item : list) {
                    group.addWarning(item);
                }
            }
            ++n2;
        }
        return content;
    }
}

