/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.ruler;

import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.utility.text.TextDrawingState;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.Fonts;
import org.eclipse.jdt.annotation.NonNull;

class TimeLabel {
    private String mText;
    private long mIndex;
    private long mX;
    private int mWidth;
    private boolean mOdd;

    public TimeLabel(GC gc, long index, long x, @NonNull ZoomLevel zoomLevel, @NonNull TimeUnit unit) {
        this.mIndex = index;
        this.mText = unit.formatBin(index, zoomLevel, TimeUnit.Style.SYMBOL_UNIT, false);
        gc.setFont(Fonts.getSmall());
        TextDrawingState state = new TextDrawingState(gc);
        this.mWidth = gc.stringExtent((String)this.mText).x;
        state.restore();
        this.mX = x;
        this.mOdd = this.mIndex % 20L != 0L;
    }

    public final void draw(GC gc, int y) {
        gc.setFont(Fonts.getSmall());
        gc.setForeground(Colors.getWidgetForeground());
        TextDrawing.drawString(gc, this.mText, (int)this.getTextLeft(), y);
    }

    public final long getIndex() {
        return this.mIndex;
    }

    public final long getTextLeft() {
        return this.mX - (long)(this.mWidth / 2);
    }

    public final long getTextRight() {
        return this.getTextLeft() + (long)this.mWidth;
    }

    public final long getX() {
        return this.mX;
    }

    public final boolean isOdd() {
        return this.mOdd;
    }
}

