/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.heatmap;

import com.arm.streamline.application.StreamlineTheme;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.GraphBlock;
import com.arm.streamline.editortabs.timeline.common.heatmap.HeatMapHandlePanel;
import com.arm.streamline.editortabs.timeline.common.heatmap.HeatMapMessages;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueProcessID;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueThreadID;
import com.arm.streamline.model.capture.Calipers;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.process.HeatmapDataCompute;
import com.arm.streamline.model.process.ITimelineMapProvider;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.streamline.model.process.ThreadAnnotation;
import com.arm.streamline.model.process.TimelineMapMode;
import com.arm.streamline.utility.RGBUtils;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.Fonts;
import com.arm.utils.NullChecking;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class HeatMapPanel
extends GraphBlock {
    private static final @NonNull RGB ARM_BLUE = new RGB(12, 161, 194);
    private static final @NonNull Color AGGREGATE_COLOR = Colors.create(44, 64, 84);
    private static final @NonNull Color CONTENTION_COLOR = Colors.create(60, 150, 251);
    private static final @NonNull Color IO_COLOR = Colors.getRed();
    private static final @NonNull Color EVENT_COLOR = Colors.getGreen();
    private static final @NonNull Color DEBUG_COLOR = Colors.getDarkYellow();
    private static final @NonNull Color EXITED_COLOR = Colors.getGray();
    private static final @NonNull Color VM_COLOR = Colors.create(47, 112, 47);
    private static final @NonNull Color DEFAULT_DORMANT_DARK_COLOR = Colors.create(43, 43, 43);
    private HeatMapHandlePanel mHandlePanel;
    private @NonNull Color mDormantColor;

    private static final void addName(String name, StringBuilder buffer) {
        if (buffer.length() > 0) {
            buffer.append('\n');
        }
        if (name.trim().isEmpty()) {
            buffer.append(HeatMapMessages.NO_TITLE);
        } else {
            buffer.append(name);
        }
    }

    private static final void drawBlocks(GC gc, Color color, int left, int x, int y, int height) {
        gc.setBackground(color);
        int width = x - left;
        gc.fillRectangle(left, y, width, height);
    }

    public HeatMapPanel(HeatMapHandlePanel handlePanel) {
        super(handlePanel.getContent());
        this.mHandlePanel = handlePanel;
        this.mDormantColor = DEFAULT_DORMANT_DARK_COLOR;
    }

    @Override
    protected void mouseSlotWasUpdated() {
    }

    @Override
    protected final void paintSelf(GC gc) {
        super.paintSelf(gc);
        this.updateThemeColors();
        this.drawBackgroundWithVerticalGroupingMarkers(gc, false);
        this.drawBars(gc);
        this.drawCaliperEnds(gc);
        this.drawBookmarks(gc);
        this.drawCrossSectionMarker(gc);
        this.updatePositionReadout();
    }

    @Override
    protected final void updateMouseSlot(Point where) {
        super.updateMouseSlot(where);
        String text = null;
        ITimelineRowProvider row = this.mHandlePanel.getRow();
        switch (row.getRowType()) {
            case PROCESS: 
            case THREAD: {
                text = this.getToolTipForProcessBars(row);
                break;
            }
            case GROUP: 
            case ANNOTATION: {
                text = this.getToolTipForAnnotations(row);
                break;
            }
            case CPU: {
                text = this.getToolTipForCPU(row);
                break;
            }
            case VMUID: {
                break;
            }
        }
        this.setToolTip(text);
    }

    @Override
    protected final void updateThemeColors() {
        super.updateThemeColors();
        switch (StreamlinePreferences.getTheme()) {
            default: {
                this.mDormantColor = Colors.create(43, 43, 43);
                break;
            }
            case LIGHT: {
                this.mDormantColor = Colors.create(212, 212, 212);
            }
        }
    }

    private final void drawAnnotation(GC gc, ITimelineRowProvider row) {
        int firstX;
        BaseTimelineContent content = this.mHandlePanel.getContent();
        ICaptureDataProvider cdp = content.getCaptureDataProvider();
        Pattern pattern = content.getAnnotationFilterPattern();
        Calipers calipers = cdp.getCalipers();
        long calipersLeft = calipers.getLeft();
        long calipersRight = calipers.getRight();
        Rectangle bounds = this.getLocalBounds();
        long first = this.getFirstVisibleSlot();
        long last = this.getLastVisibleSlot();
        int x = firstX = (int)this.translateFromSlot(first);
        int y = bounds.y + 2;
        int height = bounds.height - 5;
        gc.setForeground(this.getThemeBorder());
        String title = null;
        gc.setFont(Fonts.getSmall());
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        StreamlineTheme theme = StreamlinePreferences.getTheme();
        List<ThreadAnnotation> annotationData = row.getAnnotationData((int)first, (int)last);
        int count = annotationData.size();
        int slotWidth = content.getSlotWidth();
        int i = 0;
        while (i < count) {
            ThreadAnnotation annotation = annotationData.get(i);
            if (annotation != null) {
                boolean filtered;
                long startIndex = first + (long)i;
                int left = x;
                int width = slotWidth;
                while (i < count - 1) {
                    ThreadAnnotation next = annotationData.get(i + 1);
                    if (next == null) break;
                    ++i;
                    width += slotWidth;
                    if (next.isStartFrame() || next.isEndFrame()) break;
                }
                x += width - slotWidth;
                long endIndex = first + (long)i;
                RGB color = annotation.getColor();
                boolean bl = filtered = pattern != null && !pattern.matcher(annotation.getDescription()).find();
                if (filtered || startIndex >= calipersRight || endIndex < calipersLeft) {
                    color = theme.desaturate(color);
                }
                gc.setBackground(Colors.create(color));
                gc.fillRectangle(left, y, width, height);
                gc.drawRectangle(left, y, width, height - 1);
                if (!filtered) {
                    int titleRight;
                    title = annotation.getDescription();
                    int titleLeft = left;
                    if (titleLeft < bounds.x) {
                        titleLeft = bounds.x;
                    }
                    if ((titleRight = left + width) > bounds.x + bounds.width) {
                        titleRight = bounds.x + bounds.width;
                    }
                    int titleWidth = (titleRight -= 2) - (titleLeft += 2);
                    gc.setForeground(RGBUtils.isDark(color) ? Colors.getWhite() : Colors.getBlack());
                    if (title.length() > 2) {
                        if (titleWidth < slotWidth) {
                            title = ".";
                        } else if (titleWidth < slotWidth * 2) {
                            title = "\u2026";
                        }
                    }
                    TextDrawing.drawString(gc, title, titleLeft, y, titleWidth, height, 0x1000000, 0x1000000);
                    gc.setForeground(this.getThemeBorder());
                }
            }
            x += slotWidth;
            ++i;
        }
        gc.setAntialias(savedAA);
    }

    private final void drawBars(GC gc) {
        ITimelineRowProvider row = this.mHandlePanel.getRow();
        switch (row.getRowType()) {
            case CPU: {
                this.drawCPUBars(gc, row);
                this.drawVerticalMarkers(gc);
                break;
            }
            case PROCESS: 
            case THREAD: {
                this.drawProcessBars(gc, row);
                this.drawVerticalMarkers(gc);
                break;
            }
            case GROUP: 
            case ANNOTATION: {
                this.drawVerticalMarkers(gc);
                this.drawAnnotation(gc, row);
                break;
            }
            case VMUID: {
                this.drawVmBar(gc, row);
                break;
            }
        }
    }

    private void drawVmBar(GC gc, ITimelineRowProvider row) {
        ICaptureDataProvider cdp = this.mHandlePanel.getContent().getCaptureDataProvider();
        Scales scales = cdp.getScales();
        ZoomLevel zoomLevel = scales.getZoomLevel();
        Color color = VM_COLOR;
        gc.setForeground(color);
        gc.setBackground(color);
        Rectangle bounds = this.getLocalBounds();
        long firstVisible = this.getFirstVisibleSlot();
        long lastVisible = this.getLastVisibleSlot();
        long firstActive = zoomLevel.convertNanosecondsToBin(row.getVmStartTimeNs());
        long lastActive = zoomLevel.convertNanosecondsToBin(row.getVmEndTimeNs());
        long first = Math.max(firstVisible, firstActive);
        long last = Math.min(lastVisible, lastActive);
        int firstX = (int)this.translateFromSlot(first);
        int lastX = (int)(this.translateFromSlot(last) + (long)this.getSlotWidth());
        int y = bounds.y + 2;
        int width = lastX - firstX + 1;
        int height = bounds.height - 5;
        int lineWidth = 3;
        int lineHeight = 3;
        int lineY = y + height / 2 - 1;
        if (firstActive >= firstVisible) {
            gc.fillRectangle(firstX, y, 3, height);
        }
        if (lastActive <= lastVisible) {
            gc.fillRectangle(firstX + width - 3, y, 3, height);
        }
        gc.fillRectangle(firstX, lineY, width, 3);
    }

    private final void drawCPUBars(GC gc, ITimelineRowProvider row) {
        ICaptureDataProvider cdp = this.mHandlePanel.getContent().getCaptureDataProvider();
        ITimelineMapProvider mapProvider = cdp.getMapProvider();
        Scales scales = cdp.getScales();
        ZoomLevel zoomLevel = scales.getZoomLevel();
        Calipers calipers = cdp.getCalipers();
        long calipersLeft = calipers.getLeft();
        long calipersRight = calipers.getRight();
        Rectangle bounds = this.getLocalBounds();
        long firstVisible = this.getFirstVisibleSlot();
        long lastVisible = this.getLastVisibleSlot();
        long firstActive = zoomLevel.convertNanosecondsToBin(row.getVmStartTimeNs());
        long lastActive = zoomLevel.convertNanosecondsToBin(row.getVmEndTimeNs());
        long first = Math.max(firstVisible, firstActive);
        long last = Math.min(lastVisible, lastActive);
        HeatmapDataCompute.PerCoreData mapData = row.getCpuMapData((int)first, (int)last);
        int firstX = (int)this.translateFromSlot(first);
        int y = bounds.y - 1;
        int height = bounds.height;
        StreamlineTheme theme = StreamlinePreferences.getTheme();
        gc.setForeground(this.getThemeBorder());
        int x = firstX;
        int left = 0;
        Color lastColor = null;
        int slotWidth = this.getSlotWidth();
        long i = first;
        while (i <= last) {
            long index = i - first;
            if (index >= 0L && index < (long)mapData.percentage.length) {
                IUniqueProcessID process = mapData.bestUPID[(int)index];
                IUniqueThreadID thread = mapData.bestUTID[(int)index];
                int percent = mapData.percentage[(int)index];
                if (percent > 0) {
                    assert (process != null);
                    assert (thread != null);
                    Color color = Colors.getCoreColor(thread.getOriginalID());
                    boolean processMatches = mapProvider.isFilterMatch(process);
                    boolean threadMatches = mapProvider.isFilterMatch(thread);
                    if (!processMatches && !threadMatches) {
                        color = theme.lowlight(color);
                    } else if (threadMatches && !processMatches) {
                        color = theme.highlight(color);
                    }
                    if (i < calipersLeft || i >= calipersRight) {
                        color = theme.desaturate(color);
                    }
                    if (lastColor == null) {
                        lastColor = color;
                        left = x;
                    } else if (!lastColor.equals((Object)color)) {
                        HeatMapPanel.drawBlocks(gc, lastColor, left, x, y, height);
                        lastColor = color;
                        left = x;
                    }
                } else if (lastColor != null) {
                    HeatMapPanel.drawBlocks(gc, lastColor, left, x, y, height);
                    lastColor = null;
                }
            } else if (lastColor != null) {
                HeatMapPanel.drawBlocks(gc, lastColor, left, x, y, height);
                lastColor = null;
            }
            x += slotWidth;
            ++i;
        }
        if (lastColor != null) {
            HeatMapPanel.drawBlocks(gc, lastColor, left, x, y, height);
        }
    }

    private final void drawProcessBars(GC gc, ITimelineRowProvider row) {
        long index;
        ICaptureDataProvider cdp = this.mHandlePanel.getContent().getCaptureDataProvider();
        boolean averagePerCore = this.mHandlePanel.getContent().isHeatmapAveragePerCore();
        Scales scales = cdp.getScales();
        ZoomLevel zoomLevel = scales.getZoomLevel();
        Calipers calipers = cdp.getCalipers();
        long calipersLeft = calipers.getLeft();
        long calipersRight = calipers.getRight();
        Rectangle bounds = this.getLocalBounds();
        long firstVisible = this.getFirstVisibleSlot();
        long lastVisible = this.getLastVisibleSlot();
        long firstActive = zoomLevel.convertNanosecondsToBin(row.getVmStartTimeNs());
        long lastActive = zoomLevel.convertNanosecondsToBin(row.getVmEndTimeNs());
        long first = Math.max(firstVisible, firstActive);
        long last = Math.min(lastVisible, lastActive);
        int[] mapData = row.getMapData((int)first, (int)last, averagePerCore || row.isAlwaysDrawBarsAsAverageColour());
        int firstX = (int)this.translateFromSlot(first);
        int y = bounds.y - 1;
        int height = bounds.height;
        boolean isIdle = row.isIdle();
        boolean hasNonAnnotationChildren = row.getChildren().stream().filter(c -> {
            switch (c.getRowType()) {
                case GROUP: 
                case ANNOTATION: 
                case CPU: {
                    return false;
                }
                case PROCESS: 
                case THREAD: 
                case VMUID: {
                    return true;
                }
            }
            throw new AssertionError((Object)c.getRowType());
        }).findAny().isPresent();
        TimelineMapMode mode = cdp.getMapProvider().getMode();
        StreamlineTheme theme = StreamlinePreferences.getTheme();
        gc.setForeground(this.getThemeBorder());
        int x = firstX;
        int left = 0;
        Color lastColor = null;
        int slotWidth = this.getSlotWidth();
        long i = first;
        while (i <= last) {
            index = i - first;
            if (index >= 0L && index < (long)mapData.length) {
                int value = mapData[(int)index];
                if (value != -1) {
                    Color color = this.getColor(isIdle, hasNonAnnotationChildren, mode, value);
                    if (i < calipersLeft || i >= calipersRight) {
                        color = theme.desaturate(color);
                    }
                    if (lastColor == null) {
                        lastColor = color;
                        left = x;
                    } else if (!lastColor.equals((Object)color)) {
                        HeatMapPanel.drawBlocks(gc, lastColor, left, x, y, height);
                        lastColor = color;
                        left = x;
                    }
                } else if (lastColor != null) {
                    HeatMapPanel.drawBlocks(gc, lastColor, left, x, y, height);
                    lastColor = null;
                }
            } else if (lastColor != null) {
                HeatMapPanel.drawBlocks(gc, lastColor, left, x, y, height);
                lastColor = null;
            }
            x += slotWidth;
            ++i;
        }
        if (lastColor != null) {
            HeatMapPanel.drawBlocks(gc, lastColor, left, x, y, height);
        }
        if (!isIdle) {
            x = firstX;
            i = first;
            while (i <= last) {
                Color color;
                index = i - first;
                if (index >= 0L && index < (long)mapData.length && (color = HeatMapPanel.mapStateToColour(mapData[(int)index])) != null) {
                    if (i < calipersLeft || i >= calipersRight) {
                        color = theme.desaturate(color);
                    }
                    gc.setBackground(color);
                    gc.fillRectangle(x + 1, y + height / 2 - 1, slotWidth - 2, 3);
                }
                x += slotWidth;
                ++i;
            }
        }
    }

    private static @Nullable Color mapStateToColour(int state) {
        switch (state) {
            case -1: {
                return null;
            }
            case -2: {
                return null;
            }
            case -3: {
                return CONTENTION_COLOR;
            }
            case -4: {
                return IO_COLOR;
            }
            case -5: {
                return EVENT_COLOR;
            }
            case -6: {
                return DEBUG_COLOR;
            }
            case -7: {
                return EXITED_COLOR;
            }
        }
        return null;
    }

    private @NonNull Color getColor(boolean isIdle, boolean hasNonAnnotationChildren, TimelineMapMode mode, int value) {
        switch (mode) {
            default: {
                if (value < 1) {
                    return this.mDormantColor;
                }
                if (isIdle) {
                    return Colors.darken(ARM_BLUE, (int)(50.0 - (double)(50 * value) / 10000.0));
                }
                if (hasNonAnnotationChildren && this.mHandlePanel.isOpen()) {
                    return AGGREGATE_COLOR;
                }
                return Colors.heat((double)value / 100.0);
            }
            case CORE_MAP: {
                if (value < 0) {
                    return this.mDormantColor;
                }
                if (hasNonAnnotationChildren && this.mHandlePanel.isOpen()) {
                    return AGGREGATE_COLOR;
                }
                return Colors.getCoreColor(value);
            }
            case CLUSTER_MAP: 
        }
        if (value < 0) {
            return this.mDormantColor;
        }
        if (hasNonAnnotationChildren && this.mHandlePanel.isOpen()) {
            return AGGREGATE_COLOR;
        }
        return Colors.getClusterColor(value);
    }

    private final String getToolTipForAnnotations(ITimelineRowProvider row) {
        List<String> list = row.getAnnotationList((int)this.getLastMouseSlot());
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        int count = list.size();
        if (count <= 6) {
            for (String one : list) {
                HeatMapPanel.addName(one, buffer);
            }
        } else {
            int i = 0;
            while (i < 5) {
                HeatMapPanel.addName(list.get(i), buffer);
                ++i;
            }
            buffer.append('\n');
            buffer.append(String.format(HeatMapMessages.MORE, count - 5));
        }
        return buffer.toString();
    }

    private final String getToolTipForCPU(ITimelineRowProvider row) {
        long first = this.getFirstVisibleSlot();
        long last = this.getLastVisibleSlot();
        HeatmapDataCompute.PerCoreData mapData = row.getCpuMapData((int)first, (int)last);
        long index = this.getLastMouseSlot() - first;
        if (index >= 0L && index < (long)mapData.percentage.length) {
            IUniqueProcessID process = mapData.bestUPID[(int)index];
            IUniqueThreadID thread = mapData.bestUTID[(int)index];
            int percent = mapData.percentage[(int)index];
            if (percent > 0) {
                assert (process != null);
                assert (thread != null);
                String percentStr = NumberUtils.formatPercentage((double)((double)percent / 100.0), (boolean)false);
                String processName = (String)NullChecking.neverNullOr((Object)process.getName(), (Object)"");
                String threadName = (String)NullChecking.neverNullOr((Object)thread.getName(), (Object)"");
                String nameToUse = threadName.isBlank() ? (processName.isBlank() ? "Unknown" : processName) : threadName;
                return String.format("%s (%d:%d) - %s", nameToUse, process.getOriginalID(), thread.getOriginalID(), percentStr);
            }
        }
        return null;
    }

    private final String getToolTipForProcessBars(ITimelineRowProvider row) {
        boolean averagePerCore = this.mHandlePanel.getContent().isHeatmapAveragePerCore();
        long first = this.getFirstVisibleSlot();
        long last = this.getLastVisibleSlot();
        int[] mapData = row.getMapData((int)first, (int)last, averagePerCore);
        long index = this.getLastMouseSlot() - first;
        if (index >= 0L && index < (long)mapData.length) {
            int value = mapData[(int)index];
            boolean notIdle = !row.isIdle();
            switch (value) {
                case -1: {
                    break;
                }
                case -2: {
                    if (!notIdle) break;
                    return HeatMapMessages.DORMANT;
                }
                case -3: {
                    if (!notIdle) break;
                    return HeatMapMessages.WAIT_CONTENTION;
                }
                case -4: {
                    if (!notIdle) break;
                    return HeatMapMessages.WAIT_IO;
                }
                case -5: {
                    if (!notIdle) break;
                    return HeatMapMessages.WAIT_EVENT;
                }
                case -6: {
                    if (!notIdle) break;
                    return HeatMapMessages.WAIT_DEBUG;
                }
                case -7: {
                    if (!notIdle) break;
                    return HeatMapMessages.EXITED;
                }
                default: {
                    ICaptureDataProvider cdp = this.mHandlePanel.getContent().getCaptureDataProvider();
                    @NonNull ICaptureDataProvider.IFocusedEventSource fes = cdp.getFocusedEventSource();
                    switch (cdp.getMapProvider().getMode()) {
                        case HEAT_MAP: {
                            return NumberUtils.formatPercentage((double)((double)value / 100.0), (boolean)false);
                        }
                        case CORE_MAP: {
                            return fes.getCoreDescription(value);
                        }
                        case CLUSTER_MAP: {
                            return fes.getClusterDescription(value);
                        }
                    }
                }
            }
        }
        return null;
    }
}

