/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.charts;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.editortabs.timeline.common.charts.ChartConfigurationPanel;
import com.arm.streamline.editortabs.timeline.common.charts.ChartHandlePanel;
import com.arm.streamline.editortabs.timeline.common.charts.ChartMessages;
import com.arm.streamline.editortabs.timeline.common.charts.ConfigurationPanelUtility;
import com.arm.streamline.editortabs.timeline.common.charts.ExpandedSeriesConfigurationPanel;
import com.arm.streamline.editortabs.timeline.common.charts.ISeriesConfigurationPanel;
import com.arm.streamline.editortabs.timeline.common.charts.WildcardSeriesConfigUtility;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.model.capture.AbstractSeriesConfig;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.IWildcardSeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.model.capture.SeriesConfigUtility;
import com.arm.streamline.model.capture.WildcardSeriesConfig;
import com.arm.streamline.model.timeline.VariableContentProposalProvider;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockCheckBox;
import com.arm.streamline.widget.lightweight.BlockImageButton;
import com.arm.streamline.widget.lightweight.BlockLabel;
import com.arm.streamline.widget.lightweight.BlockPopupMenu;
import com.arm.streamline.widget.lightweight.BlockScrollBar;
import com.arm.streamline.widget.lightweight.BlockTextField;
import com.arm.streamline.widget.lightweight.PrecisionLayout;
import com.arm.streamline.widget.lightweight.PrecisionLayoutData;
import com.arm.streamline.widget.lightweight.ScrollingBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class WildcardSeriesConfigurationPanel
extends Block
implements ISeriesConfigurationPanel {
    private static final int GAP = 10;
    private @NonNull List<@NonNull ExpandedSeriesConfigurationPanel> expandedSeriesConfigPanels = new CopyOnWriteArrayList<ExpandedSeriesConfigurationPanel>();
    private @NonNull ChartConfigurationPanel mConfigPanel;
    private final @NonNull IWildcardSeriesDataProvider wildCardSeriesDataProvider;
    private BlockTextField mNameField;
    private BlockCheckBox autoRotate;
    private BlockTextField matchWithField;
    private BlockPopupMenu mDisplayTypePopup;
    private boolean mAutoScrollPending;
    private @NonNull Block expandedSeriesWrapper;
    private final @NonNull AtomicReference<DisclosureButtonState> showHideDisclosureToggleState = new AtomicReference<DisclosureButtonState>(DisclosureButtonState.NOTHING);
    private @NonNull WildcardSeriesConfig wildCardSeriesConfig;
    private @Nullable BlockImageButton buttonShowHideExpanded;

    public WildcardSeriesConfigurationPanel(@NonNull ChartConfigurationPanel configPanel, @NonNull IWildcardSeriesDataProvider wildCardSeriesDataProvider) {
        this.mConfigPanel = configPanel;
        this.wildCardSeriesDataProvider = wildCardSeriesDataProvider;
        this.wildCardSeriesConfig = wildCardSeriesDataProvider.getSeriesConfig();
        this.setBackgroundColor(Colors.getWidgetBackground());
        this.setLayout(new PrecisionLayout().setMargins(6, 30, 0, 0).setColumns(7).setSpacing(4, 2));
        this.createFirstRow();
        this.createSecondRow();
        this.updateDisplayTypeFieldBackground();
        this.expandedSeriesWrapper = new Block();
        this.expandedSeriesWrapper.setLayoutData(new PrecisionLayoutData().setHorizontalSpan(5).setHorizontalAlignment(4).setGrabHorizontalSpace(true));
        this.expandedSeriesWrapper.setLayout(new PrecisionLayout().setColumns(1).setSpacing(4, 1));
        if (this.showHideDisclosureToggleState.get() == DisclosureButtonState.SHOW) {
            this.add(this.expandedSeriesWrapper);
        }
    }

    private void createFirstRow() {
        this.buttonShowHideExpanded = WildcardSeriesConfigurationPanel.createDisclosureButton(this.showHideDisclosureToggleState);
        this.buttonShowHideExpanded.addClickListener(button -> this.toggleExpandedStates());
        this.add(this.buttonShowHideExpanded);
        BlockLabel label = new BlockLabel(ChartMessages.SERIES_TITLE);
        label.setToolTip(ChartMessages.WILDCARD_SERIES_NAME_TOOLTIP);
        this.add(label);
        this.mNameField = ConfigurationPanelUtility.addField(this, this.wildCardSeriesConfig.getName(), 125, field -> {
            @NonNull String text = field.getText();
            this.getSeriesConfig().setName(text);
            this.expandedSeriesConfigPanels.forEach(p -> {
                @NonNull String updateNameforExpandedSeries = WildcardSeriesConfigUtility.getUpdatedNameforExpandedSeries(p.getSeries().getConfig(), this.wildCardSeriesConfig);
                if (updateNameforExpandedSeries != null) {
                    p.getSeries().getConfig().setName(updateNameforExpandedSeries);
                    p.setSeriesName(updateNameforExpandedSeries);
                }
            });
            this.mConfigPanel.getChartHandlePanel().repaint();
        });
        label = new BlockLabel(ChartMessages.SERIES_DESCRIPTION_TITLE);
        this.add(label);
        ConfigurationPanelUtility.addField(this, this.wildCardSeriesConfig.getDescriptionFormat(), 0, field -> {
            this.getSeriesConfig().setDescriptionFormat(field.getText());
            this.expandedSeriesConfigPanels.forEach(p -> p.getSeries().getConfig().setDescriptionFormat(field.getText()));
        });
        BlockImageButton deleteButton = new BlockImageButton(StreamlinePlugin.getImage("Discard.png"));
        deleteButton.setToolTip(ChartMessages.REMOVE_SERIES_TITLE);
        deleteButton.addClickListener(button -> {
            boolean remove = ConfigurationPanelUtility.confirmRemoveSeriesDialog(this);
            if (remove) {
                this.removeSeries();
            }
        });
        this.add(deleteButton);
    }

    private void toggleExpandedStates() {
        switch (this.showHideDisclosureToggleState.get()) {
            case NOTHING: {
                return;
            }
            case HIDE: {
                this.showHideDisclosureToggleState.set(DisclosureButtonState.SHOW);
                break;
            }
            case SHOW: {
                this.showHideDisclosureToggleState.set(DisclosureButtonState.HIDE);
                break;
            }
        }
        int height = 0;
        if (this.showHideDisclosureToggleState.get() == DisclosureButtonState.SHOW) {
            this.add(this.expandedSeriesWrapper);
            height = this.expandedSeriesWrapper.getHeight();
        } else {
            this.remove(this.expandedSeriesWrapper);
            this.expandedSeriesWrapper.removeFromParent();
            height = -this.expandedSeriesWrapper.getHeight();
        }
        this.mConfigPanel.getChartHandlePanel().seriesCountChanged(height);
    }

    private void createSecondRow() {
        Block wrapper = new Block();
        wrapper.setLayoutData(new PrecisionLayoutData().setHorizontalSpan(6).setHorizontalAlignment(4).setGrabHorizontalSpace(true));
        wrapper.setLayout(new PrecisionLayout().setColumns(6).setSpacing(4, 2));
        this.add(wrapper);
        BlockLabel label = new BlockLabel(ChartMessages.SERIES_MATCH_WITH);
        label.setLayoutData(new PrecisionLayoutData().setLeftMargin(9).setHorizontalAlignment(131072).setGrabHorizontalSpace(false));
        label.setToolTip(ChartMessages.WILDCARD_SERIES_PATTERN_TOOLTIP);
        wrapper.add(label);
        this.matchWithField = ConfigurationPanelUtility.addField(wrapper, this.wildCardSeriesConfig.getMatchWith(), 0, field -> {
            String pattern = field.getText();
            this.wildCardSeriesConfig.setMatchWith(pattern);
            this.handleExpandedPanelsOnMatchChange(this.mConfigPanel.getChartHandlePanel().getCaptureDataProvider(), this.expandedSeriesConfigPanels, expandedSeries -> this.removeExpandedSeries((ExpandedSeriesConfigurationPanel)expandedSeries), seriesConf -> {
                ISeriesDataProvider seriesDataProvider = this.mConfigPanel.getChartHandlePanel().getChart().createSeries((SeriesConfig)seriesConf);
                this.mConfigPanel.createAndAddExpandedSeries(seriesDataProvider, this);
            }, expSeriesPanel -> {
                String updateNameforExpandedSeries = WildcardSeriesConfigUtility.getUpdatedNameforExpandedSeries(expSeriesPanel.getSeries().getConfig(), this.wildCardSeriesConfig);
                if (updateNameforExpandedSeries != null) {
                    expSeriesPanel.getSeries().getConfig().setName(updateNameforExpandedSeries);
                    expSeriesPanel.setSeriesName(updateNameforExpandedSeries);
                }
            });
            this.mConfigPanel.getChartHandlePanel().clearSharedLimit();
            this.mConfigPanel.getChartHandlePanel().adjustForSeriesExpressionChange();
        });
        this.matchWithField.setProposalProvider(new VariableContentProposalProvider(this.mConfigPanel.getChartHandlePanel().getCaptureDataProvider()));
        this.mDisplayTypePopup = new BlockPopupMenu();
        CounterDisplay[] counterDisplayArray = CounterDisplay.values();
        int n = counterDisplayArray.length;
        int n2 = 0;
        while (n2 < n) {
            CounterDisplay one = counterDisplayArray[n2];
            this.mDisplayTypePopup.addMenuItem(one.getPresentationName(), one);
            ++n2;
        }
        this.mDisplayTypePopup.selectItemWithData(this.wildCardSeriesConfig.getDisplay());
        this.mDisplayTypePopup.addPopupMenuItemSelectionListener((popupMenu, itemIndex, data) -> {
            this.getSeriesConfig().setDisplay((CounterDisplay)data);
            this.expandedSeriesConfigPanels.forEach(p -> p.getSeries().getConfig().setDisplay((CounterDisplay)data));
            this.updateDisplayTypeFieldBackground();
            this.mConfigPanel.getChartHandlePanel().clearSharedLimit();
            this.mConfigPanel.getChartHandlePanel().repaint();
        });
        wrapper.add(this.mDisplayTypePopup);
        wrapper.add(new BlockLabel(ChartMessages.SERIES_UNIT));
        ConfigurationPanelUtility.addField(wrapper, this.wildCardSeriesConfig.getUnits(), 30, field -> {
            this.getSeriesConfig().setUnits(field.getText());
            this.expandedSeriesConfigPanels.forEach(p -> p.getSeries().getConfig().setUnits(field.getText()));
            this.mConfigPanel.getChartHandlePanel().repaint();
        });
        this.autoRotate = new BlockCheckBox(ChartMessages.AUTO_ROTATE, ChartMessages.AUTO_ROTATE_COLOR_TOOLTIP);
        this.autoRotate.setChecked(this.wildCardSeriesConfig.isAutoRotateColor());
        this.autoRotate.addCheckBoxListener(checkbox -> {
            this.wildCardSeriesConfig.setAutoRotateColor(this.autoRotate.isChecked());
            this.handleExpandedPanelsOnColorChange(this.expandedSeriesConfigPanels, this.autoRotate.isChecked());
        });
        wrapper.add(this.autoRotate);
    }

    private static @NonNull BlockImageButton createDisclosureButton(final @NonNull AtomicReference<DisclosureButtonState> showHideDisclosureToggleState) {
        BlockImageButton showHideExpanded = new BlockImageButton(StreamlinePlugin.getImage(StreamlineImages.DISCLOSURE_DOWN)){

            @Override
            protected void paintSelf(GC gc) {
                int savedAA = gc.getAntialias();
                gc.setAntialias(0);
                Rectangle bounds = this.getLocalBounds();
                Image buttonImage = null;
                switch ((DisclosureButtonState)((Object)showHideDisclosureToggleState.get())) {
                    case HIDE: {
                        buttonImage = StreamlinePlugin.getImage(StreamlineImages.DISCLOSURE_UP);
                        this.setToolTip(ChartMessages.WILDCARD_DISCLOSURE_CLOSE_TOOLTIP);
                        break;
                    }
                    case SHOW: {
                        buttonImage = StreamlinePlugin.getImage(StreamlineImages.DISCLOSURE_DOWN);
                        this.setToolTip(ChartMessages.WILDCARD_DISCLOSURE_OPEN_TOOLTIP);
                        break;
                    }
                    case NOTHING: {
                        buttonImage = StreamlinePlugin.getDisabledImage(StreamlineImages.DISCLOSURE_UP);
                        this.setToolTip(ChartMessages.WILDCARD_DISCLOSURE_NOTHING_EXPANDED_TOOLTIP);
                        break;
                    }
                }
                if (buttonImage != null) {
                    Rectangle imageBounds = buttonImage.getBounds();
                    int x = bounds.x + (bounds.width - imageBounds.width) / 2;
                    gc.drawImage(buttonImage, x, bounds.y + (bounds.height - imageBounds.height) / 2);
                }
                gc.setAntialias(savedAA);
            }
        };
        return showHideExpanded;
    }

    @Override
    public final ChartConfigurationPanel getConfigPanel() {
        return this.mConfigPanel;
    }

    public final void selectAndFocusNameField() {
        this.mNameField.selectAll();
        this.getOwner().setFocus(this.mNameField);
    }

    @Override
    protected final void mouseDown(Point where, int button, int stateMask, int count) {
        if (button == 1) {
            this.isOverDragGrip(where);
        }
    }

    @Override
    protected final void mouseDrag(Point where, int button, int stateMask) {
    }

    @Override
    protected final void mouseMove(Point where, int stateMask) {
        this.mConfigPanel.getChartHandlePanel().getChartsPanel().getBaseTimelineContent().setBookmarkPopOver(null);
        this.adjustCursor(where);
    }

    @Override
    protected final void mouseUp(Point where, int button, int stateMask, int count) {
        this.adjustCursor(where);
    }

    @Override
    protected final void paintSelf(GC gc) {
        super.paintSelf(gc);
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        Rectangle bounds = this.getLocalBounds();
        gc.setForeground(Colors.getDivider());
        gc.drawLine(bounds.x, bounds.y, bounds.x + bounds.width - 1, bounds.y);
        gc.setAntialias(savedAA);
        ConfigurationPanelUtility.drawDragGrip(gc, this);
    }

    private final void adjustCursor(Point where) {
        if (this.isOverDragGrip(where)) {
            this.setCursor(StreamlinePlugin.getOpenHandCursor());
        } else {
            this.setCursor(null);
        }
    }

    private final void autoScroll(int amount) {
        BlockScrollBar scrollbar;
        int y;
        this.mAutoScrollPending = false;
        ScrollingBlock scroller = this.getContainingScrollingBlock();
        if (scroller != null && ConfigurationPanelUtility.getScrollAmount(this, scroller, y = this.fromDisplay((Point)this.getDisplay().getCursorLocation()).y) != 0 && (scrollbar = scroller.getVerticalBar()) != null) {
            scrollbar.setValue(scrollbar.getValue() + (long)amount);
        }
    }

    public final @NonNull AbstractSeriesConfig getSeriesConfig() {
        return this.wildCardSeriesConfig;
    }

    private final boolean isOverDragGrip(Point where) {
        return ConfigurationPanelUtility.getDragGripBounds(this).contains(where);
    }

    private final void updateDisplayTypeFieldBackground() {
        Object displayTypeColor = null;
        boolean anyMatch = this.expandedSeriesConfigPanels.stream().anyMatch(panel -> panel.getSeries().getWarningSource() == ISeriesDataProvider.WarningSource.COUNTER_DISPLAY);
        this.mDisplayTypePopup.setBackgroundColor((Color)(anyMatch ? ConfigurationPanelUtility.INVALID_BACKGROUND : displayTypeColor));
    }

    @Override
    public void removeSeries() {
        int height = this.getHeight();
        ChartHandlePanel chartHandlePanel = this.mConfigPanel.getChartHandlePanel();
        this.expandedSeriesConfigPanels.forEach(panel -> WildcardSeriesConfigurationPanel.removeSeriesAndConfigPanel(chartHandlePanel, panel));
        this.expandedSeriesConfigPanels.clear();
        this.removeFromParent();
        chartHandlePanel.getChart().remove(this.wildCardSeriesDataProvider);
        chartHandlePanel.seriesCountChanged(-height);
    }

    private static void removeSeriesAndConfigPanel(@NonNull ChartHandlePanel chartHandlePanel, @NonNull ExpandedSeriesConfigurationPanel panel) {
        ISeriesDataProvider series = panel.getSeries();
        if (series != null) {
            chartHandlePanel.getChart().remove(series);
        }
        panel.removeFromParent();
    }

    public void removeExpandedSeries(@NonNull ExpandedSeriesConfigurationPanel panel) {
        ChartHandlePanel chartHandlePanel = this.mConfigPanel.getChartHandlePanel();
        int height = this.getHeight();
        WildcardSeriesConfigurationPanel.removeSeriesAndConfigPanel(chartHandlePanel, panel);
        this.expandedSeriesConfigPanels.remove(panel);
        this.updateDisplayTypeFieldBackground();
        chartHandlePanel.seriesCountChanged(-height);
        if (this.expandedSeriesConfigPanels.isEmpty()) {
            this.showHideDisclosureToggleState.set(DisclosureButtonState.NOTHING);
        }
    }

    @Override
    public void setupAutoScroll(int y) {
        int amount;
        ScrollingBlock scroller;
        if (!this.mAutoScrollPending && (scroller = this.getContainingScrollingBlock()) != null && (amount = ConfigurationPanelUtility.getScrollAmount(this, scroller, y)) != 0) {
            this.mAutoScrollPending = true;
            int scroll = amount;
            Task.scheduleOnUIThread(() -> this.autoScroll(scroll), null, (long)150L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    public void addExpandedSeries(@NonNull ExpandedSeriesConfigurationPanel panel) {
        this.expandedSeriesWrapper.add(panel);
        this.expandedSeriesConfigPanels.add(panel);
        this.updateDisplayTypeFieldBackground();
        if (!this.expandedSeriesConfigPanels.isEmpty() && this.showHideDisclosureToggleState.get() == DisclosureButtonState.NOTHING) {
            this.showHideDisclosureToggleState.set(DisclosureButtonState.SHOW);
            this.toggleExpandedStates();
        }
        ChartHandlePanel chartHandlePanel = this.mConfigPanel.getChartHandlePanel();
        chartHandlePanel.seriesCountChanged(panel.getHeight());
    }

    @Override
    public @Nullable ISeriesDataProvider getSeries() {
        return null;
    }

    private void handleExpandedPanelsOnMatchChange(@NonNull ICaptureDataProvider captureDataProvider, @NonNull List<@NonNull ExpandedSeriesConfigurationPanel> expandedSeriesConfigPanels, @NonNull Consumer<@NonNull ExpandedSeriesConfigurationPanel> consumerToRemoveExpandedSeries, @NonNull Consumer<@NonNull SeriesConfig> consumerToaddExpandedSeries, @NonNull Consumer<@NonNull ExpandedSeriesConfigurationPanel> consumerToUpdateExpandedSeriesName) {
        List<SeriesConfig> seriesFromSources = this.wildCardSeriesConfig.createSeriesFromSources(captureDataProvider);
        @NonNull ArrayList<@NonNull ExpandedSeriesConfigurationPanel> toBeremoved = new ArrayList<ExpandedSeriesConfigurationPanel>();
        for (ExpandedSeriesConfigurationPanel panel2 : expandedSeriesConfigPanels) {
            SeriesConfig config = panel2.mSeries.getConfig();
            if (config.isWildcardSeries() || seriesFromSources.contains(config)) continue;
            toBeremoved.add(panel2);
        }
        toBeremoved.forEach(panel -> consumerToRemoveExpandedSeries.accept((ExpandedSeriesConfigurationPanel)panel));
        expandedSeriesConfigPanels.stream().filter(p -> {
            SeriesConfig config = p.getSeries().getConfig();
            return config.isExpandedSeries() ? seriesFromSources.contains(config) : false;
        }).forEach(panel -> consumerToUpdateExpandedSeriesName.accept((ExpandedSeriesConfigurationPanel)panel));
        seriesFromSources.stream().filter(c -> !expandedSeriesConfigPanels.stream().anyMatch(p -> p.getSeries().getConfig().equals(c))).forEach(series -> consumerToaddExpandedSeries.accept((SeriesConfig)series));
    }

    private void handleExpandedPanelsOnColorChange(@NonNull List<@NonNull ExpandedSeriesConfigurationPanel> expandedSeriesConfigPanels, boolean isAutoRotate) {
        if (isAutoRotate) {
            if (expandedSeriesConfigPanels.size() > 1) {
                AtomicInteger colorCount = new AtomicInteger(0);
                expandedSeriesConfigPanels.stream().forEach(c -> c.updateColorOnSeries(SeriesConfigUtility.getNextColor(colorCount.incrementAndGet()), false));
            }
        } else {
            List<String> colorList = this.wildCardSeriesConfig.getColorList();
            if (!colorList.isEmpty()) {
                IntStream.range(0, expandedSeriesConfigPanels.size()).forEach(i -> ((ExpandedSeriesConfigurationPanel)expandedSeriesConfigPanels.get(i)).updateColorOnSeries(SeriesConfigUtility.getNextColorFromColorList(colorList, i), false));
            } else {
                expandedSeriesConfigPanels.stream().forEach(c -> c.updateColorOnSeries(this.wildCardSeriesConfig.getColor(), false));
            }
        }
    }

    public static enum DisclosureButtonState {
        SHOW,
        HIDE,
        NOTHING;

    }
}

