/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.charts;

import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.editortabs.timeline.common.charts.ChartMessages;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockTextField;
import com.arm.streamline.widget.lightweight.PrecisionLayoutData;
import com.arm.streamline.widget.lightweight.ScrollingBlock;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;

public class ConfigurationPanelUtility {
    public static final int DRAG_HANDLE_WIDTH = 20;
    public static final int DRAG_LINE_COUNT = 5;
    public static final @NonNull Color INVALID_BACKGROUND = Colors.isDarkModeUI() ? Colors.create(85, 44, 44) : Colors.create(255, 224, 224);

    public static final BlockTextField addField(@NonNull Block parent, String fieldText, int fieldWidth, @NonNull BlockTextField.IFieldModifiedListener listener) {
        BlockTextField field = new BlockTextField(fieldText);
        field.addFieldModifiedListener(listener);
        PrecisionLayoutData layoutData = new PrecisionLayoutData().setHorizontalAlignment(4);
        if (fieldWidth > 0) {
            layoutData.setMinimumWidth(fieldWidth);
        } else {
            layoutData.setGrabHorizontalSpace(true);
        }
        field.setLayoutData(layoutData);
        parent.add(field);
        return field;
    }

    public static final boolean confirmRemoveSeriesDialog(@NonNull Block block) {
        MessageDialogWithToggle dialog;
        int code;
        boolean remove;
        boolean bl = remove = !StreamlinePreferences.showRemoveSeriesConfirmDialog();
        if (!remove && (code = (dialog = new MessageDialogWithToggle(block.getShell(), ChartMessages.REMOVE_SERIES_TITLE, null, ChartMessages.REMOVE_SERIES_QUESTION, 5, new String[]{IDialogConstants.CANCEL_LABEL, ChartMessages.REMOVE_SERIES_TITLE}, 1, ChartMessages.ALWAYS_REMOVE_WITHOUT_ASKING, false)).open()) == 256) {
            if (dialog.getToggleState()) {
                StreamlinePreferences.setShowRemoveSeriesConfirmDialog(false);
            }
            remove = true;
        }
        return remove;
    }

    public static final void drawDragGrip(GC gc, @NonNull Block block) {
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        Rectangle bounds = block.getLocalBounds();
        gc.setAlpha(64);
        int left = bounds.x;
        int right = bounds.x + 20 - 1;
        int y = bounds.y + (bounds.height + 6 - 15) / 2;
        int i = 0;
        while (i < 5) {
            gc.setForeground(Colors.getBlack());
            gc.drawLine(left, y, right, y);
            gc.setForeground(Colors.getWhite());
            gc.drawLine(left, ++y, right, y);
            y += 2;
            ++i;
        }
        gc.setAlpha(255);
        gc.setAntialias(savedAA);
    }

    public static final Rectangle getDragGripBounds(@NonNull Block block) {
        Rectangle bounds = block.getLocalBounds();
        bounds.width = 20;
        bounds.y += (bounds.height + 6 - 15) / 2;
        bounds.height = 15;
        return bounds;
    }

    public static final int getScrollAmount(@NonNull Block block, @Nullable ScrollingBlock scroller, int y) {
        int amount = 0;
        if (scroller != null) {
            int top = scroller.toRootY(0);
            int bottom = top + scroller.getHeight() - 1;
            int pos = block.toRootY(y);
            if (pos < top + 5) {
                amount = -20;
            } else if (pos > bottom - 5) {
                amount = 20;
            }
        }
        return amount;
    }
}

