/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.cam;

import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapMessages;
import com.arm.streamline.jni.apcdbgen.proto.ICAMJob;
import org.eclipse.jdt.annotation.NonNull;

public final class CustomActivityMapUtils {
    private static final long HUNDRED_MS_IN_NANOS = 100000000L;
    private static final TimeUnit MILLISECONDS_TIME_UNIT = new TimeUnit(1000000, "ms", "millisecond");

    private CustomActivityMapUtils() {
    }

    public static void addTooltipFor(@NonNull TimeUnit timeUnit, @NonNull StringBuilder buffer, @NonNull ICAMJob job, boolean first) {
        long startTime = job.getStartTime();
        long duration = job.getStopTime() - startTime;
        if (!first) {
            buffer.append('\n');
        }
        buffer.append(String.format(CustomActivityMapMessages.INITIATED, job.getDetailText(), timeUnit.formatInBaseSymbolUnits(startTime)));
        if (duration > 0L) {
            TimeUnit durationTimeUnit = MILLISECONDS_TIME_UNIT;
            if (duration >= 100000000L) {
                durationTimeUnit = timeUnit;
            }
            buffer.append(String.format(CustomActivityMapMessages.DURATION, durationTimeUnit.formatInBase((double)duration, 1000.0, TimeUnit.Style.SYMBOL_UNIT, false)));
        }
    }

    public static long getTimeInNanoSeconds(@NonNull ZoomLevel zoomLevel, long slot) {
        return zoomLevel.convertBinToNanoseconds(slot);
    }

    public static long getDurationInNanoSeconds(@NonNull ZoomLevel zoomLevel, long startOfSlot, long endOfSlot) {
        return zoomLevel.convertBinToNanoseconds(endOfSlot - startOfSlot + 1L);
    }
}

