/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.cam;

import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.HandlePanel;
import com.arm.streamline.editortabs.timeline.common.IRowSelection;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapRowDataPanel;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapViewPanel;
import com.arm.streamline.jni.apcdbgen.proto.ICAMTrack;
import com.arm.streamline.utility.ui.StreamlineUIConstants;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.DragTracker;
import com.arm.utils.NullChecking;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public final class CustomActivityMapRowHandlePanel
extends HandlePanel<ICAMTrack> {
    private final @NonNull CustomActivityMapRowDataPanel mCAMPanel;
    private final @NonNull CustomActivityMapViewPanel mCAMsPanel;
    private boolean mOpened = false;
    private final @NonNull ICAMTrack mRow;

    private static void forEachChildRecursive(@NonNull ICAMTrack track, @NonNull Consumer<@NonNull ICAMTrack> consumer) {
        consumer.accept(track);
        track.getChildren().forEach(r -> CustomActivityMapRowHandlePanel.forEachChildRecursive(r, consumer));
    }

    public CustomActivityMapRowHandlePanel(@NonNull BaseTimelineContent content, @NonNull CustomActivityMapViewPanel parentCAMsPanel, @NonNull ICAMTrack row, int indent, int rowHeight) {
        this(content, parentCAMsPanel, row, indent, rowHeight, rowHeight);
    }

    public CustomActivityMapRowHandlePanel(@NonNull BaseTimelineContent content, @NonNull CustomActivityMapViewPanel parentCAMsPanel, @NonNull ICAMTrack row, int indent, int rowHeightWhenOpen, int rowHeightWhenClosed) {
        super(content, indent, new SelectionHandler(), rowHeightWhenOpen, rowHeightWhenClosed);
        this.mCAMsPanel = parentCAMsPanel;
        this.mRow = row;
        this.mCAMPanel = new CustomActivityMapRowDataPanel(this);
        this.mCAMsPanel.getTrackToPanelMap().put(row, this.mCAMPanel);
        this.setLayout(this);
        this.add(this.mCAMPanel);
        this.setOpen(true);
    }

    public void forEachChildRecursive(@NonNull Consumer<@NonNull ICAMTrack> consumer) {
        this.getRowChildren().stream().forEach(r -> CustomActivityMapRowHandlePanel.forEachChildRecursive(r, consumer));
    }

    public CustomActivityMapViewPanel getCAMsPanel() {
        return this.mCAMsPanel;
    }

    public @NonNull Stream<CustomActivityMapRowHandlePanel> getFlattenedHandlePanels() {
        return this.getFlattenedChildren().filter(b -> b instanceof CustomActivityMapRowHandlePanel).map(b -> (CustomActivityMapRowHandlePanel)b);
    }

    public @NonNull CustomActivityMapRowDataPanel getMapPanel() {
        return this.mCAMPanel;
    }

    public @NonNull ICAMTrack getRow() {
        return this.mRow;
    }

    @Override
    public @NonNull List<@NonNull ? extends ICAMTrack> getRowChildren() {
        return this.mRow.getChildren();
    }

    @Override
    public int getRowUID() {
        return this.mRow.getId();
    }

    public void setOpen(boolean open, boolean doRepackImmediatelly) {
        if (this.isRowOpen() != open) {
            this.doOpen(open, doRepackImmediatelly);
        }
    }

    @Override
    protected HandlePanel<ICAMTrack> constructChildPanel(@NonNull ICAMTrack row) {
        if (!this.mCAMsPanel.getTrackEnabledState().isEnabled(row)) {
            return null;
        }
        int nestedIndent = this.mIndent + StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.width / 2 + 4;
        int rowHeightWhenOpen = CustomActivityMapViewPanel.computeRowHeight(row);
        int rowHeightWhenClosed = this.mCAMsPanel.computeRecursiveMaxRowHeight(row);
        return new CustomActivityMapRowHandlePanel(this.getContent(), this.mCAMsPanel, row, nestedIndent, rowHeightWhenOpen, rowHeightWhenClosed);
    }

    @Override
    protected @Nullable DragTracker createMoveTracker(Point where) {
        return null;
    }

    @Override
    protected Color getForegroundColor() {
        return Colors.getBlack();
    }

    @Override
    protected @Nullable Image getIconImage() {
        return null;
    }

    @Override
    protected String getResizeGripToolTipText() {
        return "";
    }

    @Override
    protected final List<? extends ICAMTrack> getRowSiblings() {
        if (this.getParent() == this.getTopmostContainerBlock()) {
            return this.getCAMsPanel().getCAMDataProvider().getTracks();
        }
        if (this.getParent() instanceof CustomActivityMapRowHandlePanel) {
            @NonNull HandlePanel handlePanel = (HandlePanel)NullChecking.neverNull((Object)((CustomActivityMapRowHandlePanel)this.getParent()));
            return handlePanel.getRowChildren();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected @NonNull String getTitle() {
        return this.mRow.getTitle();
    }

    @Override
    protected Block getTopmostContainerBlock() {
        return this.mCAMsPanel;
    }

    @Override
    protected boolean isRowOpen() {
        return this.mOpened;
    }

    @Override
    protected boolean passesFilter(ICAMTrack row) {
        return true;
    }

    @Override
    protected void setRelatedControlBounds(int i, int y, int j, int rowHeight) {
        this.mCAMPanel.setBounds(i, y, j, rowHeight);
    }

    @Override
    protected void setRowOpenness(boolean open) {
        if (open != this.mOpened) {
            if (this.getRowChildren().size() > 0) {
                if (!open) {
                    this.forEachChildRecursive(childTrack -> {
                        if (this.mCAMsPanel.getTrackEnabledState().isEnabled((ICAMTrack)childTrack)) {
                            this.getCAMsPanel().getTrackToPanelMap().put((ICAMTrack)childTrack, this.getMapPanel());
                        }
                    });
                }
                this.mCAMPanel.setRowOpenness(open);
                this.mOpened = open;
            } else {
                this.mCAMPanel.setRowOpenness(true);
                this.mOpened = true;
            }
        }
    }

    @Override
    protected boolean shouldShowAnnotationMarkerForRow() {
        return false;
    }

    @Override
    protected void showHandlePanelContextMenu(Point locationInDisplayCoords) {
        this.getCAMsPanel().showHandlePanelsContextMenu(locationInDisplayCoords, this);
    }

    static class SelectionHandler
    implements IRowSelection {
        SelectionHandler() {
        }

        @Override
        public void deselectRows(int[] array) {
        }

        @Override
        public boolean isRowSelected(int id) {
            return false;
        }

        @Override
        public void selectRow(int rowUID, int stateMask) {
        }
    }
}

