/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.cam;

import com.arm.streamline.application.StreamlineTheme;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.editortabs.timeline.common.GraphBlock;
import com.arm.streamline.editortabs.timeline.common.cam.CachedRender;
import com.arm.streamline.editortabs.timeline.common.cam.ConnectionLine;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapRowHandlePanel;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapUtils;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapViewPanel;
import com.arm.streamline.editortabs.timeline.common.cam.DebugLabelFormatter;
import com.arm.streamline.editortabs.timeline.common.cam.RenderedJob;
import com.arm.streamline.editortabs.timeline.common.cam.WorkloadLabelVisitor;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.jni.apcdbgen.proto.GPUWorkloadJobResolver;
import com.arm.streamline.jni.apcdbgen.proto.ICAMJob;
import com.arm.streamline.jni.apcdbgen.proto.ICAMJobTypeResolver;
import com.arm.streamline.jni.apcdbgen.proto.ICAMTrack;
import com.arm.streamline.jni.apcdbgen.proto.IGPUWorkloadJob;
import com.arm.streamline.jni.apcdbgen.proto.ILabelVisitor;
import com.arm.streamline.jni.apcdbgen.proto.TimelineWorkload;
import com.arm.streamline.model.cam.CAMJobListMerger;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.utility.text.TextFilter;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.Fonts;
import com.arm.utils.ListUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public final class CustomActivityMapRowDataPanel
extends GraphBlock {
    private static final String ELLIPSIS_AND_ONE_CHAR = "n\u2026";
    private static final @NonNull Color SELECTED_JOB_COLOR = Colors.create(255, 128, 0);
    private static final @NonNull Color FILTERED_OUT_COLOR_DARK = Colors.create(84, 64, 44);
    private static final @NonNull Color FILTERED_OUT_COLOR_LIGHT = Colors.create(184, 164, 144);
    private @Nullable CachedRender cachedData = null;
    private @Nullable RenderedJob hoveredJob;
    private @NonNull Color mFilteredOutColor = FILTERED_OUT_COLOR_DARK;
    private final @NonNull CustomActivityMapRowHandlePanel mHandlePanel;

    public CustomActivityMapRowDataPanel(CustomActivityMapRowHandlePanel handlePanel) {
        super(handlePanel.getContent());
        this.mHandlePanel = handlePanel;
    }

    public final @Nullable ICAMJob getJobAt(int xPos) {
        RenderedJob renderJob = this.getRenderJobAt(xPos);
        if (renderJob != null) {
            return renderJob.job;
        }
        return null;
    }

    @Override
    public final boolean handleMouseUpWithoutDrag(Point where, int button, int stateMask, int count) {
        if (where == null) {
            return false;
        }
        CustomActivityMapViewPanel camsPanel = this.mHandlePanel.getCAMsPanel();
        boolean toggle = (stateMask & SWT.MOD1) == SWT.MOD1;
        this.mHandlePanel.getCAMsPanel().setLastSelectedMousePosition(where);
        ICAMJob job = this.getJobAt(where.x);
        if (job != null) {
            camsPanel.setSelectedJobs(new ICAMJob[]{job}, toggle);
        } else {
            camsPanel.setSelectedJobs(new ICAMJob[0], toggle);
        }
        return toggle || job != null;
    }

    public void setRowOpenness(boolean isOpen) {
        this.cachedData = null;
    }

    @Override
    protected void mouseExit() {
        super.mouseExit();
        if (this.hoveredJob != null) {
            this.hoveredJob = null;
            this.repaint();
        }
    }

    @Override
    protected void mouseSlotWasUpdated() {
    }

    @Override
    protected final void paintSelf(GC gc) {
        super.paintSelf(gc);
        this.updateThemeColors();
        this.drawBackgroundWithVerticalGroupingMarkers(gc, false);
        this.drawBars(gc);
        this.drawCaliperEnds(gc);
        this.drawBookmarks(gc);
        this.drawCrossSectionMarker(gc);
        this.updatePositionReadout();
    }

    @Override
    protected final void updateMouseSlot(Point where) {
        RenderedJob hoveredJob;
        RenderedJob prevHoverJob;
        super.updateMouseSlot(where);
        CustomActivityMapViewPanel camsPanel = this.mHandlePanel.getCAMsPanel();
        String connectionLineTooltip = camsPanel.updateForMouseOverConnectionLines(null, camsPanel.fromRoot(this.toRoot(where.x, where.y)));
        if (connectionLineTooltip != null) {
            this.setToolTip(connectionLineTooltip);
        }
        if ((prevHoverJob = this.hoveredJob) != (hoveredJob = this.getRenderJobAt(where.x))) {
            this.hoveredJob = hoveredJob;
            this.repaint();
        }
        if (hoveredJob != null) {
            this.displayTooltip(where, hoveredJob);
        }
        if (hoveredJob == null && connectionLineTooltip == null) {
            this.setToolTip(null);
        }
    }

    @Override
    protected final void updateThemeColors() {
        super.updateThemeColors();
        switch (StreamlinePreferences.getTheme()) {
            default: {
                this.mFilteredOutColor = FILTERED_OUT_COLOR_DARK;
                break;
            }
            case LIGHT: {
                this.mFilteredOutColor = FILTERED_OUT_COLOR_LIGHT;
            }
        }
    }

    private void displayTooltip(Point where, @NonNull RenderedJob tooltipJob) {
        TimeUnit timeUnit = this.mHandlePanel.getContent().getCaptureDataProvider().getTimeUnit();
        List<ICAMJob> hiddenJobs = tooltipJob.hiddenJobs;
        int maxToShow = hiddenJobs != null ? Math.min(hiddenJobs.size(), 4) : 0;
        int additionalJobs = hiddenJobs != null ? hiddenJobs.size() - maxToShow : 0;
        StringBuilder buffer = new StringBuilder();
        CustomActivityMapUtils.addTooltipFor(timeUnit, buffer, tooltipJob.job, true);
        if (hiddenJobs != null) {
            int i = 0;
            while (i < maxToShow) {
                CustomActivityMapUtils.addTooltipFor(timeUnit, buffer, hiddenJobs.get(i), false);
                ++i;
            }
        }
        if (additionalJobs > 0) {
            buffer.append("\n... +" + additionalJobs + " more");
        }
        CustomActivityMapViewPanel camsPanel = this.mHandlePanel.getCAMsPanel();
        this.setToolTip(camsPanel.updateForMouseOverConnectionLines(buffer.toString(), camsPanel.fromRoot(this.toRoot(where.x, where.y))));
    }

    private final void drawBars(GC gc) {
        StreamlineTheme theme = StreamlinePreferences.getTheme();
        ICaptureDataProvider cdp = this.mHandlePanel.getContent().getCaptureDataProvider();
        CachedRender cachedData = this.prepareData(this.getFirstVisibleSlot(), this.getLastVisibleSlot(), cdp.getScales().getZoomLevel());
        @NonNull List<@NonNull RenderedJob> renderedJobs = cachedData.getRenderedJobs(this.getSlotWidth(), this.getSlotOffset());
        if (renderedJobs.isEmpty()) {
            return;
        }
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        Rectangle bounds = this.getLocalBounds();
        int xPos = bounds.x;
        int yPos = bounds.y + 2;
        int height = bounds.height - 4;
        int yPosHover = bounds.y + 1;
        int heightHover = bounds.height - 2;
        int widthOfAFewChars = gc.stringExtent((String)ELLIPSIS_AND_ONE_CHAR).x;
        for (RenderedJob job : renderedJobs) {
            int startPix;
            boolean hovered;
            boolean showText = true;
            boolean bl = hovered = job == this.hoveredJob;
            if (job.hidden && !hovered) continue;
            Color colour = Colors.create(job.job.getColor());
            if (hovered) {
                colour = theme.highlight(colour);
            } else {
                boolean filteredOut = CustomActivityMapRowDataPanel.isFilteredOut(job.job, this.mHandlePanel.getCAMsPanel().getJobFilterPattern());
                if (filteredOut) {
                    colour = this.mFilteredOutColor;
                }
            }
            boolean selected = this.mHandlePanel.getCAMsPanel().getSelectedJobs().contains(job.job);
            boolean anythingSelected = !this.mHandlePanel.getCAMsPanel().getSelectedJobs().isEmpty();
            int n = startPix = hovered ? job.realStartPix : job.renderStartPix;
            if (anythingSelected && !selected) {
                colour = theme.desaturate(colour);
                showText = false;
                for (ConnectionLine selectedLines : this.mHandlePanel.getCAMsPanel().getConnectionLines()) {
                    if (!selectedLines.getSource().equals(job.job) && !selectedLines.getDestination().equals(job.job)) continue;
                    colour = theme.lowlightCAM(colour);
                    showText = true;
                }
            }
            CustomActivityMapRowDataPanel.drawJob(gc, selected, colour, widthOfAFewChars, showText, job, xPos + startPix, hovered ? yPosHover : yPos, job.renderStopPix - startPix, hovered ? heightHover : height);
        }
        gc.setAntialias(savedAA);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static boolean isFilteredOut(@NonNull ICAMJob job, @Nullable Pattern pattern) {
        if (pattern == null) {
            return false;
        }
        @NonNull @NonNull Map workloadMap = Collections.emptyMap();
        @NonNull List debugLabels = Collections.emptyList();
        @Nullable IGPUWorkloadJob gpuWorkloadJob = (IGPUWorkloadJob)job.accept((ICAMJobTypeResolver)new GPUWorkloadJobResolver());
        if (gpuWorkloadJob != null) {
            TimelineWorkload properties = gpuWorkloadJob.getTimelineWorkload();
            workloadMap = properties.getProperties();
            debugLabels = properties.getDebugLabels();
        }
        boolean matchesAnyWorkloadProperty = workloadMap.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).anyMatch(kv -> pattern.matcher((CharSequence)kv).find());
        boolean matchesAnyDebugLabel = debugLabels.stream().anyMatch(label -> pattern.matcher((CharSequence)label).find());
        return !pattern.matcher(job.getName()).find() && !pattern.matcher(String.valueOf(job.getId())).find() && !pattern.matcher(job.getTrack().getTitle()).find() && !matchesAnyWorkloadProperty && !matchesAnyDebugLabel;
    }

    private static void drawJob(GC gc, boolean isSelected, Color colour, int widthOfAFewChars, boolean showText, @NonNull RenderedJob job, int x, int y, int width, int height) {
        gc.setForeground(colour);
        gc.setBackground(colour);
        gc.fillRectangle(x, y, width, height);
        Color textColor = Colors.isDark(colour) ? Colors.getWhite() : Colors.getBlack();
        gc.setForeground(textColor);
        if (width > widthOfAFewChars && showText) {
            String labelToDisplay = "";
            @Nullable IGPUWorkloadJob gpuWorkloadJob = (IGPUWorkloadJob)job.job.accept((ICAMJobTypeResolver)new GPUWorkloadJobResolver());
            labelToDisplay = gpuWorkloadJob != null ? CustomActivityMapRowDataPanel.getGPUWorkloadLabel(gc, width, gpuWorkloadJob) : job.job.getName();
            gc.setFont(Fonts.getSmall());
            TextDrawing.drawText(gc, labelToDisplay, x, y, width, height, 0x1000000, 0x1000000);
        }
        if (isSelected) {
            gc.setForeground(SELECTED_JOB_COLOR);
            gc.drawRectangle(x, y, width, height);
        }
    }

    private static String getGPUWorkloadLabel(GC gc, int width, IGPUWorkloadJob gpuWorkloadJob) {
        TimelineWorkload workload = gpuWorkloadJob.getTimelineWorkload();
        List debugLabels = workload.getDebugLabels();
        DebugLabelFormatter formatter = new DebugLabelFormatter();
        WorkloadLabelVisitor labelVisitor = new WorkloadLabelVisitor();
        workload.accept((ILabelVisitor)labelVisitor);
        @NonNull ArrayList<@NonNull String> allLabels = new ArrayList<String>();
        if (!debugLabels.isEmpty()) {
            allLabels.add(formatter.formatLabels(debugLabels));
        } else {
            allLabels.add(String.format("<%s #%d>", workload.getName(), workload.getId()));
        }
        allLabels.addAll(labelVisitor.getLabels());
        return TextFilter.makeMultilineLabel(gc, allLabels, width);
    }

    private final @Nullable RenderedJob getRenderJobAt(int xPos) {
        int ndx;
        List<RenderedJob> renderedJobs;
        CachedRender cachedData = this.cachedData;
        List<RenderedJob> list = renderedJobs = cachedData != null ? cachedData.getRenderedJobs(this.getSlotWidth(), this.getSlotOffset()) : null;
        if (renderedJobs != null && (ndx = ListUtils.binarySearch(renderedJobs, j -> {
            if (xPos >= j.renderStartPix && xPos < j.renderStopPix) {
                return 0;
            }
            return Long.compare(xPos, j.renderStartPix);
        })) >= 0 && ndx < renderedJobs.size()) {
            RenderedJob result = renderedJobs.get(ndx);
            assert (xPos >= result.renderStartPix && xPos < result.renderStopPix);
            return result;
        }
        return null;
    }

    private @NonNull CachedRender prepareData(long firstVisibleSlot, long lastVisibleSlot, @NonNull ZoomLevel zoomLevel) {
        CachedRender result;
        CAMJobListMerger jobList;
        boolean collapsed = !this.mHandlePanel.isOpen();
        CachedRender cachedData = this.cachedData;
        if (cachedData != null && cachedData.firstVisibleSlot == firstVisibleSlot && cachedData.lastVisibleSlot == lastVisibleSlot && zoomLevel.equals((Object)cachedData.zoomLevel) && cachedData.collapsed == collapsed) {
            return cachedData;
        }
        long rangeStartNS = CustomActivityMapUtils.getTimeInNanoSeconds(zoomLevel, firstVisibleSlot);
        long rangeDurationNS = CustomActivityMapUtils.getDurationInNanoSeconds(zoomLevel, firstVisibleSlot, lastVisibleSlot);
        long rangeEndNS = rangeStartNS + rangeDurationNS;
        if (collapsed) {
            ArrayList<List<? extends ICAMJob>> perTrackJobs = new ArrayList<List<? extends ICAMJob>>();
            this.mHandlePanel.forEachChildRecursive(track -> {
                if (!this.mHandlePanel.getCAMsPanel().getTrackEnabledState().isEnabled((ICAMTrack)track)) {
                    return;
                }
                List jobs = track.getJobs(rangeStartNS, rangeEndNS);
                if (!jobs.isEmpty()) {
                    perTrackJobs.add(jobs);
                }
            });
            jobList = new CAMJobListMerger(perTrackJobs);
        } else {
            List jobs = this.mHandlePanel.getRow().getJobs(rangeStartNS, rangeEndNS);
            jobList = new CAMJobListMerger(Arrays.asList(jobs));
        }
        this.cachedData = result = new CachedRender(jobList, zoomLevel, firstVisibleSlot, lastVisibleSlot, collapsed);
        return result;
    }

    public Point getRenderedPosition(long starttime, long stoptime) {
        CachedRender cachedData = this.cachedData;
        if (cachedData != null) {
            return cachedData.getRenderedPosition(starttime, stoptime, this.getSlotWidth(), this.getSlotOffset());
        }
        return null;
    }
}

