/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.cam;

import com.arm.streamline.editortabs.timeline.common.cam.ConnectionLineType;
import com.arm.streamline.jni.apcdbgen.proto.ICAMJob;
import org.eclipse.jdt.annotation.NonNull;

public class ConnectionLine
implements Comparable<ConnectionLine> {
    private final @NonNull ConnectionLineType mType;
    private final @NonNull ICAMJob mSource;
    private final @NonNull ICAMJob mDestination;
    private long mStartX;
    private int mStartY;
    private long mEndX;
    private int mEndY;

    public ConnectionLine(@NonNull ConnectionLineType type, @NonNull ICAMJob source, @NonNull ICAMJob destination) {
        this.mType = type;
        this.mSource = source;
        this.mDestination = destination;
        this.reset();
    }

    @Override
    public final int compareTo(ConnectionLine other) {
        long s2;
        long s1 = this.mSource.getStartTime();
        if (s1 < (s2 = other.mSource.getStartTime())) {
            return -1;
        }
        if (s2 < s1) {
            return 1;
        }
        s1 = this.mSource.getStopTime();
        if (s1 < (s2 = other.mSource.getStopTime())) {
            return -1;
        }
        if (s2 < s1) {
            return 1;
        }
        return 0;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionLine other = (ConnectionLine)obj;
        return this.mType == other.mType && this.mSource.equals(other.mSource) && this.mDestination.equals(other.mDestination);
    }

    public final @NonNull ICAMJob getDestination() {
        return this.mDestination;
    }

    public final long getEndX() {
        return this.mEndX;
    }

    public final int getEndY() {
        return this.mEndY;
    }

    public final @NonNull ICAMJob getSource() {
        return this.mSource;
    }

    public final long getStartX() {
        return this.mStartX;
    }

    public final int getStartY() {
        return this.mStartY;
    }

    public final @NonNull ConnectionLineType getType() {
        return this.mType;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 31 + this.mType.hashCode();
        result = 31 * result + this.mSource.hashCode();
        result = 31 * result + this.mDestination.hashCode();
        return result;
    }

    public final boolean isInHitArea(int x, int y) {
        long yy;
        long xx;
        long x2 = this.mEndX - this.mStartX;
        long y2 = this.mEndY - this.mStartY;
        long dotprod = (xx = (long)x - this.mStartX) * x2 + (yy = (long)(y - this.mStartY)) * y2;
        double projlenSq = dotprod <= 0L ? 0.0 : ((dotprod = (xx = x2 - xx) * x2 + (yy = y2 - yy) * y2) <= 0L ? 0.0 : (double)(dotprod * dotprod) / (double)(x2 * x2 + y2 * y2));
        double lenSq = (double)(xx * xx + yy * yy) - projlenSq;
        return lenSq <= 7.0;
    }

    public final boolean isValid() {
        return this.mStartX != Long.MIN_VALUE;
    }

    public final void reset() {
        this.mStartX = Long.MIN_VALUE;
        this.mStartY = Integer.MIN_VALUE;
        this.mEndX = Long.MIN_VALUE;
        this.mEndY = Integer.MIN_VALUE;
    }

    public final void setCoordinates(long sx, int sy, long dx, int dy) {
        this.mStartX = sx;
        this.mStartY = sy;
        this.mEndX = dx;
        this.mEndY = dy;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        buffer.append(this.getClass().getSimpleName());
        buffer.append(" (valid:");
        buffer.append(this.isValid());
        buffer.append(", type:");
        buffer.append((Object)this.mType);
        buffer.append(", startX:");
        buffer.append(this.mStartX);
        buffer.append(", startY:");
        buffer.append(this.mStartY);
        buffer.append(", endX:");
        buffer.append(this.mEndX);
        buffer.append(", endY:");
        buffer.append(this.mEndY);
        buffer.append(", source:");
        buffer.append(this.mSource);
        buffer.append(", destination:");
        buffer.append(this.mDestination);
        buffer.append(")]");
        return buffer.toString();
    }
}

