/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.cam;

import com.arm.streamline.editortabs.timeline.common.cam.ICAMTrackEnabledState;
import com.arm.streamline.jni.apcdbgen.proto.ICAMTrack;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class CAMTrackEnabledState
implements ICAMTrackEnabledState {
    private final @NonNull Set<@NonNull Integer> mTracksDisabled;

    public CAMTrackEnabledState() {
        this.mTracksDisabled = new HashSet<Integer>();
    }

    public CAMTrackEnabledState(@NonNull Set<@NonNull Integer> disabled) {
        this.mTracksDisabled = new HashSet<Integer>(disabled);
    }

    @Override
    public boolean isEnabled(@NonNull ICAMTrack track) {
        return !this.mTracksDisabled.contains(track.getId());
    }

    @Override
    public void disable(@NonNull ICAMTrack track) {
        this.mTracksDisabled.add(track.getId());
        this.disableChildrenRecursive(track);
    }

    private void disableChildrenRecursive(@NonNull ICAMTrack track) {
        for (ICAMTrack child : track.getChildren()) {
            this.disable(child);
        }
    }

    @Override
    public void reset() {
        this.mTracksDisabled.clear();
    }

    @Override
    public boolean allEnabled() {
        return this.mTracksDisabled.isEmpty();
    }

    @Override
    public @NonNull Set<@NonNull Integer> getDisabled() {
        return Collections.unmodifiableSet(this.mTracksDisabled);
    }
}

