/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline;

import com.arm.streamline.application.IVetoablePageChangeListener;
import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.EditorTab;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.ProcessingDialog;
import com.arm.streamline.editortabs.timeline.TimelineContent;
import com.arm.streamline.utility.CommandAction;
import com.arm.streamline.utility.ICommandTarget;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.utils.NullChecking;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.ActionFactory;

public class TimelineTab
extends EditorTab
implements IVetoablePageChangeListener,
ICommandTarget,
ISelectionProvider {
    private TimelineContent mContent = new TimelineContent(this);

    public TimelineTab(@NonNull AnalysisEditor editor) {
        super(editor);
        this.init();
        editor.addVetoablePageChangeListener(this);
    }

    public final void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    @Override
    public final boolean allowPageChange(EditorTabID from, EditorTabID to) {
        if (!to.okToShowWhileProcessing() && this.getAnalysis().isBusy()) {
            this.getDisplay().asyncExec(() -> {
                ProcessingDialog dialog = new ProcessingDialog((AnalysisEditor)NullChecking.neverNull((Object)this.getEditor()), to);
                dialog.create();
                dialog.open();
            });
            return false;
        }
        return true;
    }

    public TimelineContent getContent() {
        return this.mContent;
    }

    public final ISelection getSelection() {
        Control focusControl = Display.getCurrent().getFocusControl();
        return focusControl instanceof ISelectionProvider ? ((ISelectionProvider)focusControl).getSelection() : null;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this;
    }

    @Override
    public final void obeyCommand(CommandAction action) {
        Control focusControl = Display.getCurrent().getFocusControl();
        if (focusControl instanceof ICommandTarget) {
            ((ICommandTarget)focusControl).obeyCommand(action);
        }
    }

    @Override
    public void recomputeFromModel() {
    }

    public final void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public final boolean setFocus() {
        return this.mContent.setFocus();
    }

    public final void setSelection(ISelection selection) {
        Control focusControl = Display.getCurrent().getFocusControl();
        if (focusControl instanceof ISelectionProvider) {
            ((ISelectionProvider)focusControl).setSelection(selection);
        }
    }

    @Override
    public final void widgetDisposed(DisposeEvent event) {
        AnalysisEditor editor = this.getEditor();
        if (editor != null) {
            editor.removeVetoablePageChangeListener(this);
        }
        super.widgetDisposed(event);
    }

    @Override
    protected Composite createContent() {
        return this.mContent;
    }

    @Override
    protected void fillToolbar(CustomToolbar toolbar) {
        this.mContent.fillToolbar(toolbar);
    }

    @Override
    protected final String getHelpID() {
        return "com.arm.streamline.timelines";
    }

    @Override
    protected final void initActionMap(Map<String, IAction> map) {
        this.addCommandAction(map, ActionFactory.CUT);
        this.addCommandAction(map, ActionFactory.COPY);
        this.addCommandAction(map, ActionFactory.PASTE);
        this.addCommandAction(map, ActionFactory.SELECT_ALL);
        this.addCommandAction(map, ActionFactory.DELETE);
    }

    private final void addCommandAction(Map<String, IAction> map, ActionFactory factory) {
        String id = factory.getId();
        map.put(id, (IAction)new CommandAction(id, this));
    }
}

