/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline;

import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.editortabs.timeline.IHeatmapExportFormatter;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.utils.NullChecking;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class HeatmapExportFormatter
implements IHeatmapExportFormatter {
    @Override
    public @NonNull String formatColumnTitle(@NonNull ITimelineRowProvider provider) throws IOException {
        StringBuilder builder = new StringBuilder(provider.getName());
        @Nullable ITimelineRowProvider next = provider;
        while ((next = next.getParent()) != null) {
            builder.insert(0, next.getName() + "/");
        }
        return builder.toString();
    }

    @Override
    public @NonNull String formatBinValue(int data, boolean averageHeatmapPerCore) throws IOException {
        if (data < 0) {
            switch (data) {
                case -1: {
                    return "-";
                }
                case -2: {
                    return "I";
                }
                case -3: {
                    return "C";
                }
                case -4: {
                    return "IO";
                }
                case -5: {
                    return "W";
                }
                case -6: {
                    return "D";
                }
                case -7: {
                    return "X";
                }
            }
            throw new IOException("Invalid negative value in exporting heatmap item");
        }
        data = averageHeatmapPerCore ? Math.min(data, 10000) : data;
        Double val = (double)data / 100.0;
        return (String)NullChecking.neverNull((Object)String.format("%.2f%%", val));
    }

    @Override
    public @NonNull String formatTime(int bin, @NonNull ZoomLevel zoomLevel, @NonNull TimeUnit timeUnit) {
        return timeUnit.formatBin((long)bin, zoomLevel, TimeUnit.Style.NO_UNIT, true);
    }
}

