/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.editortabs.timeline.LabeledColorWell;
import com.arm.streamline.editortabs.timeline.TimelineMessages;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.IFocusChartListener;
import com.arm.streamline.editortabs.timeline.common.ITimelineConstants;
import com.arm.streamline.editortabs.timeline.common.IUniqueThreadSelectionHandler;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapScrollableWrapper;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapViewPanel;
import com.arm.streamline.editortabs.timeline.common.heatmap.HeatMapWrapper;
import com.arm.streamline.jni.apcdbgen.proto.ICAMDataProvider;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueID;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.IProcessDataProvider;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.BlockCheckBox;
import com.arm.streamline.widget.lightweight.BlockImageButton;
import com.arm.streamline.widget.lightweight.BlockLabel;
import com.arm.streamline.widget.lightweight.BlockPopupMenu;
import com.arm.streamline.widget.lightweight.BlockRoot;
import com.arm.streamline.widget.lightweight.BlockTextField;
import com.arm.streamline.widget.lightweight.BlockToolbar;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;

public class FilterToolbar
extends BlockToolbar
implements BlockPopupMenu.IPopupMenuItemSelectionListener,
IFocusChartListener,
ITimelineConstants,
IUniqueThreadSelectionHandler {
    BaseTimelineContent mContent;
    private BlockPopupMenu mPanelDropDown;
    private BlockTextField mHeatMapFilterField;

    private static final void updateCamJobFilterValidity(CustomActivityMapViewPanel camsPanel, BlockTextField field) {
        field.setValid(camsPanel.getJobFilter().isEmpty() || camsPanel.getJobFilterPattern() != null);
    }

    public FilterToolbar(BaseTimelineContent content) {
        this.mContent = content;
        this.mPanelDropDown = new BlockPopupMenu();
        this.mPanelDropDown.setLayoutData(new BlockToolbar.LayoutData().setGap(4));
        this.add(this.mPanelDropDown);
        if (!this.mContent.getCaptureDataProvider().isLive()) {
            this.addMenuItem("HeatMap.png", TimelineMessages.HEAT_MAP, 'h', "heat");
            this.addMenuItem("InvertedHeatmap.png", TimelineMessages.INVERTED_HEAT_MAP, 'n', "heat_inverted");
            if (this.mContent.isCoreMapAvailable()) {
                this.addMenuItem("Cores.png", TimelineMessages.CORE_MAP, 'c', "core");
            }
            if (this.mContent.isClusterMapAvailable()) {
                this.addMenuItem("Clusters.png", TimelineMessages.CLUSTER_MAP, 'u', "cluster");
            }
            if (BaseTimelineContent.isSamplesHudAvailable()) {
                this.addMenuItem("Samples.png", TimelineMessages.SAMPLES, 's', "samples");
            }
        }
        this.addMenuItem("Processes.png", TimelineMessages.PROCESSES, 'p', "processes");
        if (!this.mContent.getCaptureDataProvider().isLive()) {
            if (this.mContent.getCaptureDataProvider().visualAnnotationsPresent()) {
                this.addMenuItem("Images.png", TimelineMessages.IMAGES, 'i', "images");
            }
            if (this.mContent.isCustomActivityMapAvailable()) {
                int i = 0;
                for (ICAMDataProvider cam : this.mContent.getCaptureDataProvider().getCAMDataProviders()) {
                    String imgName = cam.isOpenCL() ? "OpenCL.png" : (cam.isOpenGL() ? "OpenGL.png" : "CustomActivityMap.png");
                    this.addMenuItem(imgName, cam.getName(), cam.getHotKey(), "cam_" + i++);
                }
            }
        }
        this.adjustToContent();
        this.mPanelDropDown.addPopupMenuItemSelectionListener(this);
        this.mContent.addFocusChartListener(this);
    }

    public final void adjustToContent() {
        String mode = this.mContent.getDetailAreaMode();
        this.mPanelDropDown.selectItemWithData(mode);
        int i = this.getChildCount();
        while (--i >= 1) {
            this.remove(i);
        }
        switch (mode) {
            case "heat_inverted": {
                this.addHeatMapFilter(false, false);
                this.addExportButton();
                break;
            }
            case "heat": {
                this.addHeatMapFilter(true, true);
                this.addExportButton();
                break;
            }
            case "core": {
                this.addCoreMapWidgets();
                break;
            }
            case "cluster": {
                this.addClusterMapWidgets();
                break;
            }
            case "processes": {
                this.addProcessWidgets();
                break;
            }
            default: {
                if (!mode.startsWith("cam_")) break;
                this.addCustomActivityMapWidgets();
            }
        }
        if (this.getOwner() != null) {
            this.layout();
        }
    }

    private void addExportButton() {
        BlockImageButton btn = new BlockImageButton(StreamlinePlugin.getImage("Export.gif"));
        btn.setToolTip(TimelineMessages.EXPORT_HEATMAP_TOOLTIP);
        this.add(btn);
        btn.addClickListener(new BlockImageButton.IClickListener(){

            @Override
            public void buttonClicked(BlockImageButton button) {
                FilterToolbar.this.mContent.exportHeatMapData();
            }
        });
    }

    private void addShowHideInfoButton() {
        BlockImageButton btn = new BlockImageButton(StreamlinePlugin.getImage("Information.gif"));
        btn.setToolTip(TimelineMessages.CAM_INFO_PANEL_TOOLTIP);
        this.add(btn);
        btn.addClickListener(new BlockImageButton.IClickListener(){

            @Override
            public void buttonClicked(BlockImageButton button) {
                ((CustomActivityMapScrollableWrapper)FilterToolbar.this.mContent.getBottomPanel()).toogleInfoPanel();
            }
        });
    }

    @Override
    public final void focusChartChanged() {
        this.adjustToContent();
    }

    @Override
    public final void popupMenuItemSelected(BlockPopupMenu popupMenu, int itemIndex, Object data) {
        this.mContent.setDetailAreaMode((String)data);
    }

    private final void addClusterMapWidgets() {
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        @NonNull ICaptureDataProvider.IFocusedEventSource fes = cdp.getFocusedEventSource();
        int count = fes.getClusterCount();
        int i = 0;
        while (i < count) {
            this.add(new LabeledColorWell(Colors.getClusterColor(i).getRGB(), Integer.toString(i), fes.getClusterDescription(i)));
            ++i;
        }
        this.addHeatMapFilter(false, true);
    }

    private final void addCoreMapWidgets() {
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        @NonNull ICaptureDataProvider.IFocusedEventSource fes = cdp.getFocusedEventSource();
        @NonNull Collection<@NonNull ICaptureDataProvider.IFocusedEventSourceCore> cores = fes.getCores();
        for (ICaptureDataProvider.IFocusedEventSourceCore core : cores) {
            this.add(new LabeledColorWell(Colors.getCoreColor(core.getColourIndex()).getRGB(), core.getNumericLabel(), core.getDescriptiveLabel()));
        }
        this.addHeatMapFilter(false, true);
    }

    private final void addCustomActivityMapWidgets() {
        CustomActivityMapViewPanel camsPanel = ((CustomActivityMapScrollableWrapper)this.mContent.getBottomPanel()).getCAMsPanel();
        BlockTextField field = new BlockTextField(camsPanel.getJobFilter());
        field.setWatermark(TimelineMessages.CAM_JOB_FILTER);
        field.setToolTip(TimelineMessages.CAM_JOB_FILTER_TOOLTIP);
        field.addFieldModifiedListener(textField -> {
            camsPanel.setJobFilter(textField.getText().trim());
            FilterToolbar.updateCamJobFilterValidity(camsPanel, textField);
        });
        FilterToolbar.updateCamJobFilterValidity(camsPanel, field);
        field.setLayoutData(new BlockToolbar.LayoutData().setGap(4).setMinimumWidth(100).setFill());
        this.add(field);
        this.addShowHideInfoButton();
    }

    private void addProcessWidgets() {
        BlockLabel label = new BlockLabel("Show processes/threads: ", 131072);
        label.setLayoutData(new BlockToolbar.LayoutData().setMinimumWidth(100).setFill().setGap(4));
        this.add(label);
        BlockPopupMenu popup = new BlockPopupMenu();
        popup.setToolTip("Select whether to show processes, threads, or both");
        popup.addMenuItem("Processes", (Object)IProcessDataProvider.ThreadMode.PROCESS_ONLY);
        popup.addMenuItem("Threads", (Object)IProcessDataProvider.ThreadMode.THREAD_ONLY);
        popup.addMenuItem("Both", (Object)IProcessDataProvider.ThreadMode.PROCESS_AND_THREADS);
        popup.selectItemWithData((Object)this.mContent.getCaptureDataProvider().getProcessDataProvider().getThreadMode());
        popup.addPopupMenuItemSelectionListener((popupMenu, itemIndex, data) -> {
            IProcessDataProvider.ThreadMode threadMode = (IProcessDataProvider.ThreadMode)((Object)((Object)data));
            this.mContent.getCaptureDataProvider().getProcessDataProvider().setThreadMode(threadMode);
        });
        popup.setLayoutData(new BlockToolbar.LayoutData().setMinimumWidth(100).setGap(4));
        this.add(popup);
    }

    private final void addHeatMapFilter(boolean enablePerCoreCheckbox, boolean enableAnnotationsFilter) {
        this.mHeatMapFilterField = new BlockTextField(this.mContent.getHeatMapFilter());
        this.mHeatMapFilterField.setWatermark(TimelineMessages.HEAT_MAP_FILTER);
        this.mHeatMapFilterField.setToolTip(TimelineMessages.HEAT_MAP_FILTER_TOOLTIP);
        this.mHeatMapFilterField.addFieldModifiedListener(textField -> {
            this.mContent.setHeatMapFilter(textField.getText().trim());
            this.updateHeatMapFilterValidity(textField);
        });
        this.updateHeatMapFilterValidity(this.mHeatMapFilterField);
        this.mHeatMapFilterField.setLayoutData(new BlockToolbar.LayoutData().setMinimumWidth(100).setFill());
        this.add(this.mHeatMapFilterField);
        if (enableAnnotationsFilter) {
            BlockTextField field = new BlockTextField(this.mContent.getAnnotationFilter());
            field.setWatermark(TimelineMessages.ANNOTATION_FILTER);
            field.setToolTip(TimelineMessages.ANNOTATION_FILTER_TOOLTIP);
            field.addFieldModifiedListener(textField -> {
                this.mContent.setAnnotationFilter(textField.getText().trim());
                this.updateAnnotationFilterValidity(textField);
            });
            this.updateAnnotationFilterValidity(field);
            field.setLayoutData(new BlockToolbar.LayoutData().setMinimumWidth(100).setFill().setGap(4));
            this.add(field);
        }
        if (enablePerCoreCheckbox) {
            BlockCheckBox perCore = new BlockCheckBox(TimelineMessages.HEATMAP_AVERAGE_PER_CORE, TimelineMessages.HEATMAP_AVERAGE_PER_CORE_TOOLTIP);
            perCore.setEnabled(true);
            perCore.setChecked(this.mContent.isHeatmapAveragePerCore());
            perCore.addCheckBoxListener(e -> this.mContent.setHeatmapAveragePerCore(e.isChecked()));
            perCore.setLayoutData(new BlockToolbar.LayoutData().setGap(4));
            this.add(perCore);
        }
        BlockPopupMenu popup = new BlockPopupMenu();
        popup.setToolTip(TimelineMessages.FOCUS_SOURCE_TOOLTIP);
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        for (String source : cdp.getFocusSources()) {
            popup.addMenuItem(source, source);
        }
        popup.selectItemWithData(cdp.getFocusSource());
        popup.addPopupMenuItemSelectionListener((popupMenu, itemIndex, data) -> {
            String source = (String)data;
            ICaptureDataProvider dataProvider = this.mContent.getCaptureDataProvider();
            if (!source.equals(dataProvider.getFocusSource())) {
                dataProvider.setFocusSource(source);
                this.mContent.notifyFocusChartListeners();
            }
        });
        this.add(popup);
    }

    private final void addMenuItem(String imgName, String name, char key, String id) {
        if (key != '\u0000') {
            char altKey = Character.isLowerCase(key) ? Character.toUpperCase(key) : Character.toLowerCase(key);
            BlockRoot root = this.mContent.getContentWrapper().getRoot();
            if (root.isKeyHandlerUsed(key) || root.isKeyHandlerUsed(altKey)) {
                key = '\u0000';
            } else {
                root.addKeyHandler(() -> this.mContent.setDetailAreaMode(id), key, altKey);
            }
        }
        this.mPanelDropDown.addMenuItem(StreamlinePlugin.getImage(imgName), BaseTimelineContent.adjustTitleForHotKey(name, key), id);
    }

    private final void updateAnnotationFilterValidity(BlockTextField field) {
        field.setValid(this.mContent.getAnnotationFilter().isEmpty() || this.mContent.getAnnotationFilterPattern() != null);
    }

    private final void updateHeatMapFilterValidity(BlockTextField field) {
        field.setValid(this.mContent.getHeatMapFilter().isEmpty() || this.mContent.getHeatMapFilterPattern() != null);
    }

    @Override
    public void handleUniqueThreadSelection(IUniqueID[] uniqueIds) {
        String mode = this.mContent.getDetailAreaMode();
        if (mode != "heat" && mode != "core" && mode != "cluster") {
            this.mContent.setDetailAreaMode("heat");
        }
        this.mHeatMapFilterField.setText("");
        ((HeatMapWrapper)this.mContent.getBottomPanel()).getHeatMapsPanel().handleUniqueThreadSelection(uniqueIds);
    }
}

