/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.report;

import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.jni.apcdbgen.proto.CallPathNode;
import com.arm.streamline.jni.apcdbgen.proto.IExtractable;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import com.arm.streamline.jni.reportmodel.icounters.CallPathFunctionRowValue;
import com.arm.streamline.jni.reportmodel.icounters.CallPathRowValue;
import com.arm.streamline.jni.reportmodel.icounters.FunctionRowValue;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.IAnalysisProvider;
import com.arm.streamline.model.iterable.CallPathSelectionIterator;
import com.arm.streamline.model.iterable.FunctionSelectionIterator;
import com.arm.streamline.model.iterable.SelectionIterator;
import com.arm.streamline.model.iterable.SourceFileSelectionIterator;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.selection.ReadOnlyStdSelection;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class AnalysisOutline<T extends IExtractable>
extends Outline<EnumColumn<T>>
implements IAnalysisProvider {
    private final @NonNull Analysis analysis;
    private final @NonNull ISelectionMatcher<T, ?> selectionMatcher;

    private static <T extends IExtractable, U> void collectMatches(@NonNull List<@NonNull Row<EnumColumn<T>>> rows, @NonNull Set<@NonNull U> selectedItems, @NonNull Row<EnumColumn<T>> row, @NonNull BiPredicate<@NonNull T, @NonNull Set<@NonNull U>> predicate) {
        if (row.hasChildren()) {
            for (Row child : (List)NullChecking.neverNull(row.getChildren())) {
                AnalysisOutline.collectMatches(rows, selectedItems, child, predicate);
            }
        }
        if (predicate.test(((ReportRow)row).getModelObject(), selectedItems)) {
            rows.add(row);
            row.disclose();
        }
    }

    public AnalysisOutline(@NonNull Analysis analysis, @NonNull Composite parent, @NonNull OutlineModel<EnumColumn<T>> model, @NonNull ISelectionMatcher<T, ?> selectionMatcher, boolean showIndent) {
        super(parent, model, false, showIndent);
        this.analysis = analysis;
        this.selectionMatcher = selectionMatcher;
    }

    @Override
    public @Nullable Analysis getAnalysis() {
        return this.analysis;
    }

    @Override
    public void setSelection(ISelection selection) {
        if (selection == null) {
            return;
        }
        if (selection instanceof ReadOnlyStdSelection) {
            super.setSelection(selection);
        } else {
            this.selectionMatcher.applySelection(selection, this.analysis, this::selectionConsumer);
        }
    }

    private <U> void selectionConsumer(@NonNull Set<@NonNull U> selectedItems, @NonNull BiPredicate<@NonNull T, @NonNull Set<@NonNull U>> predicate) {
        if (!selectedItems.isEmpty()) {
            OutlineModel<EnumColumn<T>> model = this.getModel();
            ArrayList<Row<EnumColumn<T>>> rows = new ArrayList<Row<EnumColumn<T>>>();
            for (Row<EnumColumn<T>> row : model.getTopLevelRows()) {
                AnalysisOutline.collectMatches(rows, selectedItems, row, predicate);
            }
            model.select(rows, false);
            Display display = this.getDisplay();
            if (display != null) {
                display.asyncExec(() -> {
                    if (!this.isDisposed()) {
                        this.scrollSelectionIntoView(true);
                    }
                });
            }
        }
    }

    public static interface ISelectionMatcher<T, U> {
        public static @NonNull ISelectionMatcher<CallPathFunctionRowValue, ReferencedSymbol> forCallPathFunctions() {
            return (selection, analysis, consumer) -> {
                Set<CallPathNode> callpathSet = SelectionIterator.toSet(new CallPathSelectionIterator(selection, analysis));
                Set<ReferencedSymbol> functionSet = SelectionIterator.toSet(new FunctionSelectionIterator(selection));
                callpathSet.forEach(c -> {
                    ReferencedSymbol f = c.symbol;
                    if (f != null) {
                        functionSet.add(f);
                    }
                });
                consumer.accept(functionSet, ISelectionMatcher.mappedSetContains(v -> v.getReferencedSymbol()));
            };
        }

        public static @NonNull ISelectionMatcher<CallPathRowValue, CallPathNode> forCallPaths() {
            return (selection, analysis, consumer) -> consumer.accept(SelectionIterator.toSet(new CallPathSelectionIterator(selection, analysis)), ISelectionMatcher.mappedSetContains(v -> v.getCallPathNode()));
        }

        public static @NonNull ISelectionMatcher<ReferencedSymbol, ReferencedSymbol> forFunctions() {
            return (selection, analysis, consumer) -> consumer.accept(SelectionIterator.toSet(new FunctionSelectionIterator(selection)), ISelectionMatcher::setContains);
        }

        public static @NonNull ISelectionMatcher<FunctionRowValue, ReferencedSymbol> forFunctionView() {
            return (selection, analysis, consumer) -> consumer.accept(SelectionIterator.toSet(new FunctionSelectionIterator(selection)), ISelectionMatcher.mappedSetContains(v -> v.getReferencedSymbol()));
        }

        public static <T, U> @NonNull ISelectionMatcher<T, U> forNone() {
            return (selection, analysis, consumer) -> {};
        }

        public static @NonNull ISelectionMatcher<SourceFile, SourceFile> forSourceFiles() {
            return (selection, analysis, consumer) -> consumer.accept(SelectionIterator.toSet(new SourceFileSelectionIterator(selection)), ISelectionMatcher::setContains);
        }

        private static <T, U> @NonNull BiPredicate<@NonNull T, @NonNull Set<@NonNull U>> mappedSetContains(@NonNull Function<@NonNull T, @NonNull U> mapper) {
            return (v, s) -> {
                Object f = mapper.apply(v);
                for (Object e : s) {
                    if (!f.equals(e)) continue;
                    return true;
                }
                return false;
            };
        }

        private static <T> boolean setContains(@NonNull T val, @NonNull Set<@NonNull T> set) {
            return set.contains(val);
        }

        public void applySelection(@NonNull ISelection var1, @NonNull Analysis var2, @NonNull BiConsumer<@NonNull Set<@NonNull U>, @NonNull BiPredicate<@NonNull T, @NonNull Set<@NonNull U>>> var3);
    }
}

