/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.function;

import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.EditorTab;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.IUpdateOnDisplayTab;
import com.arm.streamline.editortabs.InstructionCounterOutlineUpdater;
import com.arm.streamline.editortabs.InstructionCountersViewModel;
import com.arm.streamline.editortabs.InstructionCountersViewUtils;
import com.arm.streamline.editortabs.OpenSourceFileAction;
import com.arm.streamline.editortabs.StreamlineContextMenu;
import com.arm.streamline.editortabs.callpath.ToggleCallStacksGroupingAction;
import com.arm.streamline.editortabs.callpath.ToggleFilterCallStacksAction;
import com.arm.streamline.editortabs.callpath.ToggleFilterKernelAddressesAction;
import com.arm.streamline.editortabs.callpath.ToggleUseInlinesAction;
import com.arm.streamline.editortabs.function.FunctionColumn;
import com.arm.streamline.editortabs.function.FunctionContributor;
import com.arm.streamline.editortabs.function.FunctionMessages;
import com.arm.streamline.editortabs.function.FunctionRow;
import com.arm.streamline.editortabs.function.IFunctionColumn;
import com.arm.streamline.editortabs.report.AnalysisOutline;
import com.arm.streamline.editortabs.report.ExportTableAction;
import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.jni.apcdbgen.proto.CallPathNode;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterColumnAccessorFactory;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReportData;
import com.arm.streamline.jni.reportmodel.icounters.CallPathRowValue;
import com.arm.streamline.jni.reportmodel.icounters.FunctionRowValue;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterSource;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.utility.CommandAction;
import com.arm.streamline.utility.ICommandTarget;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.streamline.widget.FilterField;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.ToolbarReadout;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.Header;
import com.arm.streamline.widget.outline.IOutlineListener;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.selection.StdSelection;
import com.arm.utils.NullChecking;
import gnu.trove.TIntCollection;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.LongFunction;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.ActionFactory;

public class FunctionTab
extends EditorTab
implements FilterField.IFilterMatcher,
ICommandTarget,
IOutlineListener<EnumColumn<FunctionRowValue>>,
ISelectionChangedListener,
IUpdateOnDisplayTab {
    private FilterField mFilterField;
    private AnalysisOutline<FunctionRowValue> mFunctionOutline;
    private ToolbarReadout mSamplesField;
    private @Nullable TIntSet previouslySelectedPidsAndTids;
    private ToolbarReadout mTotalsField;
    private InstructionCounterFunctionOutlineUpdater updateListener;
    private @Nullable ToggleFilterCallStacksAction filterCallStacksAction;
    private @Nullable ToggleFilterKernelAddressesAction filterKernelAddressesAction;
    private @Nullable ToggleUseInlinesAction useInlinesAction;
    private @Nullable ToggleCallStacksGroupingAction toggleCallStacksGroupingAction;
    private @NonNull List<@NonNull FunctionRowValue> mappedRowValues = Collections.emptyList();

    public FunctionTab(@NonNull AnalysisEditor editor, BaseTimelineContent baseTimelineContent) {
        super(editor, baseTimelineContent);
        this.init();
    }

    @Override
    public void deleteSelectionRequested(Outline<EnumColumn<FunctionRowValue>> outline) {
    }

    @Override
    public void editorChanged(Outline<EnumColumn<FunctionRowValue>> outline) {
    }

    @Override
    public void dispose() {
        if (this.updateListener != null) {
            this.getInstructionCounterViewModel().propertyCurrentSelectedSource().removeValueChangeListener((IValueChangeListener)this.updateListener);
        }
        super.dispose();
    }

    @Override
    public void findMatches(FilterField field) {
        String config = this.mFunctionOutline.getConfig();
        OutlineModel model = this.mFunctionOutline.getModel();
        HashSet<FunctionRowValue> selected = new HashSet<FunctionRowValue>();
        ArrayList<@NonNull FunctionRow> selection = new ArrayList<FunctionRow>();
        ArrayList<@NonNull FunctionRow> rows = new ArrayList<FunctionRow>();
        for (Row row : model.getSelectionAsList()) {
            selected.add((FunctionRowValue)((FunctionRow)row).getModelObject());
        }
        this.mFunctionOutline.setAllowLazyAdjust(false);
        boolean canNotify = model.getSelection().canNotify();
        model.getSelection().setNotify(false);
        model.removeAllRows();
        Pattern pattern = field.getPattern();
        for (FunctionRowValue function : this.mappedRowValues) {
            if (!pattern.matcher(function.getName()).find()) continue;
            FunctionRow row = new FunctionRow(function);
            rows.add(row);
            if (!selected.contains(function)) continue;
            selection.add(row);
        }
        model.addNonHierarchicalRowsFast(rows);
        this.mFunctionOutline.applyConfig(config, true, true);
        this.mFunctionOutline.setAllowLazyAdjust(true);
        model.getSelection().setNotify(canNotify);
        this.mFunctionOutline.adjustScrollBarsForContent();
        if (!selection.isEmpty()) {
            model.select(selection, false);
        }
        this.mFunctionOutline.notifyOfSelectionChange();
    }

    public AnalysisOutline<FunctionRowValue> getFunctionOutline() {
        return this.mFunctionOutline;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.mFunctionOutline;
    }

    @Override
    public void obeyCommand(CommandAction commandAction) {
        String command = commandAction.getCommand();
        if (!this.mFilterField.handleCommand(command) && this.mFunctionOutline.isFocusControl()) {
            this.mFunctionOutline.obeyCommand(commandAction);
        }
    }

    @Override
    public void onTabDisplayed() {
        this.reloadOutline(false);
    }

    private void reloadOutline(boolean force) {
        boolean newIsEmpty;
        @NonNull InstructionCountersViewModel instructionCounterViewModel = this.getInstructionCounterViewModel();
        @Nullable IInstructionCounterSource instructionCounterSource = (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue();
        BaseTimelineContent baseTimelineContent = this.getBaseTimelineContent();
        TIntSet newlySelectedPidsAndTids = baseTimelineContent == null ? null : baseTimelineContent.getSelectedProcessAndThreadIds();
        TIntSet previouslySelectedPidsAndTids = this.previouslySelectedPidsAndTids;
        boolean previousIsEmpty = previouslySelectedPidsAndTids == null || previouslySelectedPidsAndTids.isEmpty();
        boolean bl = newIsEmpty = newlySelectedPidsAndTids == null || newlySelectedPidsAndTids.isEmpty();
        if (newIsEmpty) {
            if (force || !previousIsEmpty) {
                this.previouslySelectedPidsAndTids = null;
                this.updateListener.recomputeFromModelChange(instructionCounterSource);
            }
        } else if (force || previousIsEmpty || !NullChecking.equalsNullable((Object)previouslySelectedPidsAndTids, (Object)newlySelectedPidsAndTids)) {
            TIntHashSet copyOfNew = new TIntHashSet((TIntCollection)newlySelectedPidsAndTids);
            this.previouslySelectedPidsAndTids = copyOfNew;
            this.updateListener.recomputeFromModelChange(instructionCounterSource);
        }
    }

    @Override
    public void openSelectionRequested(Outline<EnumColumn<FunctionRowValue>> outline) {
        OutlineModel<EnumColumn<FunctionRowValue>> model = outline.getModel();
        StdSelection selection = model.getSelection();
        int index = selection.firstSelectedIndex();
        ArrayList<FunctionRowValue> functions = new ArrayList<FunctionRowValue>();
        while (index >= 0) {
            functions.add((FunctionRowValue)((FunctionRow)model.getRowAtIndex(index)).getModelObject());
            index = selection.nextSelectedIndex(index + 1);
        }
        if (!functions.isEmpty()) {
            this.requireEditor().select(EditorTabID.CODE, (ISelection)new StructuredSelection(functions.toArray()));
        }
    }

    @Override
    public void recomputeFromModel() {
        final AnalysisOutline<FunctionRowValue> functionOutline = this.mFunctionOutline;
        Task.callOnUIThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!functionOutline.isDisposed()) {
                    FunctionTab.this.reloadOutline(true);
                }
            }
        });
    }

    public void select(FunctionRowValue ... functions) {
        OutlineModel model = this.mFunctionOutline.getModel();
        ArrayList<@NonNull Row<C>> rows = new ArrayList();
        HashSet<FunctionRowValue> set = new HashSet<FunctionRowValue>();
        FunctionRowValue[] functionRowValueArray = functions;
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            FunctionRowValue obj = functionRowValueArray[n2];
            set.add(obj);
            ++n2;
        }
        for (Row row : model.getRows()) {
            if (!set.contains(((FunctionRow)row).getModelObject())) continue;
            rows.add(row);
        }
        model.select(rows, false);
        this.mFunctionOutline.scrollSelectionIntoView(true);
    }

    @Override
    public void selectionChanged(Outline<EnumColumn<FunctionRowValue>> outline) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        @NonNull InstructionCountersViewModel instructionCounterViewModel = this.getInstructionCounterViewModel();
        @Nullable IInstructionCounterSource instructionCounterSource = (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue();
        List rows = this.mFunctionOutline.getModel().getSelectionAsList();
        int count = rows.size();
        @NonNull String text = instructionCounterSource != null && !rows.isEmpty() ? FunctionTab.calculateFunctionTabSelectionText(instructionCounterSource, rows.stream().map(row -> (FunctionRow)row).map(ReportRow::getModelObject)) : FunctionMessages.NA;
        boolean needLayout = false;
        needLayout |= this.mTotalsField.setText(NumberUtils.prettyFormat((int)count));
        if (needLayout |= this.mSamplesField.setText(text)) {
            SafeUpdate.layout(this.getToolbar());
        }
    }

    private static @NonNull String calculateFunctionTabSelectionText(@NonNull IInstructionCounterSource source, @NonNull Stream<@NonNull FunctionRowValue> selectionStream) {
        ISampleCounterColumnAccessorFactory.PercentAndLong value = source.calculateFunctionTabSelectionValue(selectionStream);
        if (value == null) {
            return FunctionMessages.NA;
        }
        return MessageFormat.format(FunctionMessages.FORMAT, NumberUtils.format((long)value.value()), NumberUtils.formatPercentage((double)value.percent(), (boolean)false));
    }

    public boolean setFocus() {
        return this.mFunctionOutline.setFocus();
    }

    @Override
    public void sourceFilePathChanged() {
        this.mFunctionOutline.redraw();
    }

    @Override
    protected Composite createContent() {
        Composite content = new Composite((Composite)this, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(content);
        this.createFunctionOutline(content);
        return content;
    }

    @Override
    protected void fillToolbar(CustomToolbar toolbar) {
        @NonNull Analysis analysis = this.getAnalysis();
        @NonNull InstructionCountersViewModel instructionCountersViewModel = this.getInstructionCounterViewModel();
        @NonNull AnalysisOutline mFunctionOutline = (AnalysisOutline)NullChecking.neverNull(this.mFunctionOutline);
        if (analysis.canFilterStacksDynamically()) {
            this.filterCallStacksAction = new ToggleFilterCallStacksAction(analysis);
            toolbar.addAction(this.filterCallStacksAction);
            this.filterKernelAddressesAction = new ToggleFilterKernelAddressesAction(analysis);
            toolbar.addAction(this.filterKernelAddressesAction);
            this.toggleCallStacksGroupingAction = new ToggleCallStacksGroupingAction(analysis);
            toolbar.addAction(this.toggleCallStacksGroupingAction);
            this.useInlinesAction = new ToggleUseInlinesAction(analysis);
            toolbar.addAction(this.useInlinesAction);
        }
        toolbar.addAction(new OpenSourceFileAction(analysis::computeFullPath, mFunctionOutline, analysis::showPathSubstitutionDialog)).setLayoutData(new CustomToolbar.LayoutData().setGap(1));
        InstructionCountersViewUtils.createSelectCurrentSourceCombo(instructionCountersViewModel, this.ctx, toolbar, new CustomToolbar.LayoutData().setFillRowHeight().setMinimumWidth(50).setGap(5).setExcludeHidden());
        this.mFilterField = new FilterField(toolbar, this, FunctionMessages.FILTER, FunctionMessages.FILTER_TOOLTIP);
        this.mFilterField.setLayoutData(new CustomToolbar.LayoutData().setFill().setMinimumWidth(100).setGap(5));
        this.mTotalsField = new ToolbarReadout(toolbar, NumberUtils.prettyFormat((int)0), 131072, FunctionMessages.TOTAL_TOOLTIP);
        this.mTotalsField.setDesiredMinimumTextWidth(FontInfo.get(this.mTotalsField.getFont()).getWidth("000"));
        this.mTotalsField.setLayoutData(new CustomToolbar.LayoutData().setMinimumWidth(this.mTotalsField.computeSize((int)-1, (int)-1).x).setGap(5));
        this.mSamplesField = new ToolbarReadout(toolbar, FunctionMessages.NA, 131072, FunctionMessages.SAMPLES_TOOLTIP);
        this.mSamplesField.setDesiredMinimumTextWidth(FontInfo.get(this.mSamplesField.getFont()).getWidth("0000000000000000"));
        this.mSamplesField.setLayoutData(new CustomToolbar.LayoutData().setMinimumWidth(this.mSamplesField.computeSize((int)-1, (int)-1).x).setGap(5));
        toolbar.addAction(new ExportTableAction(analysis, mFunctionOutline, "functions_for_{0}.csv"));
        this.updateListener.refresh();
    }

    @Override
    protected String getHelpID() {
        return "com.arm.streamline.functions";
    }

    @Override
    protected void initActionMap(Map<String, IAction> map) {
        String id = ActionFactory.SELECT_ALL.getId();
        map.put(id, (IAction)new CommandAction(id, this));
        id = ActionFactory.COPY.getId();
        map.put(id, (IAction)new CommandAction(id, this));
    }

    protected final void loadFunctionOutline(@Nullable IInstructionCounterSource instructionCounterSource, @Nullable TIntSet selectedPidsAndTids) {
        Pattern pattern;
        String config = this.mFunctionOutline.getConfig();
        this.mFunctionOutline.setAllowLazyAdjust(false);
        OutlineModel outlineModel = this.mFunctionOutline.getModel();
        boolean canNotify = outlineModel.getSelection().canNotify();
        outlineModel.getSelection().setNotify(false);
        outlineModel.removeAllRows();
        Pattern pattern2 = pattern = this.mFilterField != null && !this.mFilterField.getText().trim().isEmpty() ? this.mFilterField.getPattern() : null;
        if (instructionCounterSource != null) {
            this.mappedRowValues = instructionCounterSource.getSymbols();
            List mappedRowValues = this.mappedRowValues;
            if (mappedRowValues.size() > 10000) {
                for (EnumColumn column : outlineModel.getColumns()) {
                    @NonNull IFunctionColumn one = (IFunctionColumn)column.getColumnEnum();
                    column.setDefaultPreferredWidth(Math.min(one.getPreferredWidth(instructionCounterSource) + 12, column.getMaxWidth()));
                }
            }
            ArrayList<FunctionRow> rows = new ArrayList<FunctionRow>();
            if (selectedPidsAndTids == null || selectedPidsAndTids.isEmpty()) {
                StreamSupport.stream(mappedRowValues.spliterator(), false).filter(function -> pattern == null || pattern.matcher(function.getName()).find()).map(FunctionRow::new).forEach(f -> {
                    if (f != null) {
                        rows.add((FunctionRow)f);
                    }
                });
            } else {
                for (FunctionRowValue function2 : mappedRowValues) {
                    boolean matchesCallPathFilter;
                    if (pattern != null && !pattern.matcher(function2.getName()).find() || !(matchesCallPathFilter = function2.getAssociatedCallPaths().stream().map(cp -> cp.getOwningThreadOrProcessRow()).anyMatch(row -> row != null && FunctionTab.isSelectedPidOrTid(selectedPidsAndTids, row)))) continue;
                    rows.add(new FunctionRow(function2));
                }
            }
            outlineModel.addNonHierarchicalRowsFast(rows);
        }
        this.mFunctionOutline.applyConfig(config, true, true);
        this.mFunctionOutline.setAllowLazyAdjust(true);
        this.mFunctionOutline.sizeColumnsToFit();
        outlineModel.getSelection().setNotify(canNotify);
        this.mFunctionOutline.getDefaultConfig();
        this.mFunctionOutline.adjustScrollBarsForContent();
    }

    private static boolean isSelectedPidOrTid(@NonNull TIntSet selectedPidsAndTids, @NonNull CallPathRowValue row) {
        switch (row.getCallPathNode().type) {
            case PROCESS: {
                return selectedPidsAndTids.contains(Math.toIntExact(row.getCallPathNode().itemUID));
            }
            case THREAD: {
                if (selectedPidsAndTids.contains(Math.toIntExact(row.getCallPathNode().itemUID))) {
                    return true;
                }
                CallPathRowValue process = row.getParent();
                if (process != null && process.getCallPathNode().type == CallPathNode.Type.PROCESS) {
                    return selectedPidsAndTids.contains(Math.toIntExact(process.getCallPathNode().itemUID));
                }
                return false;
            }
        }
        throw new AssertionError(row);
    }

    private Composite createFunctionOutline(Composite parent) {
        @NonNull Analysis analysis = this.getAnalysis();
        @NonNull InstructionCountersViewModel instructionCounterViewModel = this.getInstructionCounterViewModel();
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)wrapper);
        Header header = new Header(wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(header);
        OutlineModel model = new OutlineModel();
        AnalysisOutline<FunctionRowValue> mFunctionOutline = new AnalysisOutline<FunctionRowValue>(analysis, wrapper, model, AnalysisOutline.ISelectionMatcher.forFunctionView(), false);
        this.mFunctionOutline = mFunctionOutline;
        GridDataFactory.fillDefaults().grab(true, true).applyTo(mFunctionOutline);
        BaseTimelineContent baseTimelineContent = this.getBaseTimelineContent();
        TIntSet selectedPidsAndTids = baseTimelineContent == null ? null : baseTimelineContent.getSelectedProcessAndThreadIds();
        this.previouslySelectedPidsAndTids = selectedPidsAndTids != null && !selectedPidsAndTids.isEmpty() ? new TIntHashSet((TIntCollection)selectedPidsAndTids) : null;
        mFunctionOutline.addOutlineListener(this);
        mFunctionOutline.addSelectionChangedListener(this);
        mFunctionOutline.setHeader(header);
        ContextMenu cm = StreamlineContextMenu.createStdContextMenu(this.getEditor(), mFunctionOutline, new EditorTabID[]{EditorTabID.FUNCTIONS});
        cm.add(new FunctionContributor(() -> FunctionTab.createFunctionMenuContributionSorters(instructionCounterViewModel)));
        this.updateListener = new InstructionCounterFunctionOutlineUpdater(mFunctionOutline, (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue());
        instructionCounterViewModel.propertyCurrentSelectedSource().addValueChangeListener((IValueChangeListener)this.updateListener);
        return wrapper;
    }

    private static @NonNull List<@NonNull FunctionContributor.IFunctionContributorSortProperties> createFunctionMenuContributionSorters(@NonNull InstructionCountersViewModel instructionCounterViewModel) {
        FunctionContributor.IFunctionContributorSortProperties totalResult;
        IInstructionCounterSource source = (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue();
        if (source == null) {
            return Collections.emptyList();
        }
        ISamplesReportData ard = source.getActiveReportData();
        final LongFunction supplierSelf = ard.getTopCallpathsMetricSupplier(false);
        final LongFunction supplierTotal = ard.getTopCallpathsMetricSupplier(true);
        FunctionContributor.IFunctionContributorSortProperties selfResult = supplierSelf != null ? new FunctionContributor.IFunctionContributorSortProperties(){

            @Override
            public @NonNull String getName() {
                return FunctionMessages.TOP_LINKS_BY_SELF;
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong getMetric(@NonNull CallPathNode callPath) {
                return (ISampleCounterColumnAccessorFactory.PercentAndLong)supplierSelf.apply(callPath.uid);
            }
        } : null;
        FunctionContributor.IFunctionContributorSortProperties iFunctionContributorSortProperties = totalResult = supplierTotal != null ? new FunctionContributor.IFunctionContributorSortProperties(){

            @Override
            public @NonNull String getName() {
                return FunctionMessages.TOP_LINKS_BY_TOTAL;
            }

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong getMetric(@NonNull CallPathNode callPath) {
                return (ISampleCounterColumnAccessorFactory.PercentAndLong)supplierTotal.apply(callPath.uid);
            }
        } : null;
        return selfResult != null ? (totalResult != null ? List.of(selfResult, totalResult) : List.of(selfResult)) : (totalResult != null ? List.of(totalResult) : Collections.emptyList());
    }

    private @NonNull InstructionCountersViewModel getInstructionCounterViewModel() {
        return this.requireEditor().requireInstructionCountersViewModel();
    }

    private void updateFilterActions(boolean filterEnabled, boolean groupByEnabled, boolean invertEnabled) {
        ToggleFilterCallStacksAction filterCallStacksAction = this.filterCallStacksAction;
        ToggleFilterKernelAddressesAction filterKernelAddressesAction = this.filterKernelAddressesAction;
        ToggleUseInlinesAction useInlinesAction = this.useInlinesAction;
        ToggleCallStacksGroupingAction toggleCallStacksGroupingAction = this.toggleCallStacksGroupingAction;
        if (filterCallStacksAction != null) {
            filterCallStacksAction.setEnabled(filterEnabled);
        }
        if (filterKernelAddressesAction != null) {
            filterKernelAddressesAction.setEnabled(filterEnabled);
        }
        if (useInlinesAction != null) {
            useInlinesAction.setEnabled(groupByEnabled);
        }
        if (toggleCallStacksGroupingAction != null) {
            toggleCallStacksGroupingAction.setEnabled(invertEnabled);
        }
    }

    public final class InstructionCounterFunctionOutlineUpdater
    extends InstructionCounterOutlineUpdater<FunctionRowValue, IFunctionColumn> {
        public InstructionCounterFunctionOutlineUpdater(@Nullable AnalysisOutline<FunctionRowValue> outline, IInstructionCounterSource instructionCounterSource) {
            super(outline, instructionCounterSource, false);
        }

        @Override
        public void recomputeFromPreferTotalsChange(boolean preferTotal) {
            throw new AssertionError((Object)"FunctionTab.recomputeFromPreferTotalsChange should not be called");
        }

        @Override
        protected @NonNull Iterable<@NonNull IFunctionColumn> aggregateColumns(@Nullable IInstructionCounterSource instructionCounterSource, boolean preferTotal) {
            assert (!preferTotal);
            return FunctionColumn.aggregateColumns(instructionCounterSource);
        }

        @Override
        protected void populateOutline(@Nullable IInstructionCounterSource instructionCounterSource) {
            FunctionTab.this.loadFunctionOutline(instructionCounterSource, FunctionTab.this.previouslySelectedPidsAndTids);
        }

        @Override
        protected void updateOtherUiElements(@Nullable IInstructionCounterSource instructionCounterSource) {
            FunctionTab.this.updateFilterActions(instructionCounterSource != null && instructionCounterSource.canFilterStacksDynamically(), instructionCounterSource != null, instructionCounterSource != null);
        }
    }
}

