/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.code;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.editortabs.code.CodeMessages;
import com.arm.streamline.editortabs.code.CodeTab;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.utils.text.SWTLabelFilter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class RecentFunctionsAction
extends Action
implements IMenuCreator,
SelectionListener {
    private Menu mMenu;
    private CodeTab mOwner;

    public RecentFunctionsAction(CodeTab owner) {
        super(CodeMessages.RECENTLY_SELECTED_FUNCTIONS, StreamlinePlugin.getImageDescriptor("Functions.png"));
        this.mOwner = owner;
        this.setMenuCreator(this);
        this.setEnabled(false);
    }

    public void dispose() {
        if (this.mMenu != null) {
            this.mMenu.dispose();
            this.mMenu = null;
        }
    }

    public Menu getMenu(Control parent) {
        this.mMenu = new Menu(parent);
        this.fillMenu(this.mMenu);
        return this.mMenu;
    }

    public Menu getMenu(Menu parent) {
        this.mMenu = new Menu(parent);
        this.fillMenu(this.mMenu);
        return this.mMenu;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        MenuItem item = (MenuItem)event.widget;
        ReferencedSymbol function = (ReferencedSymbol)item.getData();
        this.mOwner.select(function);
    }

    private void fillMenu(Menu menu) {
        ReferencedSymbol[] functions;
        ReferencedSymbol[] referencedSymbolArray = functions = this.mOwner.getSourcePanel().getRecentFunctions();
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            ReferencedSymbol function = referencedSymbolArray[n2];
            MenuItem item = new MenuItem(menu, 8);
            item.setText(SWTLabelFilter.filterForMenuOrLabel((String)function.symbol.getName()));
            item.setImage(StreamlinePlugin.getImage("Function.png"));
            item.setData((Object)function);
            item.addSelectionListener((SelectionListener)this);
            ++n2;
        }
    }
}

